/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.bogosorter.common.network;

import com.cleanroommc.bogosorter.BogoSortAPI;
import com.cleanroommc.bogosorter.api.SortRule;
import com.cleanroommc.bogosorter.common.network.IPacket;
import com.cleanroommc.bogosorter.common.sort.ClientSortData;
import com.cleanroommc.bogosorter.common.sort.NbtSortRule;
import com.cleanroommc.bogosorter.common.sort.SortHandler;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.PacketBuffer;

public class CSort
implements IPacket {
    private Collection<ClientSortData> clientSortDataList;
    private List<SortRule<ItemStack>> sortRules;
    private List<NbtSortRule> nbtSortRules;
    private int hover;
    private boolean player;

    public CSort(Collection<ClientSortData> clientSortDataList, List<SortRule<ItemStack>> sortRules, List<NbtSortRule> nbtSortRules, int hover, boolean player) {
        this.clientSortDataList = clientSortDataList;
        this.sortRules = sortRules;
        this.nbtSortRules = nbtSortRules;
        this.hover = hover;
        this.player = player;
    }

    public CSort() {
    }

    @Override
    public void encode(PacketBuffer buf) throws IOException {
        buf.func_150787_b(this.hover);
        buf.writeBoolean(this.player);
        buf.func_150787_b(this.clientSortDataList.size());
        for (ClientSortData clientSortData : this.clientSortDataList) {
            clientSortData.writeToPacket(buf);
        }
        buf.func_150787_b(this.sortRules.size());
        for (SortRule sortRule : this.sortRules) {
            buf.func_150787_b(sortRule.getSyncId());
            buf.writeBoolean(sortRule.isInverted());
        }
        buf.func_150787_b(this.nbtSortRules.size());
        for (NbtSortRule nbtSortRule : this.nbtSortRules) {
            buf.func_150787_b(nbtSortRule.getSyncId());
            buf.writeBoolean(nbtSortRule.isInverted());
        }
    }

    @Override
    public void decode(PacketBuffer buf) throws IOException {
        NbtSortRule sortRule;
        int i;
        this.hover = buf.func_150792_a();
        this.player = buf.readBoolean();
        this.clientSortDataList = new ArrayList<ClientSortData>();
        int n = buf.func_150792_a();
        for (i = 0; i < n; ++i) {
            this.clientSortDataList.add(ClientSortData.readFromPacket(buf));
        }
        this.sortRules = new ArrayList<SortRule<ItemStack>>();
        n = buf.func_150792_a();
        for (i = 0; i < n; ++i) {
            sortRule = BogoSortAPI.INSTANCE.getItemSortRule(buf.func_150792_a());
            sortRule.setInverted(buf.readBoolean());
            this.sortRules.add(sortRule);
        }
        this.nbtSortRules = new ArrayList<NbtSortRule>();
        n = buf.func_150792_a();
        for (i = 0; i < n; ++i) {
            sortRule = BogoSortAPI.INSTANCE.getNbtSortRule(buf.func_150792_a());
            sortRule.setInverted(buf.readBoolean());
            this.nbtSortRules.add(sortRule);
        }
    }

    @Override
    public IPacket executeServer(NetHandlerPlayServer handler) {
        SortHandler.cacheItemSortRules.put((EntityPlayer)handler.field_147369_b, this.sortRules);
        SortHandler.cacheNbtSortRules.put((EntityPlayer)handler.field_147369_b, this.nbtSortRules);
        Int2ObjectOpenHashMap map = new Int2ObjectOpenHashMap();
        for (ClientSortData sortData : this.clientSortDataList) {
            IntListIterator intListIterator = sortData.getSlotNumbers().iterator();
            while (intListIterator.hasNext()) {
                int i = (Integer)intListIterator.next();
                map.put(i, (Object)sortData);
            }
        }
        SortHandler sortHandler = new SortHandler((EntityPlayer)handler.field_147369_b, handler.field_147369_b.field_71070_bA, (Int2ObjectMap<ClientSortData>)map);
        sortHandler.sort(this.hover);
        return null;
    }
}

