/*
 * Decompiled with CFR 0.152.
 */
package stevesaddons.network.message;

import com.google.common.base.Throwables;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import stevesaddons.naming.NameData;
import stevesaddons.naming.NameRegistry;

public class WorldDataSyncMessage
implements IMessage,
IMessageHandler<WorldDataSyncMessage, IMessage> {
    public int dimId;
    public NBTTagCompound tagCompound = new NBTTagCompound();

    public WorldDataSyncMessage() {
    }

    public WorldDataSyncMessage(int dimId, NameData data) {
        this.dimId = dimId;
        data.func_76187_b(this.tagCompound);
    }

    public void fromBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        this.dimId = pb.readInt();
        try {
            this.tagCompound = pb.func_150793_b();
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public void toBytes(ByteBuf buf) {
        PacketBuffer pb = new PacketBuffer(buf);
        pb.writeInt(this.dimId);
        try {
            pb.func_150786_a(this.tagCompound);
        }
        catch (IOException e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    public IMessage onMessage(WorldDataSyncMessage message, MessageContext ctx) {
        NameRegistry.setWorldData(message);
        return null;
    }
}

