/*
 * Decompiled with CFR 0.152.
 */
package mods.railcraft.api.signals;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mods.railcraft.api.carts.CartTools;
import mods.railcraft.api.core.WorldCoordinate;
import mods.railcraft.api.signals.AbstractPair;
import mods.railcraft.api.signals.ISignalBlockTile;
import mods.railcraft.api.signals.SignalAspect;
import mods.railcraft.api.signals.SignalTools;
import mods.railcraft.api.tracks.RailTools;
import mods.railcraft.api.tracks.TrackScanner;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.message.Message;
import org.apache.logging.log4j.message.MessageFormatMessage;

public abstract class SignalBlock
extends AbstractPair {
    public static final int VALIDATION_CHECK_INTERVAL = 16384;
    private static final Level DEBUG_LEVEL = Level.INFO;
    private final Map<WorldCoordinate, WorldCoordinate> trackCache = new HashMap<WorldCoordinate, WorldCoordinate>();
    private final Map<WorldCoordinate, TrackScanner.ScanResult> trackScans = new HashMap<WorldCoordinate, TrackScanner.ScanResult>();
    private final Set<WorldCoordinate> waitingForRetest = new HashSet<WorldCoordinate>();
    private WorldCoordinate trackLocation;
    private int update = rand.nextInt();
    private boolean changedAspect = false;

    public SignalBlock(String locTag, TileEntity tile, int numPairs) {
        super(locTag, tile, numPairs);
    }

    private SignalBlock getSignalAt(WorldCoordinate coord) {
        TileEntity recv = this.getPairAt(coord);
        if (recv != null) {
            return ((ISignalBlockTile)recv).getSignalBlock();
        }
        return null;
    }

    public abstract SignalAspect getSignalAspect();

    public void log(Level level, String msg, Object ... args) {
        if (msg != null) {
            LogManager.getLogger((String)"Railcraft").log(level, (Message)new MessageFormatMessage(msg, args));
        }
    }

    private void printDebug(String msg, Object ... args) {
        if (SignalTools.printSignalDebug) {
            this.log(DEBUG_LEVEL, msg, args);
        }
    }

    private void printDebugPair(String msg, TileEntity ot) {
        if (SignalTools.printSignalDebug) {
            if (ot == null) {
                this.log(DEBUG_LEVEL, msg + " source:[{0}, {1}, {2}] target:[null]", this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
            } else {
                this.log(DEBUG_LEVEL, msg + " source:[{0}, {1}, {2}] target:[{3}, {4}, {5}] target class:{6}", this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, ot.field_145851_c, ot.field_145848_d, ot.field_145849_e, ot.getClass());
            }
        }
    }

    private void printDebugPair(String msg, WorldCoordinate coord) {
        if (SignalTools.printSignalDebug) {
            if (coord == null) {
                this.log(DEBUG_LEVEL, msg + " source:[{0}, {1}, {2}] target:[null]", this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
            } else {
                this.log(DEBUG_LEVEL, msg + " source:[{0}, {1}, {2}] target:[{3}, {4}, {5}]", this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, coord.x, coord.y, coord.z);
            }
        }
    }

    @Override
    protected void saveNBT(NBTTagCompound data) {
        super.saveNBT(data);
        NBTTagList tagList = new NBTTagList();
        for (Map.Entry<WorldCoordinate, WorldCoordinate> cache : this.trackCache.entrySet()) {
            NBTTagCompound entry = new NBTTagCompound();
            if (cache.getKey() == null || cache.getValue() == null) continue;
            cache.getKey().writeToNBT(entry, "key");
            cache.getValue().writeToNBT(entry, "value");
            tagList.func_74742_a((NBTBase)entry);
        }
        data.func_74782_a("trackCache", (NBTBase)tagList);
        this.printDebug("Signal Block saved NBT. [{0}, {1}, {2}] [changedAspect: {3}] [data: {4}]", this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, this.changedAspect, this.pairings);
    }

    @Override
    protected void loadNBT(NBTTagCompound data) {
        super.loadNBT(data);
        if (data.func_74764_b("trackCache")) {
            NBTTagList tagList = data.func_150295_c("trackCache", 10);
            for (int i = 0; i < tagList.func_74745_c(); ++i) {
                NBTTagCompound nbt = tagList.func_150305_b(i);
                WorldCoordinate key = WorldCoordinate.readFromNBT(nbt, "key");
                WorldCoordinate value = WorldCoordinate.readFromNBT(nbt, "value");
                this.trackCache.put(key, value);
            }
        }
        this.printDebug("Signal Block loaded NBT. [{0}, {1}, {2}] [data: {3}]", this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, this.pairings);
    }

    @Override
    public void clearPairing(WorldCoordinate other) {
        this.printDebugPair("Signal Block pair cleared. ", other);
        if (SignalTools.printSignalDebug) {
            int x = other.x;
            int y = other.y;
            int z = other.z;
            Block block = this.tile.func_145831_w().func_147439_a(x, y, z);
            if (block != null) {
                this.log(DEBUG_LEVEL, "Signal Block target block [{0}, {1}, {2}] = {3}, {4}", x, y, z, block.getClass(), block.func_149739_a());
            } else {
                this.log(DEBUG_LEVEL, "Signal Block target block [{0}, {1}, {2}] = null", x, y, z);
            }
            TileEntity t = this.tile.func_145831_w().func_147438_o(x, y, z);
            if (t != null) {
                this.log(DEBUG_LEVEL, "Signal Block target tile [{0}, {1}, {2}] = {3}", t.field_145851_c, t.field_145848_d, t.field_145849_e, t.getClass());
            } else {
                this.log(DEBUG_LEVEL, "Signal Block target tile [{0}, {1}, {2}] = null", x, y, z);
            }
        }
        super.clearPairing(other);
    }

    private void clearSignalBlockPairing(WorldCoordinate other, String reason, Object ... args) {
        this.printDebug(reason, args);
        if (other == null) {
            this.clearPairings();
        } else {
            this.clearPairing(other);
        }
    }

    @Override
    protected void addPairing(WorldCoordinate other) {
        this.pairings.remove(other);
        this.pairings.add(other);
        while (this.pairings.size() > this.getMaxPairings()) {
            WorldCoordinate pair = (WorldCoordinate)this.pairings.remove();
            this.printDebugPair("Signal Block dropped because too many pairs.", pair);
        }
        SignalTools.packetBuilder.sendPairPacketUpdate(this);
    }

    @Override
    public boolean isValidPair(WorldCoordinate otherCoord, TileEntity otherTile) {
        if (otherTile instanceof ISignalBlockTile) {
            SignalBlock signalBlock = ((ISignalBlockTile)otherTile).getSignalBlock();
            return signalBlock.isPairedWith(this.getCoords());
        }
        return false;
    }

    @Override
    public void cleanPairings() {
        if (!this.invalidPairings.isEmpty()) {
            this.printDebug("Signal Block pairs cleaned: source:[{0}, {1}, {2}] targets: {3}", this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, this.invalidPairings);
        }
        super.cleanPairings();
    }

    public boolean createSignalBlock(SignalBlock other) {
        if (other == this) {
            this.printDebugPair("Signal Block creation was aborted, cannot pair with self.", other.tile);
            return false;
        }
        this.printDebugPair("Signal Block creation being attempted.", other.tile);
        Status myTrackStatus = this.getTrackStatus();
        Status otherTrackStatus = other.getTrackStatus();
        if (myTrackStatus == Status.INVALID || otherTrackStatus == Status.INVALID) {
            this.printDebugPair("Signal Block creation failed, could not find Track.", other.tile);
            return false;
        }
        WorldCoordinate myTrack = this.getTrackLocation();
        WorldCoordinate otherTrack = other.getTrackLocation();
        TrackScanner.ScanResult scan = TrackScanner.scanStraightTrackSection(this.tile.func_145831_w(), myTrack.x, myTrack.y, myTrack.z, otherTrack.x, otherTrack.y, otherTrack.z);
        if (!scan.areConnected) {
            this.printDebugPair("Signal Block creation failed, could not find Path.", other.tile);
            return false;
        }
        this.addPairing(other.getCoords());
        other.addPairing(this.getCoords());
        this.endPairing();
        other.endPairing();
        this.trackScans.put(otherTrack, scan);
        this.printDebugPair("Signal Block created successfully.", other.tile);
        return true;
    }

    protected abstract void updateSignalAspect();

    protected abstract SignalAspect getSignalAspectForPair(WorldCoordinate var1);

    public SignalAspect determineAspect(WorldCoordinate otherCoord) {
        if (this.isWaitingForRetest() || this.isBeingPaired()) {
            return SignalAspect.BLINK_YELLOW;
        }
        if (!this.isPaired()) {
            return SignalAspect.BLINK_RED;
        }
        SignalAspect otherAspect = SignalAspect.GREEN;
        SignalBlock other = this.getSignalAt(otherCoord);
        if (other != null) {
            otherAspect = other.getSignalAspectForPair(this.getCoords());
        }
        SignalAspect myAspect = this.determineMyAspect(otherCoord);
        return SignalAspect.mostRestrictive(myAspect, otherAspect);
    }

    private SignalAspect determineMyAspect(WorldCoordinate otherCoord) {
        WorldCoordinate myTrack = this.getTrackLocation();
        if (myTrack == null) {
            return SignalAspect.RED;
        }
        WorldCoordinate otherTrack = this.getOtherTrackLocation(otherCoord);
        if (otherTrack == null) {
            return SignalAspect.YELLOW;
        }
        TrackScanner.ScanResult scan = this.getOrCreateTrackScan(otherTrack);
        int y1 = scan.minY;
        int y2 = scan.maxY + 1;
        int x1 = Math.min(myTrack.x, otherTrack.x);
        int z1 = Math.min(myTrack.z, otherTrack.z);
        int x2 = Math.max(myTrack.x, otherTrack.x) + 1;
        int z2 = Math.max(myTrack.z, otherTrack.z) + 1;
        boolean zAxis = Math.abs(myTrack.x - otherTrack.x) < Math.abs(myTrack.z - otherTrack.z);
        int xOffset = otherTrack.x > myTrack.x ? -3 : 3;
        int zOffset = otherTrack.z > myTrack.z ? -3 : 3;
        List<EntityMinecart> carts = CartTools.getMinecartsIn(this.tile.func_145831_w(), x1, y1, z1, x2, y2, z2);
        SignalAspect newAspect = SignalAspect.GREEN;
        for (EntityMinecart cart : carts) {
            int cartX = MathHelper.func_76128_c((double)cart.field_70165_t);
            int cartZ = MathHelper.func_76128_c((double)cart.field_70161_v);
            if (Math.abs(cart.field_70159_w) < 0.08 && Math.abs(cart.field_70179_y) < 0.08) {
                return SignalAspect.RED;
            }
            if (zAxis) {
                if (cartZ > myTrack.z + zOffset && cart.field_70179_y < 0.0) {
                    return SignalAspect.RED;
                }
                if (cartZ < myTrack.z + zOffset && cart.field_70179_y > 0.0) {
                    return SignalAspect.RED;
                }
                newAspect = SignalAspect.YELLOW;
                continue;
            }
            if (cartX > myTrack.x + xOffset && cart.field_70159_w < 0.0) {
                return SignalAspect.RED;
            }
            if (cartX < myTrack.x + xOffset && cart.field_70159_w > 0.0) {
                return SignalAspect.RED;
            }
            newAspect = SignalAspect.YELLOW;
        }
        return newAspect;
    }

    private TrackScanner.ScanResult getOrCreateTrackScan(WorldCoordinate otherTrack) {
        TrackScanner.ScanResult scan = this.trackScans.get(otherTrack);
        if (scan == null) {
            WorldCoordinate myTrack = this.getTrackLocation();
            scan = TrackScanner.scanStraightTrackSection(this.tile.func_145831_w(), myTrack.x, myTrack.y, myTrack.z, otherTrack.x, otherTrack.y, otherTrack.z);
            this.trackScans.put(otherTrack, scan);
        }
        return scan;
    }

    private WorldCoordinate getOtherTrackLocation(WorldCoordinate otherCoord) {
        SignalBlock other = this.getSignalAt(otherCoord);
        if (other != null) {
            WorldCoordinate track = other.getTrackLocation();
            if (track != null) {
                this.trackCache.put(otherCoord, track);
            }
            return track;
        }
        return this.trackCache.get(otherCoord);
    }

    private TrackValidationStatus isSignalBlockValid(WorldCoordinate other) {
        if (other == null) {
            return new TrackValidationStatus(true, "UNVERIFIABLE_COORD_NULL");
        }
        SignalBlock otherSignalBlock = this.getSignalAt(other);
        if (otherSignalBlock == null) {
            return new TrackValidationStatus(true, "UNVERIFIABLE_OTHER_SIGNAL_NULL");
        }
        Status trackStatus = this.getTrackStatus();
        if (trackStatus == Status.INVALID) {
            return new TrackValidationStatus(false, "INVALID_MY_TRACK_NULL");
        }
        Status otherTrackStatus = otherSignalBlock.getTrackStatus();
        if (otherTrackStatus == Status.INVALID) {
            return new TrackValidationStatus(false, "INVALID_OTHER_TRACK_INVALID");
        }
        WorldCoordinate otherTrack = this.trackCache.get(other);
        if (otherTrackStatus == Status.UNKNOWN) {
            if (otherTrack == null) {
                return new TrackValidationStatus(true, "UNVERIFIABLE_OTHER_TRACK_UNKNOWN");
            }
        } else {
            otherTrack = otherSignalBlock.getTrackLocation();
            if (otherTrack != null) {
                this.trackCache.put(other, otherTrack);
            }
        }
        if (otherTrack == null) {
            return new TrackValidationStatus(true, "UNVERIFIABLE_OTHER_TRACK_NULL");
        }
        WorldCoordinate myTrack = this.getTrackLocation();
        TrackScanner.ScanResult scan = TrackScanner.scanStraightTrackSection(this.tile.func_145831_w(), myTrack.x, myTrack.y, myTrack.z, otherTrack.x, otherTrack.y, otherTrack.z);
        this.trackScans.put(otherTrack, scan);
        if (scan.verdict == TrackScanner.ScanResult.Verdict.VALID) {
            return new TrackValidationStatus(true, "VALID");
        }
        if (scan.verdict == TrackScanner.ScanResult.Verdict.UNKNOWN) {
            return new TrackValidationStatus(true, "UNVERIFIABLE_UNLOADED_CHUNK");
        }
        return new TrackValidationStatus(false, "INVALID_SCAN_FAIL: " + scan.verdict.name());
    }

    @Override
    public void tickServer() {
        super.tickServer();
        ++this.update;
        try {
            if (!this.isLoaded()) {
                return;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (this.update % SignalTools.signalUpdateInterval == 0) {
            SignalAspect prev = this.getSignalAspect();
            if (prev != SignalAspect.BLINK_RED) {
                this.changedAspect = true;
            }
            this.updateSignalAspect();
            if (this.getSignalAspect() == SignalAspect.BLINK_RED && prev != SignalAspect.BLINK_RED) {
                this.printDebug("Signal Block changed aspect to BLINK_RED: source:[{0}, {1}, {2}] pairs: {3}", this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, this.pairings);
            }
        }
        if (this.update % 16384 == 0) {
            Status trackStatus = this.getTrackStatus();
            switch (trackStatus) {
                case INVALID: {
                    this.clearSignalBlockPairing(null, "Signal Block dropped because no track was found near Signal. [{0}, {1}, {2}]", this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e);
                    break;
                }
                case VALID: {
                    for (WorldCoordinate otherCoord : this.waitingForRetest) {
                        TrackValidationStatus status = this.isSignalBlockValid(otherCoord);
                        if (status.isValid) continue;
                        this.clearSignalBlockPairing(otherCoord, "Signal Block dropped because track between Signals was invalid. source:[{0}, {1}, {2}] target:[{3}, {4}, {5}] reason:{6}", this.tile.field_145851_c, this.tile.field_145848_d, this.tile.field_145849_e, otherCoord.x, otherCoord.y, otherCoord.z, status.message);
                    }
                    this.waitingForRetest.clear();
                    for (WorldCoordinate otherCoord : this.getPairs()) {
                        if (this.isSignalBlockValid((WorldCoordinate)otherCoord).isValid) continue;
                        this.waitingForRetest.add(otherCoord);
                    }
                    break;
                }
            }
        }
    }

    public boolean isWaitingForRetest() {
        return !this.waitingForRetest.isEmpty();
    }

    @Override
    protected String getTagName() {
        return "SignalBlock";
    }

    public WorldCoordinate getTrackLocation() {
        if (this.trackLocation == null) {
            this.locateTrack();
        }
        return this.trackLocation;
    }

    public Status getTrackStatus() {
        if (this.trackLocation == null) {
            return this.locateTrack();
        }
        if (!this.tile.func_145831_w().func_72899_e(this.trackLocation.x, this.trackLocation.y, this.trackLocation.z)) {
            return Status.UNKNOWN;
        }
        if (!RailTools.isRailBlockAt((IBlockAccess)this.tile.func_145831_w(), this.trackLocation.x, this.trackLocation.y, this.trackLocation.z)) {
            this.trackLocation = null;
            return this.locateTrack();
        }
        return Status.VALID;
    }

    private Status locateTrack() {
        int x = this.tile.field_145851_c;
        int y = this.tile.field_145848_d;
        int z = this.tile.field_145849_e;
        Status status = this.testForTrack(x, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x - 1, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x + 1, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x, y, z - 1);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x, y, z + 1);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x - 2, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x + 2, y, z);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x, y, z - 2);
        if (status != Status.INVALID) {
            return status;
        }
        status = this.testForTrack(x, y, z + 2);
        if (status != Status.INVALID) {
            return status;
        }
        return Status.INVALID;
    }

    private Status testForTrack(int x, int y, int z) {
        World world = this.tile.func_145831_w();
        for (int jj = -2; jj < 4; ++jj) {
            if (!world.func_72899_e(x, y - jj, z)) {
                return Status.UNKNOWN;
            }
            if (!RailTools.isRailBlockAt((IBlockAccess)world, x, y - jj, z)) continue;
            this.trackLocation = new WorldCoordinate(world.field_73011_w.field_76574_g, x, y - jj, z);
            return Status.VALID;
        }
        return Status.INVALID;
    }

    public static enum Status {
        VALID,
        INVALID,
        UNKNOWN;

    }

    private static class TrackValidationStatus {
        public final boolean isValid;
        public final String message;

        public TrackValidationStatus(boolean isValid, String message) {
            this.isValid = isValid;
            this.message = message;
        }
    }
}

