/*
 * Decompiled with CFR 0.152.
 */
package dev.rndmorris.salisarcana.core.asm.compat;

import dev.rndmorris.salisarcana.config.IEnabler;
import dev.rndmorris.salisarcana.core.asm.IAsmEditor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.spongepowered.asm.lib.tree.AbstractInsnNode;
import org.spongepowered.asm.lib.tree.InsnList;
import org.spongepowered.asm.lib.tree.InsnNode;
import org.spongepowered.asm.lib.tree.LdcInsnNode;
import org.spongepowered.asm.lib.tree.MethodInsnNode;
import org.spongepowered.asm.lib.tree.MethodNode;
import org.spongepowered.asm.lib.tree.VarInsnNode;

public class ModCompatEditor
implements IAsmEditor {
    private static final List<ModCompatEditor> transformers = new ArrayList<ModCompatEditor>();
    private final HashMap<String, IEnabler> compatMap = new HashMap();
    private final String className;
    private final String methodName;
    private final String methodDesc;

    public ModCompatEditor(String className, String methodName, String methodDesc) {
        this.className = className;
        this.methodName = methodName;
        this.methodDesc = methodDesc;
        transformers.add(this);
    }

    @Override
    public void edit(MethodNode method) {
        VarInsnNode previousNode = null;
        InsnNode node = null;
        for (int i = 0; i < method.instructions.size(); ++i) {
            if (method.instructions.get(i).getOpcode() != 176) continue;
            node = (InsnNode)method.instructions.get(i);
            if (!(method.instructions.get(i - 1) instanceof VarInsnNode)) break;
            previousNode = (VarInsnNode)method.instructions.get(i - 1);
            break;
        }
        if (node == null || previousNode == null || previousNode.getOpcode() != 25) {
            throw new RuntimeException("SalisArcana failed to find an injection point in method " + this.getMethodName() + " in class " + this.getClassName());
        }
        int index = previousNode.var;
        LdcInsnNode loadClassName = new LdcInsnNode((Object)this.getClassName());
        LdcInsnNode loadMethodName = new LdcInsnNode((Object)this.getMethodName());
        LdcInsnNode loadMethodDesc = new LdcInsnNode((Object)this.getMethodDesc());
        MethodInsnNode getTransformer = new MethodInsnNode(184, "dev/rndmorris/salisarcana/core/asm/compat/ModCompatEditor", "getTransformer", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)Ldev/rndmorris/salisarcana/core/asm/compat/ModCompatEditor;", false);
        VarInsnNode load = new VarInsnNode(25, index);
        MethodInsnNode methodNode = new MethodInsnNode(182, "dev/rndmorris/salisarcana/core/asm/compat/ModCompatEditor", "apply_compat", "(Ljava/util/List;)Ljava/util/List;", false);
        InsnList list = new InsnList();
        list.add((AbstractInsnNode)loadClassName);
        list.add((AbstractInsnNode)loadMethodName);
        list.add((AbstractInsnNode)loadMethodDesc);
        list.add((AbstractInsnNode)getTransformer);
        list.add((AbstractInsnNode)load);
        list.add((AbstractInsnNode)methodNode);
        method.instructions.insertBefore((AbstractInsnNode)node, list);
    }

    @Override
    public String getClassName() {
        return this.className;
    }

    @Override
    public String getMethodName() {
        return this.methodName;
    }

    @Override
    public String getMethodDesc() {
        return this.methodDesc;
    }

    public ModCompatEditor addConflict(String mixin, IEnabler enabler) {
        this.compatMap.put(mixin, enabler);
        return this;
    }

    public List<String> apply_compat(List<String> mixins) {
        for (String mixin : new ArrayList<String>(mixins)) {
            if (!this.compatMap.containsKey(mixin) || !this.compatMap.get(mixin).isEnabled()) continue;
            mixins.remove(mixin);
        }
        return mixins;
    }

    public static ModCompatEditor getTransformer(String className, String methodName, String methodDesc) {
        for (ModCompatEditor editor : transformers) {
            if (!editor.getClassName().equals(className) || !editor.getMethodName().equals(methodName) || !editor.getMethodDesc().equals(methodDesc)) continue;
            return editor;
        }
        return null;
    }
}

