/*
 * Decompiled with CFR 0.152.
 */
package net.glease.tc4tweak.asm;

import net.glease.tc4tweak.asm.TC4Transformer;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class TileInfusionMatrixVisitor
extends ClassVisitor {
    public TileInfusionMatrixVisitor(int api, ClassVisitor cv) {
        super(api, cv);
    }

    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
        if (name.equals("craftCycle") && desc.equals("()V")) {
            TC4Transformer.log.debug("Visiting {}{}", new Object[]{name, desc});
            return new LoadMathAbsVisitor(this.api, mv);
        }
        if (name.equals("craftingStart") && desc.equals("(Lnet/minecraft/entity/player/EntityPlayer;)V")) {
            TC4Transformer.log.debug("Visiting {}{}", new Object[]{name, desc});
            return new CraftingStartVisitor(this.api, mv);
        }
        return mv;
    }

    private static class CraftingStartVisitor
    extends MethodVisitor {
        public CraftingStartVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            super.visitMethodInsn(opcode, owner, name, desc, itf);
            if (opcode == 182 && owner.equals("thaumcraft/api/crafting/InfusionRecipe") && name.equals("getRecipeOutput") && desc.equals("(Lnet/minecraft/item/ItemStack;)Ljava/lang/Object;") && !itf) {
                TC4Transformer.log.trace("Injecting callhook after InfusionRecipe#getRecipeOutput calls in craftingStart()");
                this.mv.visitVarInsn(25, 4);
                this.mv.visitVarInsn(25, 0);
                this.mv.visitFieldInsn(180, "thaumcraft/common/tiles/TileInfusionMatrix", "recipeInput", "Lnet/minecraft/item/ItemStack;");
                this.mv.visitMethodInsn(184, "net/glease/tc4tweak/asm/ASMCallhookServer", "modifyInfusionOutput", "(Ljava/lang/Object;Lthaumcraft/api/crafting/InfusionRecipe;Lnet/minecraft/item/ItemStack;)Ljava/lang/Object;", false);
            }
        }
    }

    private static class LoadMathAbsVisitor
    extends MethodVisitor {
        public LoadMathAbsVisitor(int api, MethodVisitor mv) {
            super(api, mv);
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
            if (opcode == 182 && owner.equals("java/util/Random") && name.equals("nextInt") && desc.equals("(I)I") && !itf) {
                TC4Transformer.log.trace("Injecting Math#max before Random#nextInt calls in CraftCycle()");
                this.mv.visitInsn(4);
                this.mv.visitMethodInsn(184, "java/lang/Math", "max", "(II)I", false);
            }
            super.visitMethodInsn(opcode, owner, name, desc, itf);
        }
    }
}

