/*
 * Decompiled with CFR 0.152.
 */
package com.djgiannuzz.thaumcraftneiplugin.nei.recipehandler;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import com.djgiannuzz.thaumcraftneiplugin.items.ItemAspect;
import java.awt.Point;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.MathHelper;
import net.minecraft.util.StatCollector;
import org.apache.commons.lang3.ArrayUtils;
import org.lwjgl.opengl.GL11;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.client.gui.GuiResearchRecipe;
import thaumcraft.client.lib.TCFontRenderer;
import thaumcraft.client.lib.UtilsFX;
import thaumcraft.common.Thaumcraft;
import thaumcraft.common.lib.crafting.ThaumcraftCraftingManager;

public class AspectRecipeHandler
extends TemplateRecipeHandler {
    String username;

    public AspectRecipeHandler() {
        this.username = Minecraft.func_71410_x().field_71439_g.getDisplayName();
    }

    public void loadTransferRects() {
    }

    public String getRecipeName() {
        return "";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public String getOverlayIdentifier() {
        return "aspectsRecipe";
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (!outputId.equals(this.getOverlayIdentifier()) && outputId.equals("item")) {
            this.loadCraftingRecipes((ItemStack)results[0]);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        if (result.func_77973_b() instanceof ItemAspect && Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(Minecraft.func_71410_x().field_71439_g.func_70005_c_(), ItemAspect.getAspects(result).getAspects()[0])) {
            AspectsCachedRecipe recipe = new AspectsCachedRecipe(ItemAspect.getAspects(result).getAspects()[0], false);
            this.arecipes.add(recipe);
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        Aspect aspect;
        AspectsCachedRecipe recipe;
        if (ingredient.func_77973_b() instanceof ItemAspect && Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(Minecraft.func_71410_x().field_71439_g.func_70005_c_(), ItemAspect.getAspects(ingredient).getAspects()[0]) && (recipe = new AspectsCachedRecipe(aspect = ItemAspect.getAspects(ingredient).getAspects()[0], true)).getScannedItemStackByAspect(aspect).size() > 0) {
            this.arecipes.add(recipe);
        }
    }

    public String getGuiTexture() {
        return null;
    }

    public void drawBackground(int recipe) {
        int x = 30;
        int y = 3;
        this.drawAspects(recipe, x - 7, y - 24);
    }

    public void drawForeground(int recipe) {
        this.drawExtras(recipe);
    }

    public void drawAspects(int recipeIndex, int x, int y) {
        if (!(this.arecipes.get(recipeIndex) instanceof AspectsCachedRecipe)) {
            return;
        }
        AspectsCachedRecipe recipe = (AspectsCachedRecipe)((Object)this.arecipes.get(recipeIndex));
        Aspect aspect = recipe.getAspect();
        if (recipe.isUsage) {
            String s = StatCollector.func_74838_a((String)"recipe.aspects.containing") + ": " + aspect.getName();
            GuiDraw.drawString((String)s, (int)((x + 140 - GuiDraw.getStringWidth((String)s)) / 2), (int)-11, (int)0x404040, (boolean)false);
        } else {
            String s = StatCollector.func_74838_a((String)"recipe.aspects.component") + ": " + aspect.getName();
            GuiDraw.drawString((String)s, (int)((x + 140 - GuiDraw.getStringWidth((String)s)) / 2), (int)-11, (int)0x404040, (boolean)false);
            s = StatCollector.func_74838_a((String)"recipe.aspects.usedin");
            GuiDraw.drawString((String)s, (int)((x + 140 - GuiDraw.getStringWidth((String)s)) / 2), (int)(y + 62), (int)0x404040, (boolean)false);
            this.renderComponent(aspect, x, y + 20);
            this.renderUsedIn(aspect, x + 9, y + 123);
        }
    }

    private void renderComponent(Aspect aspect, int x, int y) {
        TCFontRenderer fr = new TCFontRenderer(Minecraft.func_71410_x().field_71474_y, TCFontRenderer.FONT_NORMAL, Minecraft.func_71410_x().field_71446_o, true);
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        GL11.glPushMatrix();
        GL11.glScalef((float)2.0f, (float)2.0f, (float)2.0f);
        UtilsFX.drawTag((int)(x / 2), (int)(y / 2), (Aspect)aspect, (float)0.0f, (int)0, (double)GuiDraw.gui.getZLevel());
        GL11.glPopMatrix();
        String text = aspect.getName();
        int offset = GuiDraw.getStringWidth((String)text) / 2;
        fr.drawString(text, x + 20 - offset, y + 33, 0x505050);
        if (aspect.getComponents() != null) {
            GL11.glPushMatrix();
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            UtilsFX.drawTag((int)((int)((float)(x + 54) / 1.5f)), (int)((int)((float)(y + 4) / 1.5f)), (Aspect)aspect.getComponents()[0], (float)0.0f, (int)0, (double)GuiDraw.gui.getZLevel());
            UtilsFX.drawTag((int)((int)((float)(x + 96) / 1.5f)), (int)((int)((float)(y + 4) / 1.5f)), (Aspect)aspect.getComponents()[1], (float)0.0f, (int)0, (double)GuiDraw.gui.getZLevel());
            GL11.glPopMatrix();
            text = aspect.getComponents()[0].getName();
            offset = fr.getStringWidth(text) / 2;
            fr.drawString("\u00ef\u00bf\u00bdo" + text, x + 16 - offset + 50, y + 30, 0x505050);
            text = aspect.getComponents()[1].getName();
            offset = fr.getStringWidth(text) / 2;
            fr.drawString("\u00ef\u00bf\u00bdo" + text, x + 16 - offset + 92, y + 30, 0x505050);
            GuiDraw.drawString((String)"=", (int)(x + 7 + 32), (int)(y + 12), (int)0x999999, (boolean)false);
            GuiDraw.drawString((String)"+", (int)(x + 4 + 79), (int)(y + 12), (int)0x999999, (boolean)false);
        } else {
            fr.drawString(StatCollector.func_74838_a((String)"tc.aspect.primal"), x + 48, y + 12, 0x444444);
        }
    }

    private void renderUsedIn(Aspect component, int x, int y) {
        int count = 0;
        int SPACING = 42;
        AspectList list = new AspectList();
        for (Aspect aspect : Aspect.getCompoundAspects()) {
            if (!Thaumcraft.proxy.playerKnowledge.hasDiscoveredAspect(Minecraft.func_71410_x().field_71439_g.func_70005_c_(), aspect) || !ArrayUtils.contains((Object[])aspect.getComponents(), (Object)component)) continue;
            if (count != 0 && count % 4 == 0) {
                x += 150;
                count = 0;
            }
            TCFontRenderer tcFontRenderer = new TCFontRenderer(Minecraft.func_71410_x().field_71474_y, TCFontRenderer.FONT_NORMAL, Minecraft.func_71410_x().field_71446_o, true);
            GL11.glPushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            GL11.glPushMatrix();
            GL11.glScalef((float)2.0f, (float)2.0f, (float)1.0f);
            UtilsFX.drawTag((int)(x / 2), (int)((y + count * 42) / 2), (Aspect)aspect, (float)0.0f, (int)0, (double)GuiDraw.gui.getZLevel());
            GL11.glPopMatrix();
            GL11.glPushMatrix();
            GL11.glScalef((float)1.5f, (float)1.5f, (float)1.5f);
            UtilsFX.drawTag((int)((int)((float)(x + 54) / 1.5f)), (int)((int)((float)(y + 4 + count * 42) / 1.5f)), (Aspect)aspect.getComponents()[0], (float)0.0f, (int)0, (double)GuiDraw.gui.getZLevel());
            UtilsFX.drawTag((int)((int)((float)(x + 96) / 1.5f)), (int)((int)((float)(y + 4 + count * 42) / 1.5f)), (Aspect)aspect.getComponents()[1], (float)0.0f, (int)0, (double)GuiDraw.gui.getZLevel());
            GL11.glPopMatrix();
            GuiDraw.drawString((String)"=", (int)(x + 7 + 32), (int)(y + 12 + count * 42), (int)0x999999, (boolean)false);
            GuiDraw.drawString((String)"+", (int)(x + 4 + 79), (int)(y + 12 + count * 42), (int)0x999999, (boolean)false);
            GL11.glPopMatrix();
            ++count;
        }
    }

    protected class AspectsCachedRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        private Aspect aspect;
        private boolean isUsage;
        private int start;
        private boolean isRecipeAdded;

        public AspectsCachedRecipe(Aspect aspect, boolean isUsage) {
            this(aspect, isUsage, 0);
        }

        public AspectsCachedRecipe(Aspect aspect, boolean isUsage, int start) {
            super((TemplateRecipeHandler)AspectRecipeHandler.this);
            this.isRecipeAdded = false;
            this.setAspect(aspect);
            this.isUsage = isUsage;
            this.start = start;
        }

        protected void setAspect(Aspect aspect) {
            this.aspect = aspect;
        }

        public Aspect getAspect() {
            return this.aspect;
        }

        private int getCircleNo(int x) {
            int i = 0;
            int no = 0;
            while ((no += this.getElementPerCircle(i)) < x) {
                ++i;
            }
            return i + 1;
        }

        private int getElementPerCircle(int circle) {
            switch (circle) {
                case -1: {
                    return 0;
                }
                case 0: {
                    return 1;
                }
                case 1: {
                    return 6;
                }
                case 2: {
                    return 13;
                }
                case 3: {
                    return 18;
                }
            }
            return 0;
        }

        private int getMissingItemInLastCircle(int tot) {
            int no = this.getCircleNo(tot);
            int count = 0;
            for (int i = 0; i < no - 1; ++i) {
                count += this.getElementPerCircle(i);
            }
            return this.getElementPerCircle(no - 1) - (tot - count);
        }

        private void removeExcessItems(List<ItemStack> stacks) {
            int i;
            if (stacks.size() > this.start + 38) {
                for (i = this.start + 38; i < stacks.size(); ++i) {
                    stacks.remove(i);
                    --i;
                }
                if (!this.isRecipeAdded) {
                    AspectRecipeHandler.this.arecipes.add(new AspectsCachedRecipe(this.aspect, this.isUsage, this.start + 38));
                    this.isRecipeAdded = true;
                }
            }
            for (i = 0; i < this.start; ++i) {
                stacks.remove(0);
            }
        }

        public List<PositionedStack> getIngredients() {
            if (this.isUsage) {
                ArrayList<PositionedStack> list = new ArrayList<PositionedStack>();
                List<ItemStack> stacks = this.getScannedItemStackByAspect(this.aspect);
                this.removeExcessItems(stacks);
                int x = 72;
                int y = 57;
                float RAD_INCREMENT = 18.5f;
                int circleNo = this.getCircleNo(stacks.size());
                ArrayList<Point> coords = new ArrayList<Point>();
                for (int circle = 0; circle < circleNo; ++circle) {
                    int le = this.getElementPerCircle(circle) - (circle == circleNo - 1 ? this.getMissingItemInLastCircle(stacks.size()) : 0);
                    float pieSlice = 360.0f / (float)le;
                    float currentRot = -90.0f;
                    for (int a = 0; a < this.getElementPerCircle(circle); ++a) {
                        int xx = (int)(MathHelper.func_76134_b((float)(currentRot / 180.0f * (float)Math.PI)) * ((float)circle * 18.5f));
                        int yy = (int)(MathHelper.func_76126_a((float)(currentRot / 180.0f * (float)Math.PI)) * ((float)circle * 18.5f));
                        currentRot += pieSlice;
                        coords.add(new Point(xx, yy));
                    }
                }
                int total = 0;
                for (ItemStack stack : stacks) {
                    if (total >= coords.size()) break;
                    int vx = x + ((Point)coords.get((int)total)).x;
                    int vy = y + ((Point)coords.get((int)total)).y;
                    list.add(new PositionedStack((Object)stack, vx, vy));
                    ++total;
                }
                return list;
            }
            return new ArrayList<PositionedStack>();
        }

        public PositionedStack getResult() {
            return null;
        }

        protected List<ItemStack> getScannedItemStackByAspect(Aspect aspect) {
            ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
            List list = (List)Thaumcraft.proxy.getScannedObjects().get(Minecraft.func_71410_x().field_71439_g.func_70005_c_());
            if (list != null && list.size() > 0) {
                for (String s : list) {
                    try {
                        String s2 = s.substring(1);
                        ItemStack is = GuiResearchRecipe.getFromCache((int)Integer.parseInt(s2));
                        if (is == null) continue;
                        AspectList tags = ThaumcraftCraftingManager.getObjectTags((ItemStack)is);
                        if ((tags = ThaumcraftCraftingManager.getBonusTags((ItemStack)is, (AspectList)tags)) == null || tags.size() <= 0) continue;
                        ItemStack is2 = is.func_77946_l();
                        is2.field_77994_a = tags.getAmount(aspect);
                        if (is2.field_77994_a <= 0) continue;
                        stacks.add(is2);
                    }
                    catch (NumberFormatException e) {}
                }
            }
            return stacks;
        }
    }
}

