/*
 * Decompiled with CFR 0.152.
 */
package forestry.core.genetics;

import com.mojang.authlib.GameProfile;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import forestry.core.genetics.mutations.EnumMutateChance;
import forestry.core.items.ItemForestry;
import forestry.core.proxy.Proxies;
import forestry.core.utils.StringUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemResearchNote
extends ItemForestry {
    public ItemResearchNote() {
        this.func_77637_a(null);
    }

    public String func_77653_i(ItemStack itemstack) {
        ResearchNote note = new ResearchNote(itemstack.func_77978_p());
        String researcherName = note.researcher == null ? "Sengir" : note.researcher.getName();
        return StringUtil.localizeAndFormatRaw(this.func_77667_c(itemstack) + ".name", researcherName);
    }

    public void func_77624_a(ItemStack itemstack, EntityPlayer player, List list, boolean flag) {
        ResearchNote note = new ResearchNote(itemstack.func_77978_p());
        note.addTooltip(list);
    }

    public ItemStack func_77659_a(ItemStack itemstack, World world, EntityPlayer entityplayer) {
        if (world.field_72995_K) {
            return itemstack;
        }
        ResearchNote note = new ResearchNote(itemstack.func_77978_p());
        if (note.registerResults(world, entityplayer)) {
            entityplayer.field_71071_by.func_70298_a(entityplayer.field_71071_by.field_70461_c, 1);
            Proxies.net.inventoryChangeNotify(entityplayer);
        }
        return itemstack;
    }

    public int func_82790_a(ItemStack itemstack, int j) {
        return 16771237;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        return Items.field_151121_aF.func_77617_a(0);
    }

    public static class ResearchNote {
        private final GameProfile researcher;
        private final EnumNoteType type;
        private final NBTTagCompound inner;

        public ResearchNote(GameProfile researcher, EnumNoteType type, NBTTagCompound inner) {
            this.researcher = researcher;
            this.type = type;
            this.inner = inner;
        }

        public ResearchNote(NBTTagCompound compound) {
            if (compound != null) {
                this.researcher = compound.func_74764_b("res") ? NBTUtil.func_152459_a((NBTTagCompound)compound.func_74775_l("res")) : null;
                this.type = EnumNoteType.VALUES[compound.func_74771_c("TYP")];
                this.inner = compound.func_74775_l("INN");
            } else {
                this.type = EnumNoteType.NONE;
                this.researcher = null;
                this.inner = new NBTTagCompound();
            }
        }

        public void writeToNBT(NBTTagCompound compound) {
            if (this.researcher != null) {
                NBTTagCompound nbt = new NBTTagCompound();
                NBTUtil.func_152460_a((NBTTagCompound)nbt, (GameProfile)this.researcher);
                compound.func_74782_a("res", (NBTBase)nbt);
            }
            compound.func_74774_a("TYP", (byte)this.type.ordinal());
            compound.func_74782_a("INN", (NBTBase)this.inner);
        }

        public void addTooltip(List<String> list) {
            ArrayList<String> tooltips = this.type.getTooltip(this.inner);
            if (tooltips.size() <= 0) {
                list.add(EnumChatFormatting.ITALIC + EnumChatFormatting.RED.toString() + StringUtil.localize("researchNote.error.0"));
                list.add(StringUtil.localize("researchNote.error.1"));
                return;
            }
            list.addAll(tooltips);
        }

        public boolean registerResults(World world, EntityPlayer player) {
            return this.type.registerResults(world, player, this.inner);
        }
    }

    public static enum EnumNoteType {
        NONE,
        MUTATION,
        SPECIES;

        public static final EnumNoteType[] VALUES;

        private static IMutation getEncodedMutation(ISpeciesRoot root, NBTTagCompound compound) {
            IAllele allele0 = AlleleManager.alleleRegistry.getAllele(compound.func_74779_i("AL0"));
            IAllele allele1 = AlleleManager.alleleRegistry.getAllele(compound.func_74779_i("AL1"));
            if (allele0 == null || allele1 == null) {
                return null;
            }
            IAllele result = null;
            if (compound.func_74764_b("RST")) {
                result = AlleleManager.alleleRegistry.getAllele(compound.func_74779_i("RST"));
            }
            IMutation encoded = null;
            for (IMutation iMutation : root.getCombinations(allele0)) {
                if (!iMutation.isPartner(allele1) || result != null && !iMutation.getTemplate()[0].getUID().equals(result.getUID())) continue;
                encoded = iMutation;
                break;
            }
            return encoded;
        }

        public ArrayList<String> getTooltip(NBTTagCompound compound) {
            ArrayList<String> tooltips = new ArrayList<String>();
            if (compound == null || this == NONE) {
                return tooltips;
            }
            if (this == MUTATION) {
                ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(compound.func_74779_i("ROT"));
                if (root == null) {
                    return tooltips;
                }
                IMutation encoded = EnumNoteType.getEncodedMutation(root, compound);
                if (encoded == null) {
                    return tooltips;
                }
                String species1 = encoded.getAllele0().getName();
                String species2 = encoded.getAllele1().getName();
                String mutationChanceKey = EnumMutateChance.rateChance(encoded.getBaseChance()).toString().toLowerCase(Locale.ENGLISH);
                String mutationChance = StringUtil.localize("researchNote.chance." + mutationChanceKey);
                String speciesResult = encoded.getTemplate()[root.getKaryotypeKey().ordinal()].getName();
                tooltips.add(StringUtil.localize("researchNote.discovery.0"));
                tooltips.add(StringUtil.localize("researchNote.discovery.1").replace("%SPEC1", species1).replace("%SPEC2", species2));
                tooltips.add(StringUtil.localizeAndFormat("researchNote.discovery.2", mutationChance));
                tooltips.add(StringUtil.localizeAndFormat("researchNote.discovery.3", speciesResult));
                if (encoded.getSpecialConditions() != null && encoded.getSpecialConditions().size() > 0) {
                    for (String line : encoded.getSpecialConditions()) {
                        tooltips.add(EnumChatFormatting.GOLD + line);
                    }
                }
            } else if (this == SPECIES) {
                IAlleleSpecies allele0 = (IAlleleSpecies)AlleleManager.alleleRegistry.getAllele(compound.func_74779_i("AL0"));
                if (allele0 == null) {
                    return tooltips;
                }
                ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(compound.func_74779_i("ROT"));
                if (root == null) {
                    return tooltips;
                }
                tooltips.add("researchNote.discovered.0");
                tooltips.add(StringUtil.localizeAndFormat("researchNote.discovered.1", allele0.getName(), allele0.getBinomial()));
            }
            return tooltips;
        }

        public boolean registerResults(World world, EntityPlayer player, NBTTagCompound compound) {
            if (compound == null || this == NONE) {
                return false;
            }
            if (this == MUTATION) {
                ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(compound.func_74779_i("ROT"));
                if (root == null) {
                    return false;
                }
                IMutation encoded = EnumNoteType.getEncodedMutation(root, compound);
                if (encoded == null) {
                    return false;
                }
                IBreedingTracker tracker = encoded.getRoot().getBreedingTracker(world, player.func_146103_bH());
                if (tracker.isResearched(encoded)) {
                    player.func_145747_a((IChatComponent)new ChatComponentTranslation("for.chat.cannotmemorizeagain", new Object[0]));
                    return false;
                }
                IAlleleSpecies species0 = encoded.getAllele0();
                IAlleleSpecies species1 = encoded.getAllele1();
                IAlleleSpecies speciesResult = (IAlleleSpecies)encoded.getTemplate()[root.getKaryotypeKey().ordinal()];
                tracker.registerSpecies(species0);
                tracker.registerSpecies(species1);
                tracker.registerSpecies(speciesResult);
                tracker.researchMutation(encoded);
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("for.chat.memorizednote", new Object[0]));
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("for.chat.memorizednote2", new Object[]{EnumChatFormatting.GRAY + species0.getName(), EnumChatFormatting.GRAY + species1.getName(), EnumChatFormatting.GREEN + speciesResult.getName()}));
                return true;
            }
            return false;
        }

        public static ResearchNote createMutationNote(GameProfile researcher, IMutation mutation) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("ROT", mutation.getRoot().getUID());
            compound.func_74778_a("AL0", mutation.getAllele0().getUID());
            compound.func_74778_a("AL1", mutation.getAllele1().getUID());
            compound.func_74778_a("RST", mutation.getTemplate()[0].getUID());
            return new ResearchNote(researcher, MUTATION, compound);
        }

        public static ItemStack createMutationNoteStack(Item item, GameProfile researcher, IMutation mutation) {
            ResearchNote note = EnumNoteType.createMutationNote(researcher, mutation);
            NBTTagCompound compound = new NBTTagCompound();
            note.writeToNBT(compound);
            ItemStack created = new ItemStack(item);
            created.func_77982_d(compound);
            return created;
        }

        public static ResearchNote createSpeciesNote(GameProfile researcher, IAlleleSpecies species) {
            NBTTagCompound compound = new NBTTagCompound();
            compound.func_74778_a("ROT", species.getRoot().getUID());
            compound.func_74778_a("AL0", species.getUID());
            return new ResearchNote(researcher, SPECIES, compound);
        }

        public static ItemStack createSpeciesNoteStack(Item item, GameProfile researcher, IAlleleSpecies species) {
            ResearchNote note = EnumNoteType.createSpeciesNote(researcher, species);
            NBTTagCompound compound = new NBTTagCompound();
            note.writeToNBT(compound);
            ItemStack created = new ItemStack(item);
            created.func_77982_d(compound);
            return created;
        }

        static {
            VALUES = EnumNoteType.values();
        }
    }
}

