/*
 * Decompiled with CFR 0.152.
 */
package com.github.weisj.darklaf.ui.label;

import com.github.weisj.darklaf.compatibility.SwingUtil;
import com.github.weisj.darklaf.graphics.StringPainter;
import com.github.weisj.darklaf.ui.util.DarkUIUtil;
import com.github.weisj.darklaf.util.graphics.GraphicsContext;
import java.awt.Color;
import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.LookAndFeel;
import javax.swing.UIManager;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicLabelUI;

public class DarkLabelUI
extends BasicLabelUI
implements PropertyChangeListener {
    protected static DarkLabelUI darkLabelUI;
    private Color inactiveForeground;
    protected final Rectangle paintIconR = new Rectangle();
    protected final Rectangle paintTextR = new Rectangle();

    public DarkLabelUI() {
        this.installUI(null);
    }

    public static ComponentUI createUI(JComponent c) {
        if (darkLabelUI == null) {
            darkLabelUI = new DarkLabelUI();
        }
        return darkLabelUI;
    }

    @Override
    public void installUI(JComponent c) {
        if (c != null) {
            super.installUI(c);
        }
    }

    @Override
    protected void installDefaults(JLabel c) {
        super.installDefaults(c);
        LookAndFeel.installProperty(c, "opaque", false);
        this.inactiveForeground = UIManager.getColor("Label.inactiveForeground");
    }

    @Override
    public void paint(Graphics g, JComponent c) {
        GraphicsContext config = new GraphicsContext(g);
        JLabel label = (JLabel)c;
        String text = label.getText();
        Icon icon = this.getIcon(label);
        this.paintBackground(g, c);
        if (icon == null && text == null) {
            return;
        }
        FontMetrics fm = SwingUtil.getFontMetrics((JComponent)label, g);
        String clippedText = this.layout(label, fm, c.getWidth(), c.getHeight());
        if (icon != null) {
            icon.paintIcon(c, g, this.paintIconR.x, this.paintIconR.y);
            config.restoreClip();
        }
        this.paintText(g, label, fm, clippedText);
    }

    protected void paintBackground(Graphics g, JComponent c) {
    }

    public void paintText(Graphics g, JLabel label, FontMetrics fm, String clippedText) {
        int mnemIndex = label.isEnabled() ? label.getDisplayedMnemonicIndex() : -1;
        g.setColor(this.getForeground(label));
        StringPainter.drawStringUnderlineCharAt(g, label, clippedText, mnemIndex, this.paintTextR, label.getFont(), fm);
    }

    protected Color getForeground(Component label) {
        if (label.isEnabled()) {
            return this.getEnabledForeground(label);
        }
        return this.getDisabledForeground(label);
    }

    protected Color getEnabledForeground(Component label) {
        return label.getForeground();
    }

    protected Color getDisabledForeground(Component label) {
        if (!DarkUIUtil.isInCell(label)) {
            return this.inactiveForeground;
        }
        return this.getEnabledForeground(label);
    }

    protected Icon getIcon(JLabel label) {
        Icon icon = label.isEnabled() ? label.getIcon() : label.getDisabledIcon();
        return icon;
    }

    protected String layout(JLabel label, FontMetrics fm, int width, int height) {
        Insets insets = label.getInsets(null);
        String text = label.getText();
        Icon icon = this.getIcon(label);
        Rectangle paintViewR = new Rectangle();
        paintViewR.x = insets.left;
        paintViewR.y = insets.top;
        paintViewR.width = width - (insets.left + insets.right);
        paintViewR.height = height - (insets.top + insets.bottom);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        return this.layoutCL(label, fm, text, icon, paintViewR, this.paintIconR, this.paintTextR);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        Object source;
        super.propertyChange(e);
        String key = e.getPropertyName();
        if ("componentOrientation".equals(key) && (source = e.getSource()) instanceof JLabel) {
            ((JLabel)source).doLayout();
            ((JLabel)source).repaint();
        }
    }
}

