/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.archaicfix.mixins.common.pregen;

import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.concurrent.TimeUnit;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.WorldServer;
import org.embeddedt.archaicfix.ArchaicLogger;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import pregenerator.impl.processor.generator.ChunkProcessor;

@Mixin(value={ChunkProcessor.class})
public abstract class MixinChunkProcessor {
    @Shadow(remap=false)
    private boolean working;
    private long lastTimeMessaged = System.nanoTime();

    @Shadow(remap=false)
    public abstract MinecraftServer getServer();

    @Inject(method={"onServerTickEvent"}, at={@At(value="INVOKE", target="Lpregenerator/impl/misc/DeltaTimer;averageDelta()J", ordinal=0, remap=false)}, remap=false, cancellable=true)
    private void checkNumBlockUpdates(TickEvent.ServerTickEvent event, CallbackInfo ci) {
        for (WorldServer world : this.getServer().field_71305_c) {
            if (world == null || world.field_73065_O.size() <= 500000) continue;
            this.working = false;
            long elapsed = TimeUnit.SECONDS.convert(System.nanoTime() - this.lastTimeMessaged, TimeUnit.NANOSECONDS);
            if (elapsed >= 5L) {
                this.lastTimeMessaged = System.nanoTime();
                ArchaicLogger.LOGGER.warn("Preventing more pregeneration till the update queue settles in dimension " + world.field_73011_w.field_76574_g);
            }
            ci.cancel();
            break;
        }
    }
}

