/*
 * Decompiled with CFR 0.152.
 */
package com.glodblock.github.inventory.item;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.Settings;
import appeng.api.config.TerminalStyle;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.networking.IGridNode;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.items.tools.powered.ToolWirelessTerminal;
import appeng.tile.inventory.InvOperation;
import appeng.util.ConfigManager;
import appeng.util.Platform;
import com.glodblock.github.inventory.item.IClickableInTerminal;
import com.glodblock.github.inventory.item.IWirelessTerminal;
import com.glodblock.github.util.Util;
import java.util.Objects;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;

public class WirelessLevelTerminalInventory
implements IClickableInTerminal,
IWirelessTerminal {
    private final ItemStack target;
    private final IAEItemPowerStorage ips;
    private final int inventorySlot;
    private final IGridNode grid;
    private Util.DimensionalCoordSide tile;

    public WirelessLevelTerminalInventory(ItemStack is, int slot, IGridNode gridNode, EntityPlayer player) {
        Objects.requireNonNull(Util.getWirelessInv(is, player, StorageChannel.ITEMS));
        this.ips = (ToolWirelessTerminal)is.func_77973_b();
        this.grid = gridNode;
        this.target = is;
        this.inventorySlot = slot;
        this.readFromNBT();
    }

    public void readFromNBT() {
        NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
        if (data.func_74764_b("clickedInterface")) {
            NBTTagCompound tileMsg = (NBTTagCompound)data.func_74781_a("clickedInterface");
            this.tile = Util.DimensionalCoordSide.readFromNBT(tileMsg);
        }
    }

    public void writeToNBT() {
        NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
        NBTTagCompound tileMsg = new NBTTagCompound();
        this.tile.writeToNBT(tileMsg);
        data.func_74782_a("clickedInterface", (NBTBase)tileMsg);
    }

    public IGridNode getActionableNode() {
        return this.grid;
    }

    public IGridNode getGridNode(ForgeDirection dir) {
        return this.grid;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.NONE;
    }

    public void securityBreak() {
        this.getGridNode(ForgeDirection.UNKNOWN).getMachine().securityBreak();
    }

    public ItemStack getItemStack() {
        return this.target;
    }

    public IInventory getViewCellStorage() {
        return null;
    }

    public double extractAEPower(double amt, Actionable mode, PowerMultiplier usePowerMultiplier) {
        amt = usePowerMultiplier.multiply(amt);
        if (mode == Actionable.SIMULATE) {
            return usePowerMultiplier.divide(Math.min(amt, this.ips.getAECurrentPower(this.target)));
        }
        return usePowerMultiplier.divide(this.ips.extractAEPower(this.target, amt));
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return null;
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return null;
    }

    public IConfigManager getConfigManager() {
        ConfigManager out = new ConfigManager((manager, settingName, newValue) -> {
            NBTTagCompound data = Platform.openNbtData((ItemStack)this.target);
            manager.writeToNBT(data);
        });
        out.registerSetting(Settings.TERMINAL_STYLE, (Enum)TerminalStyle.SMALL);
        out.readFromNBT((NBTTagCompound)Platform.openNbtData((ItemStack)this.target).func_74737_b());
        return out;
    }

    public int getInventorySlot() {
        return this.inventorySlot;
    }

    public void saveChanges() {
    }

    public void onChangeInventory(IInventory inv, int slot, InvOperation mc, ItemStack removedStack, ItemStack newStack) {
    }

    @Override
    public void setClickedInterface(Util.DimensionalCoordSide tile) {
        this.tile = tile;
        this.writeToNBT();
    }

    @Override
    public Util.DimensionalCoordSide getClickedInterface() {
        return this.tile;
    }
}

