/*
 * Decompiled with CFR 0.152.
 */
package com.cleanroommc.modularui.widget.scroll;

import com.cleanroommc.modularui.api.GuiAxis;
import com.cleanroommc.modularui.drawable.GuiDraw;
import com.cleanroommc.modularui.widget.scroll.HorizontalScrollData;
import com.cleanroommc.modularui.widget.scroll.ScrollArea;
import com.cleanroommc.modularui.widget.scroll.ScrollData;

public class VerticalScrollData
extends ScrollData {
    public VerticalScrollData() {
        this(false, 4);
    }

    public VerticalScrollData(boolean leftAlignment) {
        this(leftAlignment, 4);
    }

    public VerticalScrollData(boolean leftAlignment, int thickness) {
        super(GuiAxis.Y, leftAlignment, thickness);
    }

    public VerticalScrollData cancelScrollEdge(boolean cancelScrollEdge) {
        this.setCancelScrollEdge(cancelScrollEdge);
        return this;
    }

    @Override
    public HorizontalScrollData getOtherScrollData(ScrollArea area) {
        return area.getScrollX();
    }

    @Override
    public boolean isInsideScrollbarArea(ScrollArea area, int x, int y) {
        if (!area.isInside(x, y) || !this.isScrollBarActive(area)) {
            return false;
        }
        int scrollbar = this.getThickness();
        HorizontalScrollData data = this.getOtherScrollData(area);
        if (data != null && this.isOtherScrollBarActive(area, true)) {
            int thickness = data.getThickness();
            if (data.isOnAxisStart() ? y < area.y + thickness : y >= area.ey() - thickness) {
                return false;
            }
        }
        return this.isOnAxisStart() ? x >= area.x && x < area.x + scrollbar : x >= area.ex() - scrollbar && x < area.ex();
    }

    @Override
    public void drawScrollbar(ScrollArea area) {
        boolean isOtherActive = this.isOtherScrollBarActive(area, true);
        int l = this.getScrollBarLength(area);
        int x = this.isOnAxisStart() ? 0 : area.w() - this.getThickness();
        int y = 0;
        int w = this.getThickness();
        int h = area.height;
        GuiDraw.drawRect(x, y, w, h, area.getScrollBarBackgroundColor());
        y = this.getScrollBarStart(area, l, isOtherActive);
        HorizontalScrollData data2 = this.getOtherScrollData(area);
        if (data2 != null && isOtherActive && data2.isOnAxisStart()) {
            y += data2.getThickness();
        }
        h = l;
        this.drawScrollBar(x, y, w, h);
    }
}

