/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.planets.pluto.world.dungeon;

import galaxyspace.SolarSystem.planets.pluto.tile.TileEntityDungeonSpawnerPluto;
import galaxyspace.core.register.GSBlocks;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.vector.Vector3;
import micdoodle8.mods.galacticraft.core.tile.TileEntityDungeonSpawner;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonBoundingBox;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.DungeonRoom;
import micdoodle8.mods.galacticraft.core.world.gen.dungeon.MapGenDungeon;
import micdoodle8.mods.galacticraft.planets.mars.blocks.MarsBlocks;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChunkCoordinates;
import net.minecraftforge.common.util.ForgeDirection;

public class RoomBossPluto
extends DungeonRoom {
    private int sizeX;
    private int sizeY;
    private int sizeZ;
    private Random rand;
    private ChunkCoordinates spawnerCoords;

    public RoomBossPluto(MapGenDungeon dungeon, int posX, int posY, int posZ, ForgeDirection entranceDir) {
        super(dungeon, posX, posY, posZ, entranceDir);
        if (this.worldObj != null) {
            this.rand = new Random(this.worldObj.func_72905_C() * (long)posX * (long)posY * 57L * (long)posZ);
            this.sizeX = 24;
            this.sizeY = 11;
            this.sizeZ = 24;
        }
    }

    public void generate(Block[] chunk, byte[] meta, int cx, int cz) {
        for (int x = this.posX - 1; x <= this.posX + this.sizeX; ++x) {
            for (int z = this.posZ - 1; z <= this.posZ + this.sizeZ; ++z) {
                for (int y = this.posY - 1; y <= this.posY + this.sizeY; ++y) {
                    if (x == this.posX - 1 || x == this.posX + this.sizeX || y == this.posY - 1 || y == this.posY + this.sizeY || z == this.posZ - 1 || z == this.posZ + this.sizeZ) {
                        if (y == this.posY - 1 && (x <= this.posX + 1 || x >= this.posX + this.sizeX - 2 || z == this.posZ + 1 || z == this.posZ + this.sizeZ - 2) && this.rand.nextInt(4) == 0) {
                            this.placeBlock(chunk, meta, x, y, z, cx, cz, GSBlocks.PlutoGlowStone, 0);
                            continue;
                        }
                        this.placeBlock(chunk, meta, x, y, z, cx, cz, this.dungeonInstance.DUNGEON_WALL_ID, this.dungeonInstance.DUNGEON_WALL_META);
                        continue;
                    }
                    if (y != this.posY || x > this.posX + 1 && x < this.posX + this.sizeX - 2 && z != this.posZ + 1 && z != this.posZ + this.sizeZ - 2 || this.rand.nextInt(6) == 0) {
                        // empty if block
                    }
                    this.placeBlock(chunk, meta, x, y, z, cx, cz, Blocks.field_150350_a, 0);
                }
            }
        }
        int hx = (this.posX + this.posX + this.sizeX) / 2;
        int hz = (this.posZ + this.posZ + this.sizeZ) / 2;
        this.spawnerCoords = new ChunkCoordinates(hx, this.posY + 2, hz);
    }

    public DungeonBoundingBox getBoundingBox() {
        return new DungeonBoundingBox(this.posX, this.posZ, this.posX + this.sizeX, this.posZ + this.sizeZ);
    }

    protected DungeonRoom makeRoom(MapGenDungeon dungeon, int x, int y, int z, ForgeDirection dir) {
        return new RoomBossPluto(dungeon, x, y, z, dir);
    }

    protected void handleTileEntities(Random rand_) {
        if (this.spawnerCoords == null) {
            return;
        }
        this.worldObj.func_147465_d(this.spawnerCoords.field_71574_a, this.spawnerCoords.field_71572_b, this.spawnerCoords.field_71573_c, MarsBlocks.marsBlock, 10, 3);
        TileEntity tile = this.worldObj.func_147438_o(this.spawnerCoords.field_71574_a, this.spawnerCoords.field_71572_b, this.spawnerCoords.field_71573_c);
        if (tile == null || !(tile instanceof TileEntityDungeonSpawnerPluto)) {
            TileEntityDungeonSpawnerPluto spawner = new TileEntityDungeonSpawnerPluto();
            spawner.setRoom(new Vector3((double)this.posX, (double)this.posY, (double)this.posZ), new Vector3((double)this.sizeX, (double)this.sizeY, (double)this.sizeZ));
            this.worldObj.func_147455_a(this.spawnerCoords.field_71574_a, this.spawnerCoords.field_71572_b, this.spawnerCoords.field_71573_c, (TileEntity)spawner);
        } else if (tile instanceof TileEntityDungeonSpawner) {
            ((TileEntityDungeonSpawner)tile).setRoom(new Vector3((double)this.posX, (double)this.posY, (double)this.posZ), new Vector3((double)this.sizeX, (double)this.sizeY, (double)this.sizeZ));
        }
    }
}

