/*
 * Decompiled with CFR 0.152.
 */
package galaxyspace.SolarSystem.moons.io.dimension;

import galaxyspace.SolarSystem.moons.io.world.BiomeGenBaseIo;
import galaxyspace.SolarSystem.moons.io.world.layer.GenLayerIo;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import micdoodle8.mods.galacticraft.api.prefab.world.gen.WorldChunkManagerSpace;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.util.ReportedException;
import net.minecraft.world.ChunkPosition;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeCache;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.biome.WorldChunkManager;
import net.minecraft.world.gen.layer.GenLayer;
import net.minecraft.world.gen.layer.IntCache;

public class WorldChunkManagerIo
extends WorldChunkManagerSpace {
    private GenLayer unzoomedBiomes;
    private GenLayer zoomedBiomes;
    private final BiomeCache biomeCache;
    private final List<BiomeGenBase> biomesToSpawnIn = new ArrayList<BiomeGenBase>();

    protected WorldChunkManagerIo() {
        this.biomeCache = new BiomeCache((WorldChunkManager)this);
        this.biomesToSpawnIn.add(BiomeGenBaseIo.IO);
        this.biomesToSpawnIn.add(BiomeGenBaseIo.IO_ASH);
    }

    public WorldChunkManagerIo(long seed) {
        this();
        GenLayer[] agenlayer = GenLayerIo.makeTheWorld(seed);
        this.unzoomedBiomes = agenlayer[0];
        this.zoomedBiomes = agenlayer[1];
    }

    public WorldChunkManagerIo(World world) {
        this(world.func_72905_C());
    }

    public BiomeGenBase getBiome() {
        return BiomeGenBaseIo.IO;
    }

    public List<BiomeGenBase> func_76932_a() {
        return this.biomesToSpawnIn;
    }

    public BiomeGenBase func_76935_a(int x, int z) {
        BiomeGenBase biome = this.biomeCache.func_76837_b(x, z);
        if (biome == null) {
            return this.getBiome();
        }
        return biome;
    }

    public float[] func_76936_a(float[] downfalls, int x, int z, int w, int h) {
        IntCache.func_76446_a();
        int[] zoomedBiomes_ = this.zoomedBiomes.func_75904_a(x, z, w, h);
        if (downfalls == null || downfalls.length < w * h) {
            downfalls = new float[w * h];
        }
        for (int i = 0; i < w * h; ++i) {
            try {
                float rainfall = (float)BiomeGenBase.func_150568_d((int)zoomedBiomes_[i]).func_76744_g() / 65536.0f;
                if (rainfall > 1.0f) {
                    rainfall = 1.0f;
                }
                downfalls[i] = rainfall;
                continue;
            }
            catch (Exception e) {
                CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Invalid Biome id");
                CrashReportCategory crashreportcategory = crashreport.func_85058_a("DownfallBlock");
                crashreportcategory.func_71507_a("biome id", (Object)i);
                crashreportcategory.func_71507_a("downfalls[] size", (Object)downfalls.length);
                crashreportcategory.func_71507_a("x", (Object)x);
                crashreportcategory.func_71507_a("z", (Object)z);
                crashreportcategory.func_71507_a("w", (Object)w);
                crashreportcategory.func_71507_a("h", (Object)h);
                throw new ReportedException(crashreport);
            }
        }
        return downfalls;
    }

    public BiomeGenBase[] func_76937_a(BiomeGenBase[] biomes, int x, int z, int w, int h) {
        IntCache.func_76446_a();
        int[] unzoomedBiomes_ = this.unzoomedBiomes.func_75904_a(x, z, w, h);
        if (biomes == null || biomes.length < w * h) {
            biomes = new BiomeGenBase[w * h];
        }
        try {
            for (int i = 0; i < w * h; ++i) {
                biomes[i] = unzoomedBiomes_[i] >= 0 ? BiomeGenBase.func_150568_d((int)unzoomedBiomes_[i]) : this.getBiome();
            }
        }
        catch (Exception e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("RawBiomeBlock");
            crashreportcategory.func_71507_a("biomes[] size", (Object)biomes.length);
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("w", (Object)w);
            crashreportcategory.func_71507_a("h", (Object)h);
            throw new ReportedException(crashreport);
        }
        return biomes;
    }

    public BiomeGenBase[] func_76931_a(BiomeGenBase[] biomes, int x, int y, int w, int h, boolean cacheFlag) {
        IntCache.func_76446_a();
        int[] zoomedBiomes_ = this.zoomedBiomes.func_75904_a(x, y, w, h);
        if (biomes == null || biomes.length < w * h) {
            biomes = new BiomeGenBase[w * h];
        }
        if (cacheFlag && w == 16 && h == 16 && (x & 0xF) == 0 && (y & 0xF) == 0) {
            BiomeGenBase[] cachedBiomes = this.biomeCache.func_76839_e(x, y);
            System.arraycopy(cachedBiomes, 0, biomes, 0, w * h);
            return biomes;
        }
        for (int i = 0; i < w * h; ++i) {
            biomes[i] = zoomedBiomes_[i] >= 0 ? BiomeGenBase.func_150568_d((int)zoomedBiomes_[i]) : this.getBiome();
        }
        return biomes;
    }

    public boolean func_76940_a(int chunkX, int chunkZ, int radius, List<BiomeGenBase> allowed) {
        IntCache.func_76446_a();
        int x = chunkX - radius >> 2;
        int z = chunkZ - radius >> 2;
        int w = 2 * (radius >> 2) + 1;
        int h = 2 * (radius >> 2) + 1;
        int[] unzoomedBiomes_ = this.unzoomedBiomes.func_75904_a(x, z, w, h);
        try {
            for (int i = 0; i < w * h; ++i) {
                BiomeGenBase biome = BiomeGenBase.func_150568_d((int)unzoomedBiomes_[i]);
                if (allowed.contains(biome)) continue;
                return false;
            }
        }
        catch (Exception e) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)e, (String)"Invalid Biome id");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Layer");
            crashreportcategory.func_71507_a("Layer", (Object)this.unzoomedBiomes);
            crashreportcategory.func_71507_a("x", (Object)x);
            crashreportcategory.func_71507_a("z", (Object)z);
            crashreportcategory.func_71507_a("radius", (Object)radius);
            crashreportcategory.func_71507_a("allowed", allowed);
            throw new ReportedException(crashreport);
        }
        return true;
    }

    public ChunkPosition func_150795_a(int chunkX, int chunkZ, int radius, List<BiomeGenBase> biomes, Random random) {
        IntCache.func_76446_a();
        int x = chunkX - radius >> 2;
        int z = chunkZ - radius >> 2;
        int w = 2 * (radius >> 2) + 1;
        int h = 2 * (radius >> 2) + 1;
        int[] unzoomedBiomes_ = this.unzoomedBiomes.func_75904_a(x, z, w, h);
        ChunkPosition chunkposition = null;
        int bound = 0;
        for (int i = 0; i < unzoomedBiomes_.length; ++i) {
            int cX = x + i % w << 2;
            int cZ = z + i / w << 2;
            BiomeGenBase biomegenbase = BiomeGenBase.func_150568_d((int)unzoomedBiomes_[i]);
            if (!biomes.contains(biomegenbase) || chunkposition != null && random.nextInt(bound + 1) != 0) continue;
            chunkposition = new ChunkPosition(cX, 0, cZ);
            ++bound;
        }
        return chunkposition;
    }

    public void func_76938_b() {
        this.biomeCache.func_76838_a();
    }
}

