/*
 * Decompiled with CFR 0.152.
 */
package baubles.common.lib;

import baubles.common.Baubles;
import baubles.common.container.InventoryBaubles;
import com.google.common.io.Files;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.CompressedStreamTools;
import net.minecraft.nbt.NBTTagCompound;

public class PlayerHandler {
    private static HashMap<String, InventoryBaubles> playerBaublesServer = new HashMap();
    private static HashMap<String, InventoryBaubles> playerBaublesClient = new HashMap();

    public static void clearPlayerBaubles(EntityPlayer player) {
        playerBaublesServer.remove(player.func_70005_c_());
    }

    public static void clearClientPlayerBaubles() {
        playerBaublesClient.clear();
    }

    public static InventoryBaubles getPlayerBaubles(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            return playerBaublesClient.computeIfAbsent(player.func_70005_c_(), username -> new InventoryBaubles(player));
        }
        return playerBaublesServer.computeIfAbsent(player.func_70005_c_(), username -> new InventoryBaubles(player));
    }

    public static void setPlayerBaubles(EntityPlayer player, InventoryBaubles inventory) {
        if (player.field_70170_p.field_72995_K) {
            playerBaublesClient.put(player.func_70005_c_(), inventory);
        } else {
            playerBaublesServer.put(player.func_70005_c_(), inventory);
        }
    }

    public static void loadPlayerBaubles(EntityPlayer player, File mainFile, File backupFile) {
        if (player != null && !player.field_70170_p.field_72995_K) {
            try {
                FileInputStream fileinputstream;
                NBTTagCompound data = null;
                boolean save = false;
                if (mainFile != null && mainFile.exists()) {
                    try {
                        fileinputstream = new FileInputStream(mainFile);
                        data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                        fileinputstream.close();
                    }
                    catch (Exception loadMainException) {
                        loadMainException.printStackTrace();
                    }
                }
                if (mainFile == null || !mainFile.exists() || data == null || data.func_82582_d()) {
                    Baubles.log.warn("Data not found for " + player.func_70005_c_() + ". Trying to load backup data.");
                    if (backupFile != null && backupFile.exists()) {
                        try {
                            fileinputstream = new FileInputStream(backupFile);
                            data = CompressedStreamTools.func_74796_a((InputStream)fileinputstream);
                            fileinputstream.close();
                            save = true;
                        }
                        catch (Exception loadBackupException) {
                            loadBackupException.printStackTrace();
                        }
                    }
                }
                if (data != null) {
                    InventoryBaubles inventory = new InventoryBaubles(player);
                    inventory.readNBT(data);
                    playerBaublesServer.put(player.func_70005_c_(), inventory);
                    if (save) {
                        PlayerHandler.savePlayerBaubles(player, mainFile, backupFile);
                    }
                }
            }
            catch (Exception loadException) {
                Baubles.log.fatal("Error loading baubles inventory");
                loadException.printStackTrace();
            }
        }
    }

    public static void savePlayerBaubles(EntityPlayer player, File mainFile, File backupFile) {
        block11: {
            if (player != null && !player.field_70170_p.field_72995_K) {
                try {
                    if (mainFile != null && mainFile.exists()) {
                        try {
                            Files.copy((File)mainFile, (File)backupFile);
                        }
                        catch (Exception saveBackupException) {
                            Baubles.log.error("Could not backup old baubles file for player " + player.func_70005_c_());
                        }
                    }
                    try {
                        if (mainFile != null) {
                            InventoryBaubles inventory = PlayerHandler.getPlayerBaubles(player);
                            NBTTagCompound data = new NBTTagCompound();
                            inventory.saveNBT(data);
                            FileOutputStream fileoutputstream = new FileOutputStream(mainFile);
                            CompressedStreamTools.func_74799_a((NBTTagCompound)data, (OutputStream)fileoutputstream);
                            fileoutputstream.close();
                        }
                    }
                    catch (Exception saveMainException) {
                        Baubles.log.error("Could not save baubles file for player " + player.func_70005_c_());
                        saveMainException.printStackTrace();
                        if (!mainFile.exists()) break block11;
                        try {
                            mainFile.delete();
                        }
                        catch (Exception exception) {}
                    }
                }
                catch (Exception saveException) {
                    Baubles.log.fatal("Error saving baubles inventory");
                    saveException.printStackTrace();
                }
            }
        }
    }
}

