/*
 * Decompiled with CFR 0.152.
 */
package openmods.calc;

import com.google.common.collect.Maps;
import java.util.Map;
import openmods.calc.Frame;
import openmods.calc.ICallable;
import openmods.calc.IGettable;
import openmods.calc.ISymbol;
import openmods.calc.SingleReturnCallable;
import openmods.calc.SymbolMap;
import openmods.utils.OptionalInt;
import openmods.utils.StackValidationException;

public class TopSymbolMap<E>
extends SymbolMap<E> {
    private final Map<String, ISymbol<E>> globals = Maps.newHashMap();

    @Override
    protected ISymbol<E> createSymbol(ICallable<E> callable) {
        return new CallableSymbol<E>(callable);
    }

    @Override
    protected ISymbol<E> createSymbol(IGettable<E> gettable) {
        return new GettableSymbol<E>(gettable);
    }

    @Override
    protected ISymbol<E> createSymbol(E value) {
        return new ConstantSymbol<E>(value);
    }

    @Override
    public void put(String name, ISymbol<E> symbol) {
        this.globals.put(name, symbol);
    }

    @Override
    public ISymbol<E> get(String name) {
        return this.globals.get(name);
    }

    private static class ConstantSymbol<E>
    extends ValueSymbol<E> {
        private final E value;

        public ConstantSymbol(E value) {
            this.value = value;
        }

        @Override
        public E get() {
            return this.value;
        }
    }

    private static class GettableSymbol<E>
    extends ValueSymbol<E> {
        private final IGettable<E> gettable;

        public GettableSymbol(IGettable<E> gettable) {
            this.gettable = gettable;
        }

        @Override
        public E get() {
            return this.gettable.get();
        }
    }

    private static abstract class ValueSymbol<E>
    extends SingleReturnCallable<E>
    implements ISymbol<E> {
        private ValueSymbol() {
        }

        @Override
        public E call(Frame<E> frame, OptionalInt argumentsCount) {
            if (!argumentsCount.compareIfPresent(0)) {
                throw new StackValidationException("Expected no arguments but got %s", argumentsCount.get());
            }
            return this.get();
        }
    }

    private static class CallableSymbol<E>
    implements ISymbol<E> {
        private final ICallable<E> callable;

        public CallableSymbol(ICallable<E> callable) {
            this.callable = callable;
        }

        @Override
        public void call(Frame<E> frame, OptionalInt argumentsCount, OptionalInt returnsCount) {
            this.callable.call(frame, argumentsCount, returnsCount);
        }

        @Override
        public E get() {
            throw new UnsupportedOperationException("Cannot use function as value");
        }
    }
}

