/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine.genepool;

import binnie.core.craftgui.minecraft.IMachineInformation;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.ModuleMachine;
import binnie.genetics.machine.PackageGeneticBase;
import binnie.genetics.machine.genepool.EthanolTankValidator;
import binnie.genetics.machine.genepool.Genepool;
import binnie.genetics.machine.genepool.GenepoolComponentFX;
import binnie.genetics.machine.genepool.GenepoolComponentLogic;

public class GenepoolPackage
extends PackageGeneticBase
implements IMachineInformation {
    public GenepoolPackage() {
        super("genepool", GeneticsTexture.Genepool, 12661942, true);
    }

    @Override
    public void createMachine(Machine machine) {
        new ComponentGeneticGUI(machine, GeneticsGUI.Genepool);
        ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
        InventorySlot enzymeSlot = inventory.addSlot(7, "enzyme");
        enzymeSlot.setValidator(new SlotValidator.Item(GeneticsItems.Enzyme.get(1), ModuleMachine.IconEnzyme));
        enzymeSlot.forbidExtraction();
        InventorySlot slotBee = inventory.addSlot(0, "process");
        slotBee.setValidator(new SlotValidator.Individual());
        slotBee.setReadOnly();
        slotBee.forbidExtraction();
        inventory.addSlotArray(Genepool.SLOT_RESERVE, "input");
        for (InventorySlot slot : inventory.getSlots(Genepool.SLOT_RESERVE)) {
            slot.setValidator(new SlotValidator.Individual());
            slot.forbidExtraction();
        }
        ComponentTankContainer tanks = new ComponentTankContainer(machine);
        TankSlot dnaSlot = tanks.addTank(0, "output", 2000);
        dnaSlot.setReadOnly();
        TankSlot ethanolSlot = tanks.addTank(1, "input", 1000);
        ethanolSlot.forbidExtraction();
        ethanolSlot.setValidator(new EthanolTankValidator());
        ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
        transfer.addRestock(Genepool.SLOT_RESERVE, 0, 1);
        new ComponentPowerReceptor(machine, 1600);
        new GenepoolComponentLogic(machine);
        ComponentChargedSlots chargedSlots = new ComponentChargedSlots(machine);
        chargedSlots.addCharge(7);
        new GenepoolComponentFX(machine);
    }
}

