/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.worldgen;

import binnie.extratrees.genetics.ExtraTreeSpecies;
import binnie.extratrees.worldgen.BlockType;
import binnie.extratrees.worldgen.BlockTypeLeaf;
import binnie.extratrees.worldgen.BlockTypeLog;
import binnie.extratrees.worldgen.BlockTypeVoid;
import forestry.api.world.ITreeGenData;
import java.util.Random;
import net.minecraft.init.Blocks;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;

public abstract class WorldGenTree
extends WorldGenerator {
    protected ITreeGenData treeGen;
    protected World world;
    protected Random rand;
    protected int startX;
    protected int startY;
    protected int startZ;
    protected int girth;
    protected int height;
    protected int minHeight = 3;
    protected int maxHeight = 80;
    protected boolean spawnPods = false;
    protected int minPodHeight = 3;
    BlockType leaf;
    BlockType wood;
    BlockType vine = new BlockType(Blocks.field_150395_bd, 0);
    BlockType air = new BlockTypeVoid();
    float bushiness = 0.0f;

    public WorldGenTree(ITreeGenData tree) {
        this.spawnPods = tree.allowsFruitBlocks();
        this.treeGen = tree;
    }

    protected int randBetween(int a, int b) {
        return a + this.rand.nextInt(b - a);
    }

    protected float randBetween(float a, float b) {
        return a + this.rand.nextFloat() * (b - a);
    }

    public void generate() {
        this.generateTreeTrunk(this.height, this.girth);
        int leafSpawn = this.height + 1;
        this.generateCylinder(new Vector(0.0f, leafSpawn--, 0.0f), 1.0f, 1, this.leaf, false);
        this.generateCylinder(new Vector(0.0f, leafSpawn--, 0.0f), 1.5f, 1, this.leaf, false);
        this.generateCylinder(new Vector(0.0f, leafSpawn--, 0.0f), 2.9f, 1, this.leaf, false);
        this.generateCylinder(new Vector(0.0f, leafSpawn--, 0.0f), 2.9f, 1, this.leaf, false);
    }

    public boolean canGrow() {
        return this.treeGen.canGrow(this.world, this.startX, this.startY, this.startZ, this.treeGen.getGirth(this.world, this.startX, this.startY, this.startZ), this.height);
    }

    public void preGenerate() {
        this.height = this.determineHeight(5, 3);
        this.girth = this.determineGirth(this.treeGen.getGirth(this.world, this.startX, this.startY, this.startZ));
    }

    protected int determineGirth(int base) {
        return base;
    }

    protected int determineHeight(int required, int variation) {
        int determined = Math.round((float)(required + this.rand.nextInt(variation)) * this.treeGen.getHeightModifier());
        return MathHelper.func_76125_a((int)determined, (int)this.minHeight, (int)this.maxHeight);
    }

    public BlockType getLeaf() {
        return new BlockTypeLeaf(true);
    }

    public BlockType getWood() {
        return new BlockTypeLog(((ExtraTreeSpecies)this.treeGen.getGenome().getPrimary()).getLog());
    }

    public boolean func_76484_a(World world, Random random, int x, int y, int z) {
        return this.generate(world, random, x, y, z, false);
    }

    public boolean generate(World world, Random random, int x, int y, int z, boolean force) {
        this.world = world;
        this.rand = random;
        this.startX = x;
        this.startY = y;
        this.startZ = z;
        this.leaf = this.getLeaf();
        this.wood = this.getWood();
        this.preGenerate();
        if (!force && !this.canGrow()) {
            return false;
        }
        for (int x2 = 0; x2 < this.girth; ++x2) {
            for (int y2 = 0; y2 < this.girth; ++y2) {
                this.addBlock(x2, 0, y2, new BlockTypeVoid(), true);
            }
        }
        this.generate();
        return true;
    }

    protected void generateTreeTrunk(int height, int width) {
        this.generateTreeTrunk(height, width, 0.0f);
    }

    protected void generateTreeTrunk(int height, int width, float vines) {
        int offset = (width - 1) / 2;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < width; ++y) {
                for (int i = 0; i < height; ++i) {
                    this.addWood(x - offset, i, y - offset, true);
                    if (this.rand.nextFloat() < vines) {
                        this.addVine(x - offset - 1, i, y - offset);
                    }
                    if (this.rand.nextFloat() < vines) {
                        this.addVine(x - offset + 1, i, y - offset);
                    }
                    if (this.rand.nextFloat() < vines) {
                        this.addVine(x - offset, i, y - offset - 1);
                    }
                    if (!(this.rand.nextFloat() < vines)) continue;
                    this.addVine(x - offset, i, y - offset + 1);
                }
            }
        }
        if (!this.spawnPods) {
            return;
        }
        for (int y2 = this.minPodHeight; y2 < height; ++y2) {
            for (int x2 = 0; x2 < this.girth; ++x2) {
                for (int z = 0; z < this.girth; ++z) {
                    if (x2 > 0 && x2 < this.girth && z > 0) continue;
                    this.treeGen.trySpawnFruitBlock(this.world, this.startX + x2 + 1, this.startY + y2, this.startZ + z);
                    this.treeGen.trySpawnFruitBlock(this.world, this.startX + x2 - 1, this.startY + y2, this.startZ + z);
                    this.treeGen.trySpawnFruitBlock(this.world, this.startX + x2, this.startY + y2, this.startZ + z + 1);
                    this.treeGen.trySpawnFruitBlock(this.world, this.startX + x2, this.startY + y2, this.startZ + z - 1);
                }
            }
        }
    }

    protected void addBlock(int x, int y, int z, BlockType type, boolean doReplace) {
        if (doReplace || this.world.func_147437_c(this.startX + x, this.startY + y, this.startZ + z)) {
            type.setBlock(this.world, this.treeGen, this.startX + x, this.startY + y, this.startZ + z);
        }
    }

    protected void addWood(int x, int y, int z, boolean doReplace) {
        this.addBlock(x, y, z, this.wood, doReplace);
    }

    protected void addVine(int x, int y, int z) {
        this.addBlock(x, y, z, this.vine, false);
    }

    protected void generateCylinder(Vector center2, float radius, int height, BlockType block, boolean doReplace) {
        float centerOffset = (float)(this.girth - 1) / 2.0f;
        Vector center3 = new Vector(center2.x + centerOffset, center2.y, center2.z + centerOffset);
        Vector start = new Vector(center3.x - radius, center3.y, center3.z - radius);
        Vector area = new Vector(radius * 2.0f + 1.0f, height, radius * 2.0f + 1.0f);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x, y, z);
                    Vector vector2 = new Vector(center3.x, y, center3.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01 && (Vector.distance(new Vector(x, y, z), new Vector(center3.x, y, center3.z)) < (double)(radius - 0.5f) || this.rand.nextFloat() >= this.bushiness)) {
                        this.addBlock(x, y, z, block, doReplace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    protected void generateSphere(Vector center2, int radius, BlockType block, boolean doReplace) {
        float centerOffset = (float)(this.girth - 1) / 2.0f;
        Vector center3 = new Vector(center2.x + centerOffset, center2.y, center2.z + centerOffset);
        Vector start = new Vector(center3.x - (float)radius, center3.y - (float)radius, center3.z - (float)radius);
        Vector area = new Vector(radius * 2 + 1, radius * 2 + 1, radius * 2 + 1);
        int x = (int)start.x;
        while ((float)x < (float)((int)start.x) + area.x) {
            int y = (int)start.y;
            while ((float)y < (float)((int)start.y) + area.y) {
                int z = (int)start.z;
                while ((float)z < (float)((int)start.z) + area.z) {
                    Vector vector = new Vector(x, y, z);
                    Vector vector2 = new Vector(center3.x, center3.y, center3.z);
                    if (Vector.distance(vector, vector2) <= (double)radius + 0.01) {
                        this.addBlock(x, y, z, block, doReplace);
                    }
                    ++z;
                }
                ++y;
            }
            ++x;
        }
    }

    public static class Vector {
        float x;
        float y;
        float z;

        public Vector(float f, float h, float g) {
            this.x = f;
            this.y = h;
            this.z = g;
        }

        public static double distance(Vector a, Vector b) {
            return Math.sqrt(Math.pow(a.x - b.x, 2.0) + Math.pow(a.y - b.y, 2.0) + Math.pow(a.z - b.z, 2.0));
        }
    }
}

