/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.extratrees.api.IDesignSystem;
import binnie.extratrees.api.ILayout;
import binnie.extratrees.api.IPattern;
import binnie.extratrees.carpentry.Layout;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.util.IIcon;

public enum EnumPattern implements IPattern
{
    Blank,
    Octagon,
    Diamond,
    Ringed,
    Squared,
    Multiply,
    Circle,
    Plus,
    Creeper,
    Creeper2,
    Creeper3,
    Creeper4,
    Halved,
    Halved2,
    Striped,
    Striped2,
    ThinStriped,
    ThinStriped2,
    Chequered,
    Tiled,
    VeryThinCorner,
    VeryThinCorner2,
    VeryThinCorner3,
    VeryThinCorner4,
    ThinCorner,
    ThinCorner2,
    ThinCorner3,
    ThinCorner4,
    Corner,
    Corner2,
    Corner3,
    Corner4,
    ThickCorner,
    ThickCorner2,
    ThickCorner3,
    ThickCorner4,
    ThinCurvedCorner,
    ThinCurvedCorner2,
    ThinCurvedCorner3,
    ThinCurvedCorner4,
    CurvedCorner,
    CurvedCorner2,
    CurvedCorner3,
    CurvedCorner4,
    Edged,
    Edged2,
    Edged3,
    Edged4,
    ThinEdged,
    ThinEdged2,
    ThinEdged3,
    ThinEdged4,
    ThinBarred,
    ThinBarred2,
    Barred,
    Barred2,
    ThickBarred,
    ThickBarred2,
    BarredEnd,
    BarredEnd2,
    BarredEnd3,
    BarredEnd4,
    OrnateBarred,
    OrnateBarred2,
    OrnateThinBarred,
    OrnateThinBarred2,
    SplitBarred,
    SplitBarred2,
    SplitBarredCorner,
    SplitBarredCorner2,
    SplitBarredCorner3,
    SplitBarredCorner4,
    SplitBarredTSection,
    SplitBarredTSection2,
    SplitBarredTSection3,
    SplitBarredTSection4,
    SplitCrossed,
    SplitBarredEnd,
    SplitBarredEnd2,
    SplitBarredEnd3,
    SplitBarredEnd4,
    Diagonal,
    Diagonal2,
    ThickDiagonal,
    ThickDiagonal2,
    DiagonalCorner,
    DiagonalCorner2,
    DiagonalCorner3,
    DiagonalCorner4,
    DiagonalTSection,
    DiagonalTSection2,
    DiagonalTSection3,
    DiagonalTSection4,
    DiagonalCurvedCorner,
    DiagonalCurvedCorner2,
    DiagonalCurvedCorner3,
    DiagonalCurvedCorner4,
    DiagonalCurvedTSection,
    DiagonalCurvedTSection2,
    DiagonalCurvedTSection3,
    DiagonalCurvedTSection4,
    DiagonalStriped,
    DiagonalStriped2,
    ThinDiagonalStriped,
    ThinDiagonalStriped2,
    ThinSaltire,
    Saltire,
    ThickSaltire,
    ThinCrossed,
    Crossed,
    ThickCrossed,
    ThinCurvedCrossed,
    ThinTSection,
    ThinTSection2,
    ThinTSection3,
    ThinTSection4,
    TSection,
    TSection2,
    TSection3,
    TSection4,
    ThickTSection,
    ThickTSection2,
    ThickTSection3,
    ThickTSection4,
    ThinCurvedTSection,
    ThinCurvedTSection2,
    ThinCurvedTSection3,
    ThinCurvedTSection4,
    CurvedTSection,
    CurvedTSection2,
    CurvedTSection3,
    CurvedTSection4,
    ThinBarredCorner,
    ThinBarredCorner2,
    ThinBarredCorner3,
    ThinBarredCorner4,
    BarredCorner,
    BarredCorner2,
    BarredCorner3,
    BarredCorner4,
    ThickBarredCorner,
    ThickBarredCorner2,
    ThickBarredCorner3,
    ThickBarredCorner4,
    ThinCurvedBarredCorner,
    ThinCurvedBarredCorner2,
    ThinCurvedBarredCorner3,
    ThinCurvedBarredCorner4,
    BarredCurvedCorner,
    BarredCurvedCorner2,
    BarredCurvedCorner3,
    BarredCurvedCorner4,
    ThinStripedCorner,
    ThinStripedCorner2,
    ThinStripedCorner3,
    ThinStripedCorner4,
    StripedCorner,
    StripedCorner2,
    StripedCorner3,
    StripedCorner4,
    OrnateStripedCorner,
    OrnateStripedCorner2,
    OrnateStripedCorner3,
    OrnateStripedCorner4,
    Emblem1,
    Emblem2,
    Emblem3,
    Emblem4,
    Emblem5,
    LetterA,
    LetterA2,
    LetterA3,
    LetterA4,
    LetterB,
    LetterB2,
    LetterB3,
    LetterB4,
    LetterF,
    LetterF2,
    LetterF3,
    LetterF4,
    LetterS,
    LetterS2,
    LetterS3,
    LetterS4,
    LetterT,
    LetterT2,
    LetterT3,
    LetterT4,
    DiagonalHalved,
    DiagonalHalved2,
    Diagonal1Edged,
    Diagonal1Edged2,
    Diagonal1Edged3,
    Diagonal1Edged4,
    Diagonal2Edged,
    Diagonal2Edged2,
    ThickDiagonal1Edged,
    ThickDiagonal1Edged2,
    ThickDiagonal1Edged3,
    ThickDiagonal1Edged4,
    ThinBarredEnd,
    ThinBarredEnd2,
    ThinBarredEnd3,
    ThinBarredEnd4,
    ThickBarredEnd,
    ThickBarredEnd2,
    ThickBarredEnd3,
    ThickBarredEnd4,
    OverlappedSplitBarred,
    OverlappedSplitBarred2,
    OverlappedBarred,
    OverlappedBarred2;

    private ILayout leftRotation = Layout.get(this, false);
    private ILayout horizontalFlip = Layout.get(this, false);
    public static final EnumPattern[] VALUES;

    static void setupStripedPattern(EnumPattern vert, EnumPattern hori) {
        vert.setLeftRotation(hori, true);
        hori.setLeftRotation(vert, false);
        vert.setHorizontalFlip(vert, true);
    }

    static void setupChequeredPattern(EnumPattern cheq) {
        cheq.setLeftRotation(cheq, true);
        cheq.setHorizontalFlip(cheq, true);
    }

    static void setupCornerPattern(EnumPattern tl, EnumPattern tr, EnumPattern br, EnumPattern bl) {
        tl.setLeftRotation(bl, false);
        tr.setLeftRotation(tl, false);
        br.setLeftRotation(tr, false);
        bl.setLeftRotation(br, false);
        tl.setHorizontalFlip(tr, false);
        bl.setHorizontalFlip(br, false);
    }

    static void setupInvert2Rot(EnumPattern a, EnumPattern b) {
        a.setLeftRotation(b, true);
        b.setLeftRotation(a, false);
        a.setHorizontalFlip(b, false);
    }

    static void set2Rotation(EnumPattern a, EnumPattern b) {
        a.setLeftRotation(b, false);
        b.setLeftRotation(a, false);
        a.setHorizontalFlip(b, false);
    }

    static void setupBarredPattern(EnumPattern vert, EnumPattern hori) {
        vert.setLeftRotation(hori, false);
        hori.setLeftRotation(vert, false);
    }

    static void setupEdgedPattern(EnumPattern l, EnumPattern t, EnumPattern r, EnumPattern b) {
        l.setLeftRotation(b, false);
        t.setLeftRotation(l, false);
        r.setLeftRotation(t, false);
        b.setLeftRotation(r, false);
        l.setHorizontalFlip(r, false);
    }

    static void setupDiagonalPattern(EnumPattern a, EnumPattern b) {
        a.setLeftRotation(b, false);
        b.setLeftRotation(a, false);
        a.setHorizontalFlip(b, false);
    }

    static void setupBarredPattern(EnumPattern l, EnumPattern t, EnumPattern r, EnumPattern b) {
        l.setLeftRotation(b, false);
        t.setLeftRotation(l, false);
        r.setLeftRotation(t, false);
        b.setLeftRotation(r, false);
        l.setHorizontalFlip(r, false);
    }

    static void setupTSectionPattern(EnumPattern l, EnumPattern t, EnumPattern r, EnumPattern b) {
        EnumPattern.setupEdgedPattern(l, t, r, b);
    }

    private static void setupRotation(EnumPattern t, EnumPattern r, EnumPattern b, EnumPattern l) {
        EnumPattern.setupEdgedPattern(l, t, r, b);
    }

    @Override
    public IIcon getPrimaryIcon(IDesignSystem system) {
        return system.getPrimaryIcon(this);
    }

    private void setHorizontalFlip(EnumPattern pattern, boolean inverted) {
        this.horizontalFlip = Layout.get(pattern, inverted);
        pattern.horizontalFlip = Layout.get(this, inverted);
    }

    @Override
    public IIcon getSecondaryIcon(IDesignSystem system) {
        return system.getSecondaryIcon(this);
    }

    @Override
    public ILayout getRotation() {
        return this.leftRotation;
    }

    @Override
    public ILayout getHorizontalFlip() {
        return this.horizontalFlip;
    }

    private void setLeftRotation(EnumPattern pattern, boolean inverted) {
        this.leftRotation = Layout.get(pattern, inverted);
    }

    @Override
    public void registerIcons(IIconRegister register) {
    }

    public ILayout layout() {
        return this.layout(false);
    }

    public ILayout layout(boolean invert) {
        return Layout.get(this, invert);
    }

    static {
        EnumPattern.setupStripedPattern(ThinStriped, ThinStriped2);
        EnumPattern.setupStripedPattern(Striped, Striped2);
        EnumPattern.setupStripedPattern(Halved, Halved2);
        EnumPattern.setupChequeredPattern(Chequered);
        EnumPattern.setupChequeredPattern(Tiled);
        EnumPattern.setupCornerPattern(VeryThinCorner, VeryThinCorner2, VeryThinCorner3, VeryThinCorner4);
        EnumPattern.setupCornerPattern(ThinCorner, ThinCorner2, ThinCorner3, ThinCorner4);
        EnumPattern.setupCornerPattern(Corner, Corner2, Corner3, Corner4);
        EnumPattern.setupCornerPattern(ThickCorner, ThickCorner2, ThickCorner3, ThickCorner4);
        EnumPattern.setupCornerPattern(ThinCurvedCorner, ThinCurvedCorner2, ThinCurvedCorner3, ThinCurvedCorner4);
        EnumPattern.setupCornerPattern(CurvedCorner, CurvedCorner2, CurvedCorner3, CurvedCorner4);
        EnumPattern.setupBarredPattern(BarredEnd, BarredEnd2, BarredEnd3, BarredEnd4);
        EnumPattern.setupEdgedPattern(ThinEdged, ThinEdged2, ThinEdged3, ThinEdged4);
        EnumPattern.setupEdgedPattern(Edged, Edged2, Edged3, Edged4);
        EnumPattern.setupBarredPattern(ThinBarred, ThinBarred2);
        EnumPattern.setupBarredPattern(Barred, Barred2);
        EnumPattern.setupBarredPattern(ThickBarred, ThickBarred2);
        EnumPattern.setupDiagonalPattern(Diagonal, Diagonal2);
        EnumPattern.setupDiagonalPattern(ThickDiagonal, ThickDiagonal2);
        EnumPattern.setupTSectionPattern(ThinTSection, ThinTSection2, ThinTSection3, ThinTSection4);
        EnumPattern.setupTSectionPattern(TSection, TSection2, TSection3, TSection4);
        EnumPattern.setupTSectionPattern(ThickTSection, ThickTSection2, ThickTSection3, ThickTSection4);
        EnumPattern.setupTSectionPattern(ThinCurvedTSection, ThinCurvedTSection2, ThinCurvedTSection3, ThinCurvedTSection4);
        EnumPattern.setupTSectionPattern(CurvedTSection, CurvedTSection2, CurvedTSection3, CurvedTSection4);
        EnumPattern.setupCornerPattern(ThinBarredCorner, ThinBarredCorner2, ThinBarredCorner3, ThinBarredCorner4);
        EnumPattern.setupCornerPattern(BarredCorner, BarredCorner2, BarredCorner3, BarredCorner4);
        EnumPattern.setupCornerPattern(ThickBarredCorner, ThickBarredCorner2, ThickBarredCorner3, ThickBarredCorner4);
        EnumPattern.setupCornerPattern(ThinCurvedBarredCorner, ThinCurvedBarredCorner2, ThinCurvedBarredCorner3, ThinCurvedBarredCorner4);
        EnumPattern.setupCornerPattern(BarredCurvedCorner, BarredCurvedCorner2, BarredCurvedCorner3, BarredCurvedCorner4);
        EnumPattern.setupCornerPattern(ThinStripedCorner, ThinStripedCorner2, ThinStripedCorner3, ThinStripedCorner4);
        EnumPattern.setupCornerPattern(StripedCorner, StripedCorner2, StripedCorner3, StripedCorner4);
        EnumPattern.setupCornerPattern(OrnateStripedCorner, OrnateStripedCorner2, OrnateStripedCorner3, OrnateStripedCorner4);
        EnumPattern.setupRotation(LetterA, LetterA2, LetterA3, LetterA4);
        EnumPattern.setupRotation(LetterB, LetterB2, LetterB3, LetterB4);
        EnumPattern.setupRotation(LetterF, LetterF2, LetterF3, LetterF4);
        EnumPattern.setupRotation(LetterS, LetterS2, LetterS3, LetterS4);
        EnumPattern.setupRotation(LetterT, LetterT2, LetterT3, LetterT4);
        EnumPattern.setupEdgedPattern(DiagonalCorner, DiagonalCorner2, DiagonalCorner3, DiagonalCorner4);
        EnumPattern.setupCornerPattern(DiagonalTSection, DiagonalTSection2, DiagonalTSection3, DiagonalTSection4);
        EnumPattern.setupEdgedPattern(DiagonalCurvedCorner, DiagonalCurvedCorner2, DiagonalCurvedCorner3, DiagonalCurvedCorner4);
        EnumPattern.setupCornerPattern(DiagonalCurvedTSection, DiagonalCurvedTSection2, DiagonalCurvedTSection3, DiagonalCurvedTSection4);
        EnumPattern.setupBarredPattern(OrnateBarred, OrnateBarred2);
        EnumPattern.setupBarredPattern(OrnateThinBarred, OrnateThinBarred2);
        EnumPattern.setupBarredPattern(SplitBarred, SplitBarred2);
        EnumPattern.setupCornerPattern(SplitBarredCorner, SplitBarredCorner2, SplitBarredCorner3, SplitBarredCorner4);
        EnumPattern.setupTSectionPattern(SplitBarredTSection, SplitBarredTSection2, SplitBarredTSection3, SplitBarredTSection4);
        EnumPattern.setupBarredPattern(SplitBarredEnd, SplitBarredEnd2, SplitBarredEnd3, SplitBarredEnd4);
        EnumPattern.setupRotation(Creeper, Creeper2, Creeper3, Creeper4);
        EnumPattern.setupDiagonalPattern(DiagonalStriped, DiagonalStriped2);
        EnumPattern.setupDiagonalPattern(ThinDiagonalStriped, ThinDiagonalStriped2);
        EnumPattern.setupCornerPattern(Diagonal1Edged, Diagonal1Edged2, Diagonal1Edged3, Diagonal1Edged4);
        EnumPattern.setupCornerPattern(ThickDiagonal1Edged, ThickDiagonal1Edged2, ThickDiagonal1Edged3, ThickDiagonal1Edged4);
        EnumPattern.setupInvert2Rot(DiagonalHalved, DiagonalHalved2);
        EnumPattern.set2Rotation(Diagonal2Edged, Diagonal2Edged2);
        EnumPattern.setupBarredPattern(ThinBarredEnd, ThinBarredEnd2, ThinBarredEnd3, ThinBarredEnd4);
        EnumPattern.setupBarredPattern(ThickBarredEnd, ThickBarredEnd2, ThickBarredEnd3, ThickBarredEnd4);
        OverlappedBarred.setLeftRotation(OverlappedBarred2, false);
        OverlappedBarred2.setLeftRotation(OverlappedBarred, false);
        OverlappedSplitBarred.setLeftRotation(OverlappedSplitBarred2, false);
        OverlappedSplitBarred2.setLeftRotation(OverlappedSplitBarred, false);
        VALUES = EnumPattern.values();
    }
}

