/*
 * Decompiled with CFR 0.152.
 */
package codechicken.translocator;

import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.raytracer.RayTracer;
import codechicken.lib.vec.BlockCoord;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Translation;
import codechicken.lib.vec.Vector3;
import codechicken.translocator.TileCraftingGrid;
import codechicken.translocator.Translocator;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.DrawBlockHighlightEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class BlockCraftingGrid
extends Block {
    private final RayTracer rayTracer = new RayTracer();
    @SideOnly(value=Side.CLIENT)
    public IIcon gridIcon;
    ThreadLocal<BlockCoord> replaceCheck = new ThreadLocal();

    public BlockCraftingGrid() {
        super(Material.field_151575_d);
        MinecraftForge.EVENT_BUS.register((Object)new EventHandler());
    }

    public boolean hasTileEntity(int meta) {
        return meta == 0;
    }

    public TileEntity createTileEntity(World world, int meta) {
        return new TileCraftingGrid();
    }

    public AxisAlignedBB func_149668_a(World par1World, int par2, int par3, int par4) {
        return null;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean func_149686_d() {
        return false;
    }

    public int func_149645_b() {
        return -1;
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        return willHarvest || super.removedByPlayer(world, player, x, y, z, false);
    }

    public void func_149636_a(World world, EntityPlayer player, int x, int y, int z, int meta) {
        super.func_149636_a(world, player, x, y, z, meta);
        world.func_147468_f(x, y, z);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList<ItemStack> ai = new ArrayList<ItemStack>();
        if (world.field_72995_K) {
            return ai;
        }
        TileCraftingGrid tcraft = (TileCraftingGrid)world.func_147438_o(x, y, z);
        if (tcraft != null) {
            for (ItemStack item : tcraft.items) {
                if (item == null) continue;
                ai.add(item.func_77946_l());
            }
        }
        return ai;
    }

    public MovingObjectPosition func_149731_a(World world, int x, int y, int z, Vec3 start, Vec3 end) {
        return this.rayTracer.rayTraceCuboids(new Vector3(start), new Vector3(end), this.getParts(world, x, y, z), new BlockCoord(x, y, z), (Block)this);
    }

    public List<IndexedCuboid6> getParts(World world, int x, int y, int z) {
        LinkedList<IndexedCuboid6> parts = new LinkedList<IndexedCuboid6>();
        parts.add(new IndexedCuboid6((Object)0, new Cuboid6(0.0, 0.0, 0.0, 1.0, 0.005, 1.0).add(new Vector3((double)x, (double)y, (double)z))));
        TileCraftingGrid tcraft = (TileCraftingGrid)world.func_147438_o(x, y, z);
        for (int i = 0; i < 9; ++i) {
            Cuboid6 box = new Cuboid6(0.0625, 0.0, 0.0625, 0.3125, 0.01, 0.3125).apply((Transformation)new Translation((double)(i % 3 * 5) / 16.0, 0.0, (double)(i / 3 * 5) / 16.0).with(Rotation.quarterRotations[tcraft.rotation].at(Vector3.center)).with((Transformation)new Translation((double)x, (double)y, (double)z)));
            parts.add(new IndexedCuboid6((Object)(i + 1), box));
        }
        return parts;
    }

    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float hitX, float hitY, float hitZ) {
        if (world.field_72995_K) {
            return true;
        }
        MovingObjectPosition hit = RayTracer.retraceBlock((World)world, (EntityPlayer)player, (int)x, (int)y, (int)z);
        TileCraftingGrid tcraft = (TileCraftingGrid)world.func_147438_o(x, y, z);
        if (hit != null) {
            if (hit.subHit > 0) {
                tcraft.activate(hit.subHit - 1, player);
            }
            return true;
        }
        return false;
    }

    public boolean placeBlock(World world, EntityPlayer player, int x, int y, int z, int side) {
        if (Translocator.disableCraftingGridKey) {
            return false;
        }
        Block block = world.func_147439_a(x, y, z);
        if (side != 1 && block != Blocks.field_150431_aC) {
            return false;
        }
        if (block != Blocks.field_150395_bd && block != Blocks.field_150329_H && block != Blocks.field_150330_I && !block.isReplaceable((IBlockAccess)world, x, y, z)) {
            ++y;
        }
        if (!world.isSideSolid(x, y - 1, z, ForgeDirection.UP)) {
            return false;
        }
        if (!world.func_147472_a((Block)this, x, y, z, false, 1, null, null)) {
            return false;
        }
        player.func_71038_i();
        if (!world.func_147449_b(x, y, z, (Block)this)) {
            return false;
        }
        this.func_149689_a(world, x, y, z, (EntityLivingBase)player, null);
        return true;
    }

    public boolean isReplaceable(IBlockAccess world, int x, int y, int z) {
        this.replaceCheck.set(new BlockCoord(x, y, z));
        return true;
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        BlockCoord beneath = new BlockCoord(x, y, z).offset(0);
        if (!world.isSideSolid(beneath.x, beneath.y, beneath.z, ForgeDirection.UP)) {
            this.func_149697_b(world, x, y, z, 0, 0);
            world.func_147468_f(x, y, z);
        }
    }

    public void func_149689_a(World world, int i, int j, int k, EntityLivingBase entity, ItemStack item) {
        ((TileCraftingGrid)world.func_147438_o(i, j, k)).onPlaced(entity);
    }

    public void func_149725_f(World world, int x, int y, int z, int meta) {
        BlockCoord c = this.replaceCheck.get();
        if (!world.field_72995_K && c != null && c.equals((Object)new BlockCoord(x, y, z))) {
            this.func_149697_b(world, x, y, z, meta, 0);
        }
        this.replaceCheck.set(null);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149651_a(IIconRegister register) {
        super.func_149651_a(register);
        this.gridIcon = register.func_94245_a("translocator:craftingGrid");
    }

    public class EventHandler {
        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onBlockHighlight(DrawBlockHighlightEvent event) {
            if (event.target.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && event.player.field_70170_p.func_147439_a(event.target.field_72311_b, event.target.field_72312_c, event.target.field_72309_d) == BlockCraftingGrid.this) {
                RayTracer.retraceBlock((World)event.player.field_70170_p, (EntityPlayer)event.player, (int)event.target.field_72311_b, (int)event.target.field_72312_c, (int)event.target.field_72309_d);
            }
        }
    }
}

