/*
 * Decompiled with CFR 0.152.
 */
package pl.asie.computronics.item;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import dan200.computercraft.api.filesystem.IMount;
import dan200.computercraft.api.media.IMedia;
import dan200.computercraft.api.media.IMediaProvider;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;
import pl.asie.computronics.Computronics;
import pl.asie.computronics.api.tape.IItemTapeStorage;
import pl.asie.computronics.api.tape.ITapeStorage;
import pl.asie.computronics.item.entity.EntityItemIndestructable;
import pl.asie.computronics.oc.manual.IItemWithDocumentation;
import pl.asie.computronics.reference.Mods;
import pl.asie.computronics.tape.TapeStorage;
import pl.asie.computronics.util.StringUtil;
import pl.asie.lib.util.color.ItemColorizer;

@Optional.InterfaceList(value={@Optional.Interface(iface="dan200.computercraft.api.media.IMediaProvider", modid="ComputerCraft"), @Optional.Interface(iface="dan200.computercraft.api.media.IMedia", modid="ComputerCraft")})
public class ItemTape
extends Item
implements IItemTapeStorage,
IMedia,
IMediaProvider,
IItemWithDocumentation {
    public static final int L_SECOND = 4096;
    public static final int L_MINUTE = 245760;
    private static final int TAPE_COUNT = 10;
    private static final int[] DEFAULT_LENGTHS = new int[]{4, 8, 16, 32, 64, 2, 6, 16, 128, 128};
    private int[] sizes;
    private IIcon tape_i;
    private IIcon tape_g;
    private IIcon tape_d;
    private IIcon tape_n;
    private IIcon tape_c;
    private IIcon tape_co;
    private IIcon tape_st;
    private IIcon tape_greg;
    private IIcon tape_ig;
    private IIcon tape_ig_GT6;

    public ItemTape(String lengths) {
        this.func_77655_b("computronics.tape");
        this.func_111206_d("computronics:tape");
        this.func_77637_a(Computronics.tab);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77625_d(1);
        String[] l = lengths.split(",");
        this.sizes = new int[10];
        for (int i = 0; i < 10; ++i) {
            if (i < l.length) {
                try {
                    this.sizes[i] = Integer.parseInt(l[i]) * 245760;
                }
                catch (NumberFormatException e) {
                    Computronics.log.error("Property 'tapedrive.tapeLengths' in computronics.cfg contains entry that is not a number! Setting entry " + String.valueOf(i + 1) + " ['" + l[i] + "'] to " + DEFAULT_LENGTHS[i]);
                    e.printStackTrace();
                    this.sizes[i] = DEFAULT_LENGTHS[i] * 245760;
                }
                if (this.sizes[i] > 0) continue;
                this.sizes[i] = 4;
                continue;
            }
            Computronics.log.warn("Property 'tapedrive.tapeLengths' contains too few entries, setting entry " + String.valueOf(i + 1) + " to " + DEFAULT_LENGTHS[i]);
            this.sizes[i] = DEFAULT_LENGTHS[i] * 245760;
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister r) {
        this.tape_i = r.func_94245_a("computronics:tape");
        this.tape_g = r.func_94245_a("computronics:tape_gold");
        this.tape_d = r.func_94245_a("computronics:tape_diamond");
        this.tape_n = r.func_94245_a("computronics:tape_nether_star");
        this.tape_c = r.func_94245_a("computronics:tape_cover");
        this.tape_co = r.func_94245_a("computronics:tape_copper");
        this.tape_st = r.func_94245_a("computronics:tape_steel");
        this.tape_greg = r.func_94245_a("computronics:tape_greg");
        this.tape_ig = r.func_94245_a("computronics:tape_ig");
        this.tape_ig_GT6 = r.func_94245_a("computronics:tape_ig_GT6");
    }

    public IIcon func_77618_c(int meta, int pass) {
        if (pass == 0) {
            switch (meta) {
                case 0: {
                    return this.tape_i;
                }
                case 1: {
                    return this.tape_g;
                }
                case 2: {
                    return this.tape_g;
                }
                case 3: {
                    return this.tape_d;
                }
                case 4: {
                    return this.tape_n;
                }
                case 5: {
                    return this.tape_co;
                }
                case 6: {
                    return this.tape_st;
                }
                case 7: {
                    return this.tape_greg;
                }
                case 8: {
                    return this.tape_n;
                }
                case 9: {
                    if (Mods.hasVersion("gregtech", "[GT6-MC1710]")) {
                        return this.tape_ig_GT6;
                    }
                    return this.tape_ig;
                }
            }
            return this.tape_i;
        }
        return this.tape_c;
    }

    public String getLabel(ItemStack stack) {
        return stack.func_77942_o() && stack.func_77978_p().func_74764_b("label") ? stack.func_77978_p().func_74779_i("label") : "";
    }

    public boolean setLabel(ItemStack stack, String label) {
        if (stack == null) {
            return false;
        }
        stack.func_77978_p().func_74778_a("label", label);
        return true;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List text, boolean par4) {
        String label;
        int size = this.getSize(stack);
        int len = (int)Math.floor(size / 245760);
        if (stack.func_77978_p() != null && (label = this.getLabel(stack)).length() > 0) {
            text.add(EnumChatFormatting.WHITE + "" + EnumChatFormatting.ITALIC + label);
        }
        text.add(EnumChatFormatting.GRAY + StringUtil.localizeAndFormat("tooltip.computronics.tape.length", "" + len));
        switch (stack.func_77960_j()) {
            case 7: {
                text.add(EnumChatFormatting.AQUA + StringUtil.localize("tooltip.computronics.tape.balanced"));
                break;
            }
            case 9: {
                String[] local;
                for (String s : local = StringUtil.localize("tooltip.computronics.tape.ig").replace("\\n", "\n").split("\\n")) {
                    text.add(EnumChatFormatting.AQUA + s);
                }
                break;
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs tabs, List list) {
        for (int i = 0; i < 10; ++i) {
            if ((i == 7 || i == 9) && !Mods.isLoaded("gregtech")) continue;
            list.add(new ItemStack(item, 1, i));
        }
    }

    @Override
    public int getSize(ItemStack stack) {
        return this.getSize(stack.func_77960_j());
    }

    public int getSize(int meta) {
        return this.sizes[meta % this.sizes.length];
    }

    @Override
    public ITapeStorage getStorage(ItemStack stack) {
        NBTTagCompound nbt;
        String storageName;
        int size = this.getSize(stack);
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b("storage") && Computronics.storage.exists(storageName = (nbt = stack.func_77978_p()).func_74779_i("storage"))) {
            return Computronics.storage.get(storageName, size, 0);
        }
        TapeStorage storage = Computronics.storage.newStorage(size);
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        stack.func_77978_p().func_74778_a("storage", storage.getUniqueId());
        return storage;
    }

    public String func_77667_c(ItemStack itemstack) {
        if (itemstack != null && itemstack.func_77960_j() == 9) {
            return "item.computronics.tape.ig";
        }
        return super.func_77667_c(itemstack);
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return stack != null && stack.func_77960_j() == 9;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        if (itemstack != null && itemstack.func_77960_j() == 9) {
            EntityItemIndestructable newTapeEntity = new EntityItemIndestructable(world, location.field_70165_t, location.field_70163_u, location.field_70161_v, itemstack);
            newTapeEntity.field_145804_b = 40;
            newTapeEntity.field_70159_w = location.field_70159_w;
            newTapeEntity.field_70181_x = location.field_70181_x;
            newTapeEntity.field_70179_y = location.field_70179_y;
            return newTapeEntity;
        }
        return super.createEntity(world, location, itemstack);
    }

    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int pass) {
        return pass == 0 ? 0xFFFFFF : (ItemColorizer.hasColor((ItemStack)stack) ? ItemColorizer.getColor((ItemStack)stack) : 0xFFFFFF);
    }

    public boolean hasEffect(ItemStack stack, int pass) {
        return pass == 0 && stack != null && stack.func_77960_j() == 8 || super.hasEffect(stack, pass);
    }

    @Optional.Method(modid="ComputerCraft")
    public IMedia getMedia(ItemStack stack) {
        if (stack != null && stack.field_77994_a > 0 && stack.func_77973_b() != null && stack.func_77973_b() instanceof ItemTape) {
            return (IMedia)stack.func_77973_b();
        }
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getAudioTitle(ItemStack stack) {
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public String getAudioRecordName(ItemStack stack) {
        return null;
    }

    @Optional.Method(modid="ComputerCraft")
    public IMount createDataMount(ItemStack stack, World world) {
        return null;
    }

    @Override
    public String getDocumentationName(ItemStack stack) {
        return "tape";
    }
}

