/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.util.BlockPos;
import net.malisis.core.util.BlockState;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class AABBUtils {
    private static int[] cos = new int[]{1, 0, -1, 0};
    private static int[] sin = new int[]{0, 1, 0, -1};

    public static AxisAlignedBB identity() {
        return AABBUtils.identity(0, 0, 0);
    }

    public static AxisAlignedBB identity(BlockPos pos) {
        return AABBUtils.identity(pos.getX(), pos.getY(), pos.getZ());
    }

    public static AxisAlignedBB identity(int x, int y, int z) {
        return AxisAlignedBB.func_72330_a((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
    }

    public static AxisAlignedBB[] identities() {
        return AABBUtils.identities(0, 0, 0);
    }

    public static AxisAlignedBB[] identities(BlockPos pos) {
        return AABBUtils.identities(pos.getX(), pos.getX(), pos.getZ());
    }

    public static AxisAlignedBB[] identities(int x, int y, int z) {
        return new AxisAlignedBB[]{AABBUtils.identity(x, y, z)};
    }

    private static int getAngle(ForgeDirection dir) {
        switch (dir) {
            case EAST: {
                return 1;
            }
            case SOUTH: {
                return 2;
            }
            case WEST: {
                return 3;
            }
        }
        return 0;
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, ForgeDirection dir) {
        return AABBUtils.rotate(aabb, AABBUtils.getAngle(dir));
    }

    public static AxisAlignedBB[] rotate(AxisAlignedBB[] aabbs, ForgeDirection dir) {
        return AABBUtils.rotate(aabbs, AABBUtils.getAngle(dir));
    }

    public static AxisAlignedBB[] rotate(AxisAlignedBB[] aabbs, int angle) {
        for (AxisAlignedBB aabb : aabbs) {
            AABBUtils.rotate(aabb, angle);
        }
        return aabbs;
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, int angle) {
        return AABBUtils.rotate(aabb, angle, Axis.Y);
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, int angle, Axis axis) {
        if (aabb == null) {
            return null;
        }
        int a = angle % 4;
        if (a < 0) {
            a += 4;
        }
        int s = sin[a];
        int c = cos[a];
        AxisAlignedBB copy = AxisAlignedBB.func_72330_a((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
        aabb.func_72317_d(-0.5, -0.5, -0.5);
        copy.func_72328_c(aabb);
        if (axis == Axis.X) {
            copy.field_72338_b = aabb.field_72338_b * (double)c - aabb.field_72339_c * (double)s;
            copy.field_72337_e = aabb.field_72337_e * (double)c - aabb.field_72334_f * (double)s;
            copy.field_72339_c = aabb.field_72338_b * (double)s + aabb.field_72339_c * (double)c;
            copy.field_72334_f = aabb.field_72337_e * (double)s + aabb.field_72334_f * (double)c;
        }
        if (axis == Axis.Y) {
            copy.field_72340_a = aabb.field_72340_a * (double)c - aabb.field_72339_c * (double)s;
            copy.field_72336_d = aabb.field_72336_d * (double)c - aabb.field_72334_f * (double)s;
            copy.field_72339_c = aabb.field_72340_a * (double)s + aabb.field_72339_c * (double)c;
            copy.field_72334_f = aabb.field_72336_d * (double)s + aabb.field_72334_f * (double)c;
        }
        if (axis == Axis.Z) {
            copy.field_72340_a = aabb.field_72340_a * (double)c - aabb.field_72338_b * (double)s;
            copy.field_72336_d = aabb.field_72336_d * (double)c - aabb.field_72337_e * (double)s;
            copy.field_72338_b = aabb.field_72340_a * (double)s + aabb.field_72338_b * (double)c;
            copy.field_72337_e = aabb.field_72336_d * (double)s + aabb.field_72337_e * (double)c;
        }
        aabb.func_72328_c(AABBUtils.fix(copy));
        aabb.func_72317_d(0.5, 0.5, 0.5);
        return aabb;
    }

    public static AxisAlignedBB fix(AxisAlignedBB aabb) {
        double tmp;
        if (aabb.field_72340_a > aabb.field_72336_d) {
            tmp = aabb.field_72340_a;
            aabb.field_72340_a = aabb.field_72336_d;
            aabb.field_72336_d = tmp;
        }
        if (aabb.field_72338_b > aabb.field_72337_e) {
            tmp = aabb.field_72338_b;
            aabb.field_72338_b = aabb.field_72337_e;
            aabb.field_72337_e = tmp;
        }
        if (aabb.field_72339_c > aabb.field_72334_f) {
            tmp = aabb.field_72339_c;
            aabb.field_72339_c = aabb.field_72334_f;
            aabb.field_72334_f = tmp;
        }
        return aabb;
    }

    public static AxisAlignedBB readFromNBT(NBTTagCompound tag, AxisAlignedBB aabb) {
        return aabb.func_72324_b(tag.func_74769_h("minX"), tag.func_74769_h("minY"), tag.func_74769_h("minZ"), tag.func_74769_h("maxX"), tag.func_74769_h("maxY"), tag.func_74769_h("maxZ"));
    }

    public static void writeToNBT(NBTTagCompound tag, AxisAlignedBB aabb) {
        if (aabb == null) {
            return;
        }
        tag.func_74780_a("minX", aabb.field_72340_a);
        tag.func_74780_a("minY", aabb.field_72338_b);
        tag.func_74780_a("minZ", aabb.field_72339_c);
        tag.func_74780_a("maxX", aabb.field_72336_d);
        tag.func_74780_a("maxY", aabb.field_72337_e);
        tag.func_74780_a("maxZ", aabb.field_72334_f);
    }

    public static AxisAlignedBB combine(AxisAlignedBB[] aabbs) {
        AxisAlignedBB ret = AxisAlignedBB.func_72330_a((double)Double.MAX_VALUE, (double)Double.MAX_VALUE, (double)Double.MAX_VALUE, (double)Double.MIN_VALUE, (double)Double.MAX_VALUE, (double)Double.MAX_VALUE);
        for (AxisAlignedBB aabb : aabbs) {
            ret.field_72340_a = Math.min(aabb.field_72340_a, ret.field_72340_a);
            ret.field_72336_d = Math.max(aabb.field_72336_d, ret.field_72336_d);
            ret.field_72338_b = Math.min(aabb.field_72338_b, ret.field_72338_b);
            ret.field_72337_e = Math.max(aabb.field_72337_e, ret.field_72337_e);
            ret.field_72339_c = Math.min(aabb.field_72339_c, ret.field_72339_c);
            ret.field_72334_f = Math.max(aabb.field_72334_f, ret.field_72334_f);
        }
        return ret;
    }

    public static AxisAlignedBB[] offset(double x, double y, double z, AxisAlignedBB ... aabbs) {
        return AABBUtils.offset(new BlockPos(x, y, z), aabbs);
    }

    public static AxisAlignedBB[] offset(BlockPos pos, AxisAlignedBB ... aabbs) {
        if (aabbs == null) {
            return null;
        }
        for (AxisAlignedBB aabb : aabbs) {
            if (aabb == null) continue;
            aabb.func_72317_d((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        }
        return aabbs;
    }

    public static boolean isColliding(AxisAlignedBB aabb, AxisAlignedBB[] aabbs) {
        return AABBUtils.isColliding(new AxisAlignedBB[]{aabb}, aabbs);
    }

    public static boolean isColliding(AxisAlignedBB[] aabbs, AxisAlignedBB aabb) {
        return AABBUtils.isColliding(aabbs, new AxisAlignedBB[]{aabb});
    }

    public static boolean isColliding(AxisAlignedBB[] aabbs1, AxisAlignedBB[] aabbs2) {
        for (AxisAlignedBB aabb1 : aabbs1) {
            if (aabb1 == null) continue;
            for (AxisAlignedBB aabb2 : aabbs2) {
                if (aabb2 == null || !aabb1.func_72326_a(aabb2)) continue;
                return true;
            }
        }
        return false;
    }

    public static AxisAlignedBB[] getCollisionBoundingBoxes(World world, Block block, int x, int y, int z) {
        return AABBUtils.getCollisionBoundingBoxes(world, new BlockState(x, y, z, block), false);
    }

    public static AxisAlignedBB[] getCollisionBoundingBoxes(World world, Block block, int x, int y, int z, boolean offset) {
        return AABBUtils.getCollisionBoundingBoxes(world, new BlockState(x, y, z, block), offset);
    }

    public static AxisAlignedBB[] getCollisionBoundingBoxes(World world, BlockState state) {
        return AABBUtils.getCollisionBoundingBoxes(world, state, false);
    }

    public static AxisAlignedBB[] getCollisionBoundingBoxes(World world, BlockState state, boolean offset) {
        AxisAlignedBB[] aabbs = new AxisAlignedBB[]{};
        if (state.getBlock() instanceof MalisisBlock) {
            aabbs = ((MalisisBlock)state.getBlock()).getBoundingBox((IBlockAccess)world, state.getX(), state.getY(), state.getZ(), BoundingBoxType.CHUNKCOLLISION);
        } else {
            AxisAlignedBB aabb = state.getBlock().func_149668_a(world, state.getX(), state.getY(), state.getZ());
            if (aabb != null) {
                aabbs = new AxisAlignedBB[]{aabb.func_72317_d((double)(-state.getX()), (double)(-state.getY()), (double)(-state.getZ()))};
            }
        }
        if (offset) {
            AABBUtils.offset(state.getX(), state.getY(), state.getZ(), aabbs);
        }
        return aabbs;
    }

    public static enum Axis {
        X,
        Y,
        Z;

    }
}

