/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.angelica.shadow.org.taumc.glsl;

import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.CharStreams;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.CommonToken;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.CommonTokenStream;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.ParserRuleContext;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.RuleContext;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.ParseTreeWalker;
import com.gtnewhorizons.angelica.shadow.org.antlr.v4.runtime.tree.TerminalNode;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.AppendFunction;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.ArrayExpressionRewriteListener;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.AssigmentChecker;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.BuiltinFunction;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.ConstAssignmentRemover;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.ConstParameterFinder;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.ExpressionRenamer;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.FastTreeWalker;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.FunctionCallWrapper;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.FunctionCollector;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.FunctionInjector;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.FunctionRemover;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.HasVariable;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.IdentifierCollector;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.Main;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.PrependFunction;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.QualifierFinder;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.RemoveVariable;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.Renamer;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.ReplaceExpression;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.StructArrayRewriter;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.TypeFinder;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.VariableInjector;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.grammar.GLSLLexer;
import com.gtnewhorizons.angelica.shadow.org.taumc.glsl.grammar.GLSLParser;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class Util {
    public static void injectVariable(GLSLParser.Translation_unitContext root, String ... code) {
        GLSLLexer lexer = new GLSLLexer(CharStreams.fromString(String.join((CharSequence)"\n", code)));
        GLSLParser parser = new GLSLParser(new CommonTokenStream(lexer));
        GLSLParser.External_declarationContext insert = parser.external_declaration();
        AtomicReference<GLSLParser.External_declarationContext> ref = new AtomicReference<GLSLParser.External_declarationContext>();
        ParseTreeWalker.DEFAULT.walk(new VariableInjector(ref), root);
        GLSLParser.External_declarationContext left = ref.get();
        if (left != null) {
            ParserRuleContext parent = left.getParent();
            int i = parent.children.indexOf(left);
            parent.children.add(i, insert);
            insert.setParent(parent);
        }
    }

    public static void injectFunction(GLSLParser.Translation_unitContext root, String ... code) {
        GLSLLexer lexer = new GLSLLexer(CharStreams.fromString(String.join((CharSequence)"\n", code)));
        GLSLParser parser = new GLSLParser(new CommonTokenStream(lexer));
        GLSLParser.External_declarationContext insert = parser.external_declaration();
        AtomicReference<GLSLParser.External_declarationContext> ref = new AtomicReference<GLSLParser.External_declarationContext>();
        ParseTreeWalker.DEFAULT.walk(new FunctionInjector(ref), root);
        GLSLParser.External_declarationContext left = ref.get();
        if (left != null) {
            ParserRuleContext parent = left.getParent();
            int i = parent.children.indexOf(left);
            parent.children.add(i, insert);
            insert.setParent(parent);
        }
    }

    public static void rename(GLSLParser.Translation_unitContext root, String oldName, String newName) {
        Util.rename(root, Collections.singletonMap(oldName, newName));
    }

    public static void rename(GLSLParser.Translation_unitContext root, Map<String, String> names) {
        ParseTreeWalker.DEFAULT.walk(new Renamer(names), root);
    }

    public static void replaceExpression(GLSLParser.Translation_unitContext root, String oldCode, String newCode) {
        ParseTreeWalker.DEFAULT.walk(new ReplaceExpression(oldCode, newCode), root);
    }

    public static void prependMain(GLSLParser.Translation_unitContext root, String code) {
        ParseTreeWalker.DEFAULT.walk(new PrependFunction("main", code), root);
    }

    public static void removeVariable(GLSLParser.Translation_unitContext root, String code) {
        AtomicReference<ParserRuleContext> top = new AtomicReference<ParserRuleContext>();
        ParseTreeWalker.DEFAULT.walk(new RemoveVariable(code, top), root);
        if (top.get() != null) {
            RuleContext ruleContext = top.get().getParent();
            if (ruleContext instanceof GLSLParser.Init_declarator_listContext) {
                GLSLParser.Init_declarator_listContext listContext = (GLSLParser.Init_declarator_listContext)ruleContext;
                int i = listContext.children.indexOf(top.get());
                listContext.children.remove(i - 1);
                listContext.children.remove(i - 1);
            } else {
                ruleContext = top.get().parent;
                if (ruleContext instanceof GLSLParser.Single_declarationContext) {
                    GLSLParser.Single_declarationContext singleContext = (GLSLParser.Single_declarationContext)ruleContext;
                    singleContext.getParent().getParent().getParent().getParent().children.remove(singleContext.getParent().getParent().getParent());
                }
            }
        }
    }

    public static int findType(GLSLParser.Translation_unitContext root, String code) {
        AtomicInteger type = new AtomicInteger();
        FastTreeWalker.walk(new TypeFinder(code, type), root);
        return type.get();
    }

    public static void appendMain(GLSLParser.Translation_unitContext root, String code) {
        ParseTreeWalker.DEFAULT.walk(new AppendFunction("main", code), root);
    }

    public static boolean containsCall(GLSLParser.Translation_unitContext root, String name) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        FastTreeWalker.walk(new IdentifierCollector(id -> {
            if (id.equals(name)) {
                atomicBoolean.set(true);
                return false;
            }
            return true;
        }), root);
        return atomicBoolean.get();
    }

    public static boolean hasVariable(GLSLParser.Translation_unitContext root, String name) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        ParseTreeWalker.DEFAULT.walk(new HasVariable(name, atomicBoolean), root);
        return atomicBoolean.get();
    }

    public static void renameArray(GLSLParser.Translation_unitContext root, String oldName, String newName, Set<Integer> found) {
        ParseTreeWalker.DEFAULT.walk(new ArrayExpressionRewriteListener(Collections.singletonMap(oldName, newName), found), root);
    }

    public static void renameFunctionCall(GLSLParser.Translation_unitContext root, String oldName, String newName) {
        ParseTreeWalker.DEFAULT.walk(new ExpressionRenamer(Collections.singletonMap(oldName, newName)), root);
    }

    public static void renameAndWrapShadow(GLSLParser.Translation_unitContext root, String oldName, String newName) {
        ParseTreeWalker.DEFAULT.walk(new FunctionCallWrapper(oldName, "vec4"), root);
        Util.renameFunctionCall(root, oldName, newName);
    }

    public static List<String> collectFunctions(GLSLParser.Translation_unitContext root) {
        ArrayList<String> result = new ArrayList<String>();
        ParseTreeWalker.DEFAULT.walk(new FunctionCollector(result), root);
        return result;
    }

    public static void removeFunction(GLSLParser.Translation_unitContext root, String name) {
        AtomicReference<GLSLParser.External_declarationContext> context = new AtomicReference<GLSLParser.External_declarationContext>();
        FastTreeWalker.walk(new FunctionRemover(name, context), root);
        if (context.get() != null) {
            context.get().getParent().children.remove(context.get());
        }
    }

    public static void removeUnusedFunctions(GLSLParser.Translation_unitContext root) {
        List<String> result = Util.collectFunctions(root);
        HashSet usedIdentifiers = new HashSet();
        FastTreeWalker.walk(new IdentifierCollector(id -> {
            usedIdentifiers.add(id);
            return true;
        }), root);
        List functionsToRemove = result.stream().filter(name -> !usedIdentifiers.contains(name) && !name.equals("main")).collect(Collectors.toList());
        for (String name2 : functionsToRemove) {
            Util.removeFunction(root, name2);
        }
    }

    public static Map<String, List<String>> findConstParameter(GLSLParser.Translation_unitContext root) {
        HashMap<String, List<String>> functions = new HashMap<String, List<String>>();
        ParseTreeWalker.DEFAULT.walk(new ConstParameterFinder(functions), root);
        return functions;
    }

    public static void removeConstAssignment(GLSLParser.Translation_unitContext root, Map<String, List<String>> functions) {
        for (Map.Entry<String, List<String>> entry : functions.entrySet()) {
            ParseTreeWalker.DEFAULT.walk(new ConstAssignmentRemover(entry.getKey(), entry.getValue()), root);
        }
    }

    public static void removeConstAssignment(GLSLParser.Translation_unitContext root) {
        Map<String, List<String>> functions = Util.findConstParameter(root);
        Util.removeConstAssignment(root, functions);
    }

    public static void initialize(GLSLParser.Translation_unitContext root, GLSLParser.Single_declarationContext declarationContext, String name) {
        TerminalNode node;
        Object object = declarationContext.fully_specified_type().type_specifier().type_specifier_nonarray().getChild(0);
        if (object instanceof TerminalNode && (object = (node = (TerminalNode)object).getSymbol()) instanceof CommonToken) {
            CommonToken token = (CommonToken)object;
            String insert = token.getText() + " " + name + " = " + BuiltinFunction.getByType(token.getType()).getInitializer() + ";";
            Util.prependMain(root, insert);
        }
    }

    public static void makeOutDeclaration(GLSLParser.Translation_unitContext root, GLSLParser.Single_declarationContext inDeclarationContext, String name) {
        String insert = Main.getFormattedShader(inDeclarationContext.fully_specified_type()) + name + ";";
        insert = insert.replaceFirst("in", "out");
        Util.injectVariable(root, insert);
    }

    public static Map<String, GLSLParser.Single_declarationContext> findQualifiers(GLSLParser.Translation_unitContext root, int type) {
        HashMap<String, GLSLParser.Single_declarationContext> result = new HashMap<String, GLSLParser.Single_declarationContext>();
        ParseTreeWalker.DEFAULT.walk(new QualifierFinder(type, result), root);
        return result;
    }

    public static boolean hasAssigment(GLSLParser.Translation_unitContext root, String name) {
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        ParseTreeWalker.DEFAULT.walk(new AssigmentChecker(name, atomicBoolean), root);
        return atomicBoolean.get();
    }

    public static void rewriteStructArrays(GLSLParser.Translation_unitContext root) {
        ParseTreeWalker.DEFAULT.walk(new StructArrayRewriter(), root);
    }
}

