/*
 * Decompiled with CFR 0.152.
 */
package com.sinthoras.visualprospecting.database;

import com.sinthoras.visualprospecting.Utils;
import com.sinthoras.visualprospecting.database.OreVeinPosition;
import com.sinthoras.visualprospecting.database.UndergroundFluidPosition;
import com.sinthoras.visualprospecting.database.WorldCache;
import com.sinthoras.visualprospecting.database.veintypes.VeinType;
import com.sinthoras.visualprospecting.database.veintypes.VeinTypeCaching;
import gregtech.common.UndergroundOil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.world.World;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class ServerCache
extends WorldCache {
    public static final ServerCache instance = new ServerCache();

    @Override
    protected File getStorageDirectory() {
        return Utils.getSubDirectory("visualprospecting/server/");
    }

    public synchronized void notifyOreVeinGeneration(int dimensionId, int chunkX, int chunkZ, VeinType veinType) {
        if (veinType != VeinType.NO_VEIN) {
            super.putOreVein(new OreVeinPosition(dimensionId, chunkX, chunkZ, veinType));
        }
    }

    public void notifyOreVeinGeneration(int dimensionId, int chunkX, int chunkZ, String veinName) {
        this.notifyOreVeinGeneration(dimensionId, chunkX, chunkZ, VeinTypeCaching.getVeinType(veinName));
    }

    public List<OreVeinPosition> prospectOreChunks(int dimensionId, int minChunkX, int minChunkZ, int maxChunkX, int maxChunkZ) {
        minChunkX = Utils.mapToCenterOreChunkCoord(minChunkX);
        minChunkZ = Utils.mapToCenterOreChunkCoord(minChunkZ);
        maxChunkX = Utils.mapToCenterOreChunkCoord(maxChunkX);
        maxChunkZ = Utils.mapToCenterOreChunkCoord(maxChunkZ);
        ArrayList<OreVeinPosition> oreVeinPositions = new ArrayList<OreVeinPosition>();
        int chunkX = minChunkX;
        while (chunkX <= maxChunkX) {
            int chunkZ = minChunkZ;
            while (chunkZ <= maxChunkZ) {
                OreVeinPosition oreVeinPosition = this.getOreVein(dimensionId, chunkX, chunkZ);
                if (oreVeinPosition.veinType != VeinType.NO_VEIN) {
                    oreVeinPositions.add(oreVeinPosition);
                }
                chunkZ = Utils.mapToCenterOreChunkCoord(chunkZ + 3);
            }
            chunkX = Utils.mapToCenterOreChunkCoord(chunkX + 3);
        }
        return oreVeinPositions;
    }

    public List<OreVeinPosition> prospectOreBlocks(int dimensionId, int minBlockX, int minBlockZ, int maxBlockX, int maxBlockZ) {
        return this.prospectOreChunks(dimensionId, Utils.coordBlockToChunk(minBlockX), Utils.coordBlockToChunk(minBlockZ), Utils.coordBlockToChunk(maxBlockX), Utils.coordBlockToChunk(maxBlockZ));
    }

    public List<OreVeinPosition> prospectOreBlockRadius(int dimensionId, int blockX, int blockZ, int blockRadius) {
        return this.prospectOreBlocks(dimensionId, blockX - blockRadius, blockZ - blockRadius, blockX + blockRadius, blockZ + blockRadius);
    }

    public List<UndergroundFluidPosition> prospectUndergroundFluidBlockRadius(World world, int blockX, int blockZ, int undergroundFluidBlockRadius) {
        int minChunkX = Utils.mapToCornerUndergroundFluidChunkCoord(Utils.coordBlockToChunk(blockX - undergroundFluidBlockRadius));
        int minChunkZ = Utils.mapToCornerUndergroundFluidChunkCoord(Utils.coordBlockToChunk(blockZ - undergroundFluidBlockRadius));
        int undergroundFluidRadius = (undergroundFluidBlockRadius + 128 - 1) / 128;
        ArrayList<UndergroundFluidPosition> foundUndergroundFluids = new ArrayList<UndergroundFluidPosition>((2 * undergroundFluidRadius + 1) * (2 * undergroundFluidRadius + 1));
        for (int undergroundFluidX = 0; undergroundFluidX < 2 * undergroundFluidRadius + 1; ++undergroundFluidX) {
            for (int undergroundFluidZ = 0; undergroundFluidZ < 2 * undergroundFluidRadius + 1; ++undergroundFluidZ) {
                int chunkX = minChunkX + undergroundFluidX * 8;
                int chunkZ = minChunkZ + undergroundFluidZ * 8;
                int[][] chunks = new int[8][8];
                Fluid fluid = null;
                for (int offsetChunkX = 0; offsetChunkX < 8; ++offsetChunkX) {
                    for (int offsetChunkZ = 0; offsetChunkZ < 8; ++offsetChunkZ) {
                        FluidStack prospectedFluid = UndergroundOil.undergroundOil((World)world, (int)(chunkX + offsetChunkX), (int)(chunkZ + offsetChunkZ), (float)-1.0f);
                        if (prospectedFluid == null) continue;
                        fluid = prospectedFluid.getFluid();
                        chunks[offsetChunkX][offsetChunkZ] = prospectedFluid.amount;
                    }
                }
                if (fluid == null) continue;
                foundUndergroundFluids.add(new UndergroundFluidPosition(world.field_73011_w.field_76574_g, chunkX, chunkZ, fluid, chunks));
            }
        }
        return foundUndergroundFluids;
    }
}

