/*
 * Decompiled with CFR 0.152.
 */
package com.jamesswafford.chess4j.board;

import com.jamesswafford.chess4j.Color;
import com.jamesswafford.chess4j.board.Bitboard;
import com.jamesswafford.chess4j.board.Board;
import com.jamesswafford.chess4j.board.Magic;
import com.jamesswafford.chess4j.board.squares.File;
import com.jamesswafford.chess4j.board.squares.Square;

public final class AttackDetector {
    private AttackDetector() {
    }

    public static boolean attacked(Board board, Square sq, Color player) {
        if (AttackDetector.attackedByPawn(board, sq, player)) {
            return true;
        }
        if (AttackDetector.attackedByRook(board, sq, player)) {
            return true;
        }
        if (AttackDetector.attackedByKnight(board, sq, player)) {
            return true;
        }
        if (AttackDetector.attackedByBishop(board, sq, player)) {
            return true;
        }
        if (AttackDetector.attackedByQueen(board, sq, player)) {
            return true;
        }
        return AttackDetector.attackedByKing(board, sq, player);
    }

    public static boolean attackedByBishop(Board board, Square sq, Color player) {
        return Magic.getBishopMoves(board, sq.value(), player == Color.WHITE ? board.getWhiteBishops() : board.getBlackBishops()) != 0L;
    }

    public static boolean attackedByKing(Board board, Square sq, Color player) {
        return (Bitboard.kingMoves[sq.value()] & Bitboard.squares[board.getKingSquare(player).value()]) != 0L;
    }

    public static boolean attackedByKnight(Board board, Square sq, Color player) {
        return (Bitboard.knightMoves[sq.value()] & (player == Color.WHITE ? board.getWhiteKnights() : board.getBlackKnights())) != 0L;
    }

    public static boolean attackedByPawn(Board board, Square sq, Color player) {
        if (player == Color.WHITE) {
            if (((board.getWhitePawns() & (Bitboard.files[File.FILE_A.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) >> 9 & Bitboard.squares[sq.value()]) != 0L) {
                return true;
            }
            return ((board.getWhitePawns() & (Bitboard.files[File.FILE_H.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) >> 7 & Bitboard.squares[sq.value()]) != 0L;
        }
        if (((board.getBlackPawns() & (Bitboard.files[File.FILE_A.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) << 7 & Bitboard.squares[sq.value()]) != 0L) {
            return true;
        }
        return ((board.getBlackPawns() & (Bitboard.files[File.FILE_H.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) << 9 & Bitboard.squares[sq.value()]) != 0L;
    }

    public static boolean attackedByQueen(Board board, Square sq, Color player) {
        return Magic.getQueenMoves(board, sq.value(), player == Color.WHITE ? board.getWhiteQueens() : board.getBlackQueens()) != 0L;
    }

    public static boolean attackedByRook(Board board, Square sq, Color player) {
        return Magic.getRookMoves(board, sq.value(), player == Color.WHITE ? board.getWhiteRooks() : board.getBlackRooks()) != 0L;
    }

    public static long getAttackers(Board board, Square sq, Color color) {
        int sqVal = sq.value();
        long attackers = Bitboard.knightMoves[sqVal] & (color == Color.WHITE ? board.getWhiteKnights() : board.getBlackKnights());
        attackers |= Bitboard.kingMoves[sqVal] & Bitboard.squares[board.getKingSquare(color).value()];
        attackers |= Magic.getRookMoves(board, sqVal, color == Color.WHITE ? board.getWhiteRooks() : board.getBlackRooks());
        attackers |= Magic.getBishopMoves(board, sqVal, color == Color.WHITE ? board.getWhiteBishops() : board.getBlackBishops());
        attackers |= Magic.getQueenMoves(board, sqVal, color == Color.WHITE ? board.getWhiteQueens() : board.getBlackQueens());
        if (color == Color.WHITE) {
            attackers |= (Bitboard.squares[sqVal] & (Bitboard.files[File.FILE_A.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) << 7 & board.getWhitePawns();
            attackers |= (Bitboard.squares[sqVal] & (Bitboard.files[File.FILE_H.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) << 9 & board.getWhitePawns();
        } else {
            attackers |= (Bitboard.squares[sqVal] & (Bitboard.files[File.FILE_A.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) >> 9 & board.getBlackPawns();
            attackers |= (Bitboard.squares[sqVal] & (Bitboard.files[File.FILE_H.getValue()] ^ 0xFFFFFFFFFFFFFFFFL)) >> 7 & board.getBlackPawns();
        }
        return attackers;
    }
}

