/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.compat.cthandlers;

import ganymedes01.etfuturum.api.BrewingFuelRegistry;
import ganymedes01.etfuturum.compat.CompatCraftTweaker;
import ganymedes01.etfuturum.core.utils.ItemStackMap;
import java.util.List;
import java.util.Map;
import minetweaker.IUndoableAction;
import minetweaker.MineTweakerAPI;
import minetweaker.api.item.IIngredient;
import minetweaker.api.item.IItemStack;
import minetweaker.mc1710.item.MCItemStack;
import net.minecraft.item.ItemStack;
import stanhebben.zenscript.annotations.ZenClass;
import stanhebben.zenscript.annotations.ZenMethod;

@ZenClass(value="mods.etfuturum.brewingFuel")
public class CTBrewingFuels {
    @ZenMethod
    public static void remove(IIngredient fuel) {
        Object internal = CompatCraftTweaker.getInternal(fuel);
        if (internal instanceof String && BrewingFuelRegistry.isFuel((String)internal) || internal instanceof ItemStack && BrewingFuelRegistry.isFuel((ItemStack)internal)) {
            ItemStackMap<Integer> toRemove = new ItemStackMap<Integer>();
            for (Map.Entry<ItemStack, Integer> fuelEntry : BrewingFuelRegistry.getFuels().entrySet()) {
                if (!fuel.matches((IItemStack)new MCItemStack(fuelEntry.getKey()))) continue;
                toRemove.put(fuelEntry.getKey(), fuelEntry.getValue());
            }
            MineTweakerAPI.apply((IUndoableAction)new RemoveAction(toRemove));
        } else {
            MineTweakerAPI.logWarning((String)("No brewing fuels for " + fuel));
        }
    }

    @ZenMethod
    public static void addFuel(IIngredient fuel, int count) {
        List items = fuel.getItems();
        if (items == null) {
            MineTweakerAPI.logError((String)("Cannot turn " + fuel + " into a brewing fuel"));
            return;
        }
        ItemStack[] toAdd = CompatCraftTweaker.getItemStacks(items);
        MineTweakerAPI.apply((IUndoableAction)new AddAction(fuel, toAdd, count));
    }

    private static class RemoveAction
    implements IUndoableAction {
        private final ItemStackMap<Integer> items;

        public RemoveAction(ItemStackMap<Integer> items) {
            this.items = items;
        }

        public void apply() {
            for (ItemStack item : this.items.keySet()) {
                BrewingFuelRegistry.remove(item);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (Map.Entry<ItemStack, Integer> entry : this.items.entrySet()) {
                BrewingFuelRegistry.registerFuel(entry.getKey(), (int)entry.getValue());
            }
        }

        public String describe() {
            return "Removing " + this.items.size() + " brewing fuels";
        }

        public String describeUndo() {
            return "Restoring " + this.items.size() + " brewing fuels";
        }

        public Object getOverrideKey() {
            return null;
        }
    }

    private static class AddAction
    implements IUndoableAction {
        private final IIngredient ingredient;
        private final ItemStack[] fuels;
        private final int count;

        public AddAction(IIngredient ingredient, ItemStack[] fuels, int count) {
            this.ingredient = ingredient;
            this.fuels = fuels;
            this.count = count;
        }

        public void apply() {
            for (ItemStack inputStack : this.fuels) {
                BrewingFuelRegistry.registerFuel(inputStack, this.count);
            }
        }

        public boolean canUndo() {
            return true;
        }

        public void undo() {
            for (ItemStack inputStack : this.fuels) {
                BrewingFuelRegistry.remove(inputStack);
            }
        }

        public String describe() {
            return "Adding brewing fuel for " + this.ingredient;
        }

        public String describeUndo() {
            return "Removing brewing fuel for " + this.ingredient;
        }

        public Object getOverrideKey() {
            return null;
        }
    }
}

