/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.etfuturum.client.renderer.block;

import com.gtnewhorizons.angelica.api.ThreadSafeISBRH;
import ganymedes01.etfuturum.blocks.IEmissiveLayerBlock;
import ganymedes01.etfuturum.client.renderer.block.BlockModelBase;
import javax.vecmath.Point2f;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.EntityRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.IBlockAccess;
import org.lwjgl.opengl.GL11;

@ThreadSafeISBRH(perThread=false)
public class BlockEmissiveLayerRenderer
extends BlockModelBase {
    private static final Point2f lastBrightness = new Point2f(0.0f, 0.0f);

    public BlockEmissiveLayerRenderer(int modelID) {
        super(modelID);
    }

    @Override
    protected void renderInventoryModel(Block block, int meta, int modelId, RenderBlocks renderer, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        if (!(block instanceof IEmissiveLayerBlock)) {
            throw new IllegalArgumentException("Block using emissive layer renderer must implement IEmissiveLayerBlock!");
        }
        if (((IEmissiveLayerBlock)block).isMetaNormalBlock(meta)) {
            super.renderInventoryModel(block, meta, modelId, renderer, minX, minY, minZ, maxX, maxY, maxZ);
            return;
        }
        boolean emissiveLayerAbove = ((IEmissiveLayerBlock)block).isSecondLayerAbove(meta);
        this.renderStandardInventoryCubeEmissive(block, meta, modelId, renderer, !emissiveLayerAbove, minX, minY, minZ, maxX, maxY, maxZ);
        this.renderStandardInventoryCubeEmissive(block, meta, modelId, renderer, emissiveLayerAbove, minX, minY, minZ, maxX, maxY, maxZ);
    }

    protected void renderStandardInventoryCubeEmissive(Block block, int meta, int modelId, RenderBlocks renderer, boolean emissive, double minX, double minY, double minZ, double maxX, double maxY, double maxZ) {
        Tessellator tessellator = Tessellator.field_78398_a;
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        if (emissive) {
            int m = ((IEmissiveLayerBlock)block).getEmissiveLayerColor(meta);
            float f = (float)(m >> 16 & 0xFF) / 255.0f;
            float f1 = (float)(m >> 8 & 0xFF) / 255.0f;
            float f2 = (float)(m & 0xFF) / 255.0f;
            tessellator.func_78386_a(f, f1, f2);
            GL11.glEnable((int)3008);
            if (((IEmissiveLayerBlock)block).itemBlockGlows(meta)) {
                int brightness = ((IEmissiveLayerBlock)block).getEmissiveMinBrightness(meta);
                BlockEmissiveLayerRenderer.setLighting(this.floorMixedBrightness(brightness, brightness));
            }
        }
        renderer.func_147782_a(minX, minY, minZ, maxX, maxY, maxZ);
        tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
        renderer.func_147768_a(block, 0.0, 0.0, 0.0, this.getIconOrEmissiveLayerIcon(block, renderer, 0, meta, emissive));
        tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
        renderer.func_147806_b(block, 0.0, 0.0, 0.0, this.getIconOrEmissiveLayerIcon(block, renderer, 1, meta, emissive));
        tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
        renderer.func_147761_c(block, 0.0, 0.0, 0.0, this.getIconOrEmissiveLayerIcon(block, renderer, 2, meta, emissive));
        tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
        renderer.func_147734_d(block, 0.0, 0.0, 0.0, this.getIconOrEmissiveLayerIcon(block, renderer, 3, meta, emissive));
        tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
        renderer.func_147798_e(block, 0.0, 0.0, 0.0, this.getIconOrEmissiveLayerIcon(block, renderer, 4, meta, emissive));
        tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
        renderer.func_147764_f(block, 0.0, 0.0, 0.0, this.getIconOrEmissiveLayerIcon(block, renderer, 5, meta, emissive));
        tessellator.func_78381_a();
        tessellator.func_78382_b();
        if (emissive) {
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            if (((IEmissiveLayerBlock)block).itemBlockGlows(meta)) {
                BlockEmissiveLayerRenderer.resetLighting();
            }
        }
    }

    @Override
    public boolean renderWorldBlock(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer) {
        if (((IEmissiveLayerBlock)block).isMetaNormalBlock(world.func_72805_g(x, y, z))) {
            return super.renderWorldBlock(world, x, y, z, block, modelId, renderer);
        }
        boolean emissiveLayerAbove = ((IEmissiveLayerBlock)block).isSecondLayerAbove(world.func_72805_g(x, y, z));
        return this.renderStandardWorldCubeWithEmissiveness(world, x, y, z, block, modelId, renderer, !emissiveLayerAbove, block.func_149704_x(), block.func_149665_z(), block.func_149706_B(), block.func_149753_y(), block.func_149669_A(), block.func_149693_C()) && this.renderStandardWorldCubeWithEmissiveness(world, x, y, z, block, modelId, renderer, emissiveLayerAbove, block.func_149704_x(), block.func_149665_z(), block.func_149706_B(), block.func_149753_y(), block.func_149669_A(), block.func_149693_C());
    }

    protected boolean renderStandardWorldCubeWithEmissiveness(IBlockAccess world, int x, int y, int z, Block block, int modelId, RenderBlocks renderer, boolean emissive, double minX, double minY, double minZ, double maxF, double maxY, double maxZ) {
        if (!(block instanceof IEmissiveLayerBlock)) {
            throw new IllegalArgumentException("Block using emissive layer renderer must implement IEmissiveLayerBlock!");
        }
        if (!emissive) {
            return super.renderStandardWorldCube(world, x, y, z, block, modelId, renderer, minX, minY, minZ, maxF, maxY, maxZ);
        }
        renderer.func_147782_a(minX, minY, minZ, maxF, maxY, maxZ);
        int meta = world.func_72805_g(x, y, z);
        this.renderFaceYNeg(renderer, block, (double)x, (double)y, (double)z, ((IEmissiveLayerBlock)block).getEmissiveMinBrightness(world, x, y, z), this.getIconOrEmissiveLayerIcon(block, renderer, 0, meta, true), meta);
        this.renderFaceYPos(renderer, block, (double)x, (double)y, (double)z, ((IEmissiveLayerBlock)block).getEmissiveMinBrightness(world, x, y, z), this.getIconOrEmissiveLayerIcon(block, renderer, 1, meta, true), meta);
        this.renderFaceZNeg(renderer, block, (double)x, (double)y, (double)z, ((IEmissiveLayerBlock)block).getEmissiveMinBrightness(world, x, y, z), this.getIconOrEmissiveLayerIcon(block, renderer, 2, meta, true), meta);
        this.renderFaceZPos(renderer, block, (double)x, (double)y, (double)z, ((IEmissiveLayerBlock)block).getEmissiveMinBrightness(world, x, y, z), this.getIconOrEmissiveLayerIcon(block, renderer, 3, meta, true), meta);
        this.renderFaceXNeg(renderer, block, (double)x, (double)y, (double)z, ((IEmissiveLayerBlock)block).getEmissiveMinBrightness(world, x, y, z), this.getIconOrEmissiveLayerIcon(block, renderer, 4, meta, true), meta);
        this.renderFaceXPos(renderer, block, (double)x, (double)y, (double)z, ((IEmissiveLayerBlock)block).getEmissiveMinBrightness(world, x, y, z), this.getIconOrEmissiveLayerIcon(block, renderer, 5, meta, true), meta);
        return true;
    }

    public static void setLighting(int lighting) {
        BlockEmissiveLayerRenderer.storeLighting();
        OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)((float)lighting % 65536.0f), (float)((float)lighting / 65536.0f));
    }

    public static void storeLighting() {
        lastBrightness.set(OpenGlHelper.lastBrightnessX, OpenGlHelper.lastBrightnessY);
    }

    public static void resetLighting() {
        Point2f p = lastBrightness;
        if (p != null) {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)p.x, (float)p.y);
        }
    }

    private void renderFaceYNeg(RenderBlocks renderer, Block block, double dx, double dy, double dz, int minBrightness, IIcon icon, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        int m = ((IEmissiveLayerBlock)block).getEmissiveLayerColor(meta);
        float f = (float)(m >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(m >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(m & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        float f6 = ((IEmissiveLayerBlock)block).doesEmissiveLayerHaveDirShading(meta) ? 0.5f : 1.0f;
        float f7 = f6 * f;
        float f8 = f6 * f1;
        float f9 = f6 * f2;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y - 1, z, 0)) {
            tessellator.func_78380_c(this.floorMixedBrightness(minBrightness, renderer.field_147855_j > 0.0 ? l : block.func_149677_c(renderer.field_147845_a, x, MathHelper.func_76128_c((double)(y - 1)), z)));
            tessellator.func_78386_a(f7, f8, f9);
            renderer.func_147768_a(block, dx, dy, dz, icon);
        }
    }

    private void renderFaceYPos(RenderBlocks renderer, Block block, double dx, double dy, double dz, int minBrightness, IIcon icon, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        int m = ((IEmissiveLayerBlock)block).getEmissiveLayerColor(meta);
        float f = (float)(m >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(m >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(m & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        float f4 = 1.0f;
        float f7 = f4 * f;
        float f8 = f4 * f1;
        float f9 = f4 * f2;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y + 1, z, 1)) {
            tessellator.func_78380_c(this.floorMixedBrightness(minBrightness, renderer.field_147857_k < 1.0 ? l : block.func_149677_c(renderer.field_147845_a, x, y + 1, z)));
            tessellator.func_78386_a(f7, f8, f9);
            renderer.func_147806_b(block, dx, dy, dz, icon);
        }
    }

    private void renderFaceZNeg(RenderBlocks renderer, Block block, double dx, double dy, double dz, int minBrightness, IIcon icon, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        int m = ((IEmissiveLayerBlock)block).getEmissiveLayerColor(meta);
        float f = (float)(m >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(m >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(m & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        float f6 = ((IEmissiveLayerBlock)block).doesEmissiveLayerHaveDirShading(meta) ? 0.8f : 1.0f;
        float f7 = f6 * f;
        float f8 = f6 * f1;
        float f9 = f6 * f2;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y, z - 1, 2)) {
            tessellator.func_78380_c(this.floorMixedBrightness(minBrightness, renderer.field_147851_l > 0.0 ? l : block.func_149677_c(renderer.field_147845_a, x, y, z - 1)));
            tessellator.func_78386_a(f7, f8, f9);
            renderer.func_147761_c(block, dx, dy, dz, icon);
        }
    }

    private void renderFaceZPos(RenderBlocks renderer, Block block, double dx, double dy, double dz, int minBrightness, IIcon icon, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        int m = ((IEmissiveLayerBlock)block).getEmissiveLayerColor(meta);
        float f = (float)(m >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(m >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(m & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        float f6 = ((IEmissiveLayerBlock)block).doesEmissiveLayerHaveDirShading(meta) ? 0.8f : 1.0f;
        float f7 = f6 * f;
        float f8 = f6 * f1;
        float f9 = f6 * f2;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x, y, z + 1, 3)) {
            tessellator.func_78380_c(this.floorMixedBrightness(minBrightness, renderer.field_147853_m < 1.0 ? l : block.func_149677_c(renderer.field_147845_a, x, y, z + 1)));
            tessellator.func_78386_a(f7, f8, f9);
            renderer.func_147734_d(block, dx, dy, dz, icon);
        }
    }

    private void renderFaceXNeg(RenderBlocks renderer, Block block, double dx, double dy, double dz, int minBrightness, IIcon icon, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        int m = ((IEmissiveLayerBlock)block).getEmissiveLayerColor(meta);
        float f = (float)(m >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(m >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(m & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        float f6 = ((IEmissiveLayerBlock)block).doesEmissiveLayerHaveDirShading(meta) ? 0.6f : 1.0f;
        float f7 = f6 * f;
        float f8 = f6 * f1;
        float f9 = f6 * f2;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x - 1, y, z, 4)) {
            tessellator.func_78380_c(this.floorMixedBrightness(minBrightness, renderer.field_147859_h > 0.0 ? l : block.func_149677_c(renderer.field_147845_a, x - 1, y, z)));
            tessellator.func_78386_a(f7, f8, f9);
            renderer.func_147798_e(block, dx, dy, dz, icon);
        }
    }

    private void renderFaceXPos(RenderBlocks renderer, Block block, double dx, double dy, double dz, int minBrightness, IIcon icon, int meta) {
        Tessellator tessellator = Tessellator.field_78398_a;
        renderer.field_147863_w = false;
        int x = MathHelper.func_76128_c((double)dx);
        int y = MathHelper.func_76128_c((double)dy);
        int z = MathHelper.func_76128_c((double)dz);
        int m = ((IEmissiveLayerBlock)block).getEmissiveLayerColor(meta);
        float f = (float)(m >> 16 & 0xFF) / 255.0f;
        float f1 = (float)(m >> 8 & 0xFF) / 255.0f;
        float f2 = (float)(m & 0xFF) / 255.0f;
        if (EntityRenderer.field_78517_a) {
            float f3 = (f * 30.0f + f1 * 59.0f + f2 * 11.0f) / 100.0f;
            float f4 = (f * 30.0f + f1 * 70.0f) / 100.0f;
            float f5 = (f * 30.0f + f2 * 70.0f) / 100.0f;
            f = f3;
            f1 = f4;
            f2 = f5;
        }
        float f6 = ((IEmissiveLayerBlock)block).doesEmissiveLayerHaveDirShading(meta) ? 0.6f : 1.0f;
        float f7 = f6 * f;
        float f8 = f6 * f1;
        float f9 = f6 * f2;
        int l = block.func_149677_c(renderer.field_147845_a, x, y, z);
        if (renderer.field_147837_f || block.func_149646_a(renderer.field_147845_a, x + 1, y, z, 5)) {
            tessellator.func_78380_c(this.floorMixedBrightness(minBrightness, renderer.field_147861_i < 1.0 ? l : block.func_149677_c(renderer.field_147845_a, x + 1, y, z)));
            tessellator.func_78386_a(f7, f8, f9);
            renderer.func_147764_f(block, dx, dy, dz, icon);
        }
    }

    private int floorMixedBrightness(int minBrightness, int brightness) {
        int sky = MathHelper.func_76125_a((int)(brightness >>> 16 & 0xFF), (int)(minBrightness * 16), (int)240);
        int block = MathHelper.func_76125_a((int)(brightness & 0xFF), (int)(minBrightness * 16), (int)240);
        return (sky & 0xFF) << 16 | block & 0xFF;
    }

    private IIcon getIconOrEmissiveLayerIcon(Block block, RenderBlocks renderer, int side, int meta, boolean emissive) {
        return emissive ? ((IEmissiveLayerBlock)block).getSecondLayerIcon(side, meta) : renderer.func_147787_a(block, side, meta);
    }
}

