/*
 * Decompiled with CFR 0.152.
 */
package com.n247s.N2ConfigApi.api.core.parser;

import com.n247s.N2ConfigApi.api.core.ConfigFile;
import com.n247s.N2ConfigApi.api.core.ConfigSection;
import com.n247s.N2ConfigApi.api.core.ConfigSectionCollection;
import com.n247s.N2ConfigApi.api.core.DefaultConfigFile;
import com.n247s.N2ConfigApi.api.core.InitConfigObjectManager;
import net.minecraftforge.common.config.ConfigCategory;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;

public class ConfigParser {
    public static ConfigFile parseConfigFile(Configuration configuration, String newFileName) {
        DefaultConfigFile configFile = new DefaultConfigFile(newFileName, newFileName);
        InitConfigObjectManager.Config config = InitConfigObjectManager.addConfigFile(newFileName);
        for (String currentCategoryName : configuration.getCategoryNames()) {
            ConfigSectionCollection configSectionCollection = ConfigParser.parseConfigCategory(configuration.getCategory(currentCategoryName), config, true, false);
            configFile.addNewSection(configSectionCollection);
        }
        return configFile;
    }

    public static ConfigFile parseConfigFile(Configuration configuration, ConfigFile configFile) {
        InitConfigObjectManager.Config config = InitConfigObjectManager.addConfigFile(configFile.getFileName());
        for (String currentCategoryName : configuration.getCategoryNames()) {
            ConfigSectionCollection configSectionCollection = ConfigParser.parseConfigCategory(configuration.getCategory(currentCategoryName), config, true, false);
            configFile.addNewSection(configSectionCollection);
        }
        return configFile;
    }

    private static ConfigSectionCollection parseConfigCategory(ConfigCategory configCategory, InitConfigObjectManager.Config config, boolean setExtraSpace, boolean useDefaultValueForConfigValue) {
        ConfigSectionCollection sectionCollection = new ConfigSectionCollection(configCategory.getName(), ConfigParser.parseComment(configCategory.getComment()), setExtraSpace);
        for (Property currentProperty : configCategory.getOrderedValues()) {
            switch (currentProperty.getType()) {
                case BOOLEAN: {
                    ConfigSection tempSection = ConfigParser.parseBooleanProperty(currentProperty, useDefaultValueForConfigValue);
                    if (tempSection == null) break;
                    sectionCollection.addNewSection(tempSection);
                    if (useDefaultValueForConfigValue || config == null) break;
                    InitConfigObjectManager.addField(config, currentProperty.getName(), currentProperty.isList() ? currentProperty.getBooleanList() : (boolean[])currentProperty.getBoolean());
                    break;
                }
                case INTEGER: {
                    ConfigSection tempSection = ConfigParser.parseIntegerProperty(currentProperty, useDefaultValueForConfigValue);
                    if (tempSection == null) break;
                    sectionCollection.addNewSection(tempSection);
                    if (useDefaultValueForConfigValue || config == null) break;
                    InitConfigObjectManager.addField(config, currentProperty.getName(), currentProperty.isList() ? currentProperty.getIntList() : (int[])currentProperty.getInt());
                    break;
                }
                case DOUBLE: {
                    ConfigSection tempSection = ConfigParser.parseDoubleProperty(currentProperty, useDefaultValueForConfigValue);
                    if (tempSection == null) break;
                    sectionCollection.addNewSection(tempSection);
                    if (useDefaultValueForConfigValue || config == null) break;
                    InitConfigObjectManager.addField(config, currentProperty.getName(), currentProperty.isList() ? currentProperty.getDoubleList() : (double[])currentProperty.getDouble());
                    break;
                }
                case STRING: {
                    ConfigSection tempSection = ConfigParser.parseStringProperty(currentProperty, useDefaultValueForConfigValue);
                    if (tempSection == null) break;
                    sectionCollection.addNewSection(tempSection);
                    if (useDefaultValueForConfigValue || config == null) break;
                    InitConfigObjectManager.addField(config, currentProperty.getName(), currentProperty.isList() ? currentProperty.getStringList() : currentProperty.getString());
                    break;
                }
            }
        }
        for (ConfigCategory currentCategory : configCategory.getChildren()) {
            ConfigSectionCollection childConfigSectionCollection = ConfigParser.parseConfigCategory(currentCategory, useDefaultValueForConfigValue);
            sectionCollection.addNewSection(childConfigSectionCollection);
        }
        return sectionCollection;
    }

    public static ConfigSectionCollection parseConfigCategory(ConfigCategory configCategory, boolean setExtraSpace, boolean useDefaultValueForConfigValue) {
        return ConfigParser.parseConfigCategory(configCategory, null, setExtraSpace, useDefaultValueForConfigValue);
    }

    public static ConfigSectionCollection parseConfigCategory(ConfigCategory configCategory, boolean useDefaultValueForConfigValue) {
        return ConfigParser.parseConfigCategory(configCategory, null, true, useDefaultValueForConfigValue);
    }

    public static ConfigSection parseBooleanProperty(Property booleanProperty, boolean useDefaultValueForConfigValue) {
        ConfigSection configSection;
        if (!booleanProperty.getType().equals((Object)Property.Type.BOOLEAN)) {
            return null;
        }
        if (booleanProperty.isList()) {
            String[] defaultStringArray = booleanProperty.getDefaults();
            boolean[] defaultBooleanArray = new boolean[defaultStringArray.length];
            for (int i = 0; i < defaultBooleanArray.length; ++i) {
                defaultBooleanArray[i] = Boolean.parseBoolean(defaultStringArray[i]);
            }
            configSection = new ConfigSection(booleanProperty.getName(), ConfigParser.parseComment(booleanProperty.comment), useDefaultValueForConfigValue ? booleanProperty.getBooleanList() : defaultBooleanArray, ConfigSection.SectionType.BooleanArray, true, false);
        } else {
            configSection = new ConfigSection(booleanProperty.getName(), ConfigParser.parseComment(booleanProperty.comment), useDefaultValueForConfigValue ? booleanProperty.getBoolean() : Boolean.parseBoolean(booleanProperty.getDefault()), ConfigSection.SectionType.Boolean, true, false);
        }
        return configSection;
    }

    public static ConfigSection parseIntegerProperty(Property integerProperty, boolean useDefaultValueForConfigValue) {
        ConfigSection configSection;
        if (!integerProperty.getType().equals((Object)Property.Type.INTEGER)) {
            return null;
        }
        if (integerProperty.isList()) {
            String[] defaultStringArray = integerProperty.getDefaults();
            int[] defaultIntArray = new int[defaultStringArray.length];
            for (int i = 0; i < defaultIntArray.length; ++i) {
                defaultIntArray[i] = Integer.parseInt(defaultStringArray[i]);
            }
            configSection = new ConfigSection(integerProperty.getName(), ConfigParser.parseComment(integerProperty.comment), useDefaultValueForConfigValue ? integerProperty.getIntList() : defaultIntArray, ConfigSection.SectionType.IntegerArray, true, false);
        } else {
            configSection = new ConfigSection(integerProperty.getName(), ConfigParser.parseComment(integerProperty.comment), useDefaultValueForConfigValue ? integerProperty.getInt() : Integer.parseInt(integerProperty.getDefault()), ConfigSection.SectionType.Integer, true, false);
        }
        return configSection;
    }

    public static ConfigSection parseDoubleProperty(Property doubleProperty, boolean useDefaultValueForConfigValue) {
        ConfigSection configSection;
        if (!doubleProperty.getType().equals((Object)Property.Type.DOUBLE)) {
            return null;
        }
        if (doubleProperty.isList()) {
            String[] defaultStringArray = doubleProperty.getDefaults();
            double[] defaultDoubleArray = new double[defaultStringArray.length];
            for (int i = 0; i < defaultDoubleArray.length; ++i) {
                defaultDoubleArray[i] = Double.parseDouble(defaultStringArray[i]);
            }
            configSection = new ConfigSection(doubleProperty.getName(), ConfigParser.parseComment(doubleProperty.comment), useDefaultValueForConfigValue ? doubleProperty.getDoubleList() : defaultDoubleArray, ConfigSection.SectionType.DoubleArray, true, false);
        } else {
            configSection = new ConfigSection(doubleProperty.getName(), ConfigParser.parseComment(doubleProperty.comment), useDefaultValueForConfigValue ? doubleProperty.getDouble() : Double.parseDouble(doubleProperty.getDefault()), ConfigSection.SectionType.Double, true, false);
        }
        return configSection;
    }

    public static ConfigSection parseStringProperty(Property stringProperty, boolean useDefaultValueForConfigValue) {
        if (!stringProperty.getType().equals((Object)Property.Type.STRING)) {
            return null;
        }
        ConfigSection configSection = stringProperty.isList() ? new ConfigSection(stringProperty.getName(), ConfigParser.parseComment(stringProperty.comment), useDefaultValueForConfigValue ? stringProperty.getStringList() : stringProperty.getDefaults(), ConfigSection.SectionType.StringArray, true, false) : new ConfigSection(stringProperty.getName(), ConfigParser.parseComment(stringProperty.comment), useDefaultValueForConfigValue ? stringProperty.getString() : stringProperty.getDefault(), ConfigSection.SectionType.String, true, false);
        return configSection;
    }

    public static ConfigSection parseProperty(Property property, boolean useDefaultValueForConfigValue) {
        ConfigSection configSection = property.isList() ? new ConfigSection(property.getName(), ConfigParser.parseComment(property.comment), useDefaultValueForConfigValue ? property.getStringList() : property.getDefaults(), ConfigSection.SectionType.StringArray, true, false) : new ConfigSection(property.getName(), ConfigParser.parseComment(property.comment), useDefaultValueForConfigValue ? property.getString() : property.getDefault(), ConfigSection.SectionType.String, true, false);
        return configSection;
    }

    public static ConfigSection parseColourProperty() {
        return null;
    }

    public static ConfigSection parseModIDProperty() {
        return null;
    }

    private static String[] parseComment(String comment) {
        if (comment != null) {
            if (comment.contains("\n")) {
                return comment.split("\n");
            }
            return new String[]{comment};
        }
        return null;
    }
}

