/*
 * Decompiled with CFR 0.152.
 */
package tectech.thing.metaTileEntity.single;

import com.gtnewhorizons.modularui.api.NumberFormatMUI;
import com.gtnewhorizons.modularui.api.drawable.IDrawable;
import com.gtnewhorizons.modularui.api.screen.ModularWindow;
import com.gtnewhorizons.modularui.api.screen.UIBuildContext;
import com.gtnewhorizons.modularui.common.widget.ButtonWidget;
import com.gtnewhorizons.modularui.common.widget.DrawableWidget;
import com.gtnewhorizons.modularui.common.widget.TextWidget;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import gregtech.api.enums.Textures;
import gregtech.api.gui.modularui.GTUITextures;
import gregtech.api.interfaces.ITexture;
import gregtech.api.interfaces.modularui.IAddGregtechLogo;
import gregtech.api.interfaces.modularui.IAddUIWidgets;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.metatileentity.MetaTileEntity;
import gregtech.api.metatileentity.implementations.MTETieredMachineBlock;
import gregtech.api.render.TextureFactory;
import gregtech.common.pollution.Pollution;
import java.util.function.Consumer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.util.ForgeDirection;
import tectech.TecTech;
import tectech.util.CommonValues;

public class MTEDebugPollutor
extends MTETieredMachineBlock
implements IAddUIWidgets,
IAddGregtechLogo {
    private static ITexture POLLUTOR;
    public int pollution = 0;
    private static final NumberFormatMUI numberFormat;

    public MTEDebugPollutor(int aID, String aName, String aNameRegional, int aTier) {
        super(aID, aName, aNameRegional, aTier, 0, new String[]{CommonValues.TEC_MARK_GENERAL, StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.pollutor.desc.0"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.pollutor.desc.1"), EnumChatFormatting.BLUE + StatCollector.func_74838_a((String)"gt.blockmachines.debug.tt.pollutor.desc.2")}, new ITexture[0]);
    }

    public MTEDebugPollutor(String aName, int aTier, String[] aDescription, ITexture[][][] aTextures) {
        super(aName, aTier, 0, aDescription, aTextures);
    }

    @Override
    public MetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new MTEDebugPollutor(this.mName, this.mTier, this.mDescriptionArray, this.mTextures);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void registerIcons(IIconRegister aBlockIconRegister) {
        super.registerIcons(aBlockIconRegister);
        POLLUTOR = TextureFactory.of(new Textures.BlockIcons.CustomIcon("iconsets/POLLUTOR"));
    }

    @Override
    public ITexture[] getTexture(IGregTechTileEntity aBaseMetaTileEntity, ForgeDirection side, ForgeDirection facing, int colorIndex, boolean aActive, boolean aRedstone) {
        return new ITexture[]{Textures.BlockIcons.MACHINE_CASINGS[this.mTier][colorIndex + 1], side == facing ? POLLUTOR : Textures.BlockIcons.OVERLAYS_ENERGY_OUT_MULTI_LASER[this.mTier + 1]};
    }

    @Override
    public ITexture[][][] getTextureSet(ITexture[] aTextures) {
        return null;
    }

    @Override
    public boolean allowPutStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public boolean allowPullStack(IGregTechTileEntity iGregTechTileEntity, int i, ForgeDirection side, ItemStack itemStack) {
        return false;
    }

    @Override
    public void saveNBTData(NBTTagCompound aNBT) {
        aNBT.func_74768_a("ePollution", this.pollution);
    }

    @Override
    public void loadNBTData(NBTTagCompound aNBT) {
        this.pollution = aNBT.func_74762_e("ePollution");
    }

    @Override
    public void onPostTick(IGregTechTileEntity aBaseMetaTileEntity, long aTick) {
        if (aBaseMetaTileEntity.isServerSide()) {
            if (this.pollution > 0) {
                Pollution.addPollution(aBaseMetaTileEntity, this.pollution);
            }
        } else if (aBaseMetaTileEntity.isClientSide() && aBaseMetaTileEntity.isActive()) {
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                if (side == aBaseMetaTileEntity.getFrontFacing()) continue;
                TecTech.proxy.em_particle(aBaseMetaTileEntity, side);
                TecTech.proxy.pollutor_particle(aBaseMetaTileEntity, side);
            }
        }
    }

    @Override
    public boolean onRightclick(IGregTechTileEntity aBaseMetaTileEntity, EntityPlayer aPlayer) {
        this.openGui(aPlayer);
        return true;
    }

    @Override
    public boolean isFacingValid(ForgeDirection facing) {
        return true;
    }

    @Override
    public boolean isElectric() {
        return false;
    }

    @Override
    public void addGregTechLogo(ModularWindow.Builder builder) {
        builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_GT_LOGO_17x17_TRANSPARENT_GRAY).setSize(17, 17).setPos(113, 56));
    }

    @Override
    public void addUIWidgets(ModularWindow.Builder builder, UIBuildContext buildContext) {
        ((ModularWindow.Builder)builder.widget(new DrawableWidget().setDrawable((IDrawable)GTUITextures.PICTURE_SCREEN_BLACK).setSize(90, 72).setPos(43, 4))).widget(new TextWidget().setStringSupplier(() -> StatCollector.func_74838_a((String)"tt.gui.text.debug_pollutor.pollution") + ": " + numberFormat.format((long)this.pollution)).setDefaultColor(((Integer)this.COLOR_TEXT_WHITE.get()).intValue()).setPos(46, 8));
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.pollution -= val.intValue(), 512, 64, 7, 4);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_LARGE, val -> this.pollution /= val.intValue(), 512, 64, 7, 22);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.pollution -= val.intValue(), 16, 1, 25, 4);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_MINUS_SMALL, val -> this.pollution /= val.intValue(), 16, 2, 25, 22);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.pollution += val.intValue(), 16, 1, 133, 4);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_SMALL, val -> this.pollution *= val.intValue(), 16, 2, 133, 22);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.pollution += val.intValue(), 512, 64, 151, 4);
        this.addChangeNumberButton(builder, (IDrawable)GTUITextures.OVERLAY_BUTTON_PLUS_LARGE, val -> this.pollution *= val.intValue(), 512, 64, 151, 22);
    }

    private void addChangeNumberButton(ModularWindow.Builder builder, IDrawable overlay, Consumer<Integer> setter, int changeNumberShift, int changeNumber, int xPos, int yPos) {
        builder.widget(new ButtonWidget().setOnClick((clickData, widget) -> setter.accept(clickData.shift ? changeNumberShift : changeNumber)).setBackground(new IDrawable[]{GTUITextures.BUTTON_STANDARD, overlay}).setSize(18, 18).setPos(xPos, yPos));
    }

    static {
        numberFormat = new NumberFormatMUI();
    }
}

