/*
 * Decompiled with CFR 0.152.
 */
package gtnhintergalactic.tile.multi.elevatormodules;

import gregtech.api.enums.GTValues;
import gregtech.api.interfaces.metatileentity.IMetaTileEntity;
import gregtech.api.interfaces.tileentity.IGregTechTileEntity;
import gregtech.api.logic.ProcessingLogic;
import gregtech.api.recipe.RecipeMap;
import gregtech.api.recipe.check.CheckRecipeResult;
import gregtech.api.recipe.check.CheckRecipeResultRegistry;
import gregtech.api.util.GTRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.MultiblockTooltipBuilder;
import gtnhintergalactic.recipe.IGRecipeMaps;
import gtnhintergalactic.recipe.ResultNoSpaceProject;
import gtnhintergalactic.tile.multi.elevator.ElevatorUtil;
import gtnhintergalactic.tile.multi.elevatormodules.TileEntityModuleBase;
import net.minecraft.util.EnumChatFormatting;
import org.jetbrains.annotations.NotNull;

public class TileEntityModuleResearch
extends TileEntityModuleBase {
    private static final int MODULE_VOLTAGE_TIER = 12;
    protected static final int MODULE_TIER = 1;
    protected static final int MINIMUM_MOTOR_TIER = 2;

    public TileEntityModuleResearch(int aID, String aName, String aNameRegional) {
        super(aID, aName, aNameRegional, 12, 1, 2);
    }

    public TileEntityModuleResearch(String aName) {
        super(aName, 12, 1, 2);
    }

    @Override
    protected MultiblockTooltipBuilder createTooltip() {
        MultiblockTooltipBuilder tt = new MultiblockTooltipBuilder();
        tt.addMachineType(GTUtility.translate("gt.blockmachines.module.name", new Object[0])).addInfo(GTUtility.translate("gt.blockmachines.multimachine.project.ig.research.desc0", new Object[0])).addInfo(EnumChatFormatting.LIGHT_PURPLE.toString() + EnumChatFormatting.BOLD + GTUtility.translate("gt.blockmachines.multimachine.project.ig.research.desc1", new Object[0])).addInfo(GTUtility.translate("gt.blockmachines.multimachine.project.ig.desc2", new Object[0])).addInfo(GTUtility.translate("gt.blockmachines.multimachine.project.ig.motorT2", new Object[0])).beginStructureBlock(1, 5, 2, false).addCasingInfoRange(GTUtility.translate("gt.blockcasings.ig.0.name", new Object[0]), 0, 9, false).addInputBus(GTUtility.translate("ig.elevator.structure.AnyBaseCasingWith1Dot", new Object[0]), 1).addOutputBus(GTUtility.translate("ig.elevator.structure.AnyBaseCasingWith1Dot", new Object[0]), 1).addInputHatch(GTUtility.translate("ig.elevator.structure.AnyBaseCasingWith1Dot", new Object[0]), 1).addOutputHatch(GTUtility.translate("ig.elevator.structure.AnyBaseCasingWith1Dot", new Object[0]), 1).toolTipFinisher(new String[0]);
        return tt;
    }

    @Override
    public IMetaTileEntity newMetaEntity(IGregTechTileEntity aTileEntity) {
        return new TileEntityModuleResearch(this.mName);
    }

    @Override
    public RecipeMap<?> getRecipeMap() {
        return IGRecipeMaps.spaceResearchRecipes;
    }

    @Override
    protected void setProcessingLogicPower(ProcessingLogic logic) {
        logic.setAvailableVoltage(GTValues.V[this.tTier]);
        logic.setAvailableAmperage(1L);
    }

    @Override
    protected ProcessingLogic createProcessingLogic() {
        return new ProcessingLogic(){

            @Override
            @NotNull
            protected CheckRecipeResult validateRecipe(@NotNull GTRecipe recipe) {
                if (this.lastRecipe != recipe) {
                    String neededProject = recipe.getMetadata(IGRecipeMaps.SPACE_PROJECT);
                    String neededLocation = recipe.getMetadata(IGRecipeMaps.SPACE_LOCATION);
                    if (!ElevatorUtil.isProjectAvailable(TileEntityModuleResearch.this.getBaseMetaTileEntity().getOwnerUuid(), neededProject, neededLocation)) {
                        return new ResultNoSpaceProject(neededProject, neededLocation);
                    }
                }
                return CheckRecipeResultRegistry.SUCCESSFUL;
            }
        };
    }

    @Override
    public boolean protectsExcessItem() {
        return !this.eSafeVoid;
    }

    @Override
    public boolean protectsExcessFluid() {
        return !this.eSafeVoid;
    }
}

