/*
 * Decompiled with CFR 0.152.
 */
package gregtech.common;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.gtnewhorizon.gtnhlib.eventbus.EventBusSubscriber;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Mods;
import gregtech.api.net.cape.GTPacketBroadcastCapes;
import gregtech.api.util.GTLog;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Scanner;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.util.StringUtils;

@EventBusSubscriber
@ParametersAreNonnullByDefault
public class GTCapesLoader
implements Runnable {
    private static final Multimap<UUID, String> AVAILABLE_CAPES_UUID = HashMultimap.create();
    private static final Multimap<String, String> AVAILABLE_CAPES_NAME = HashMultimap.create();
    private static final Map<UUID, String> SELECTED_CAPES = new HashMap<UUID, String>();

    @Override
    public void run() {
        GTLog.out.println("GTMod: Downloading Cape List");
        GTCapesLoader.downloadGTNHUUIDCapes();
        GTCapesLoader.downloadGregoriusCapes();
        if (Mods.GalacticraftCore.isModLoaded()) {
            GTCapesLoader.downloadGalacticraftCapes();
        }
        if (Mods.GalaxySpace.isModLoaded()) {
            GTCapesLoader.downloadGalaxySpaceCapes();
        }
        GTCapesLoader.addHarcodedCapes();
    }

    @SubscribeEvent
    public static void onClientConnect(FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        INetHandler iNetHandler = event.handler;
        if (iNetHandler instanceof NetHandlerPlayServer) {
            NetHandlerPlayServer handlerPlayServer = (NetHandlerPlayServer)iNetHandler;
            GTValues.NW.sendToPlayer(new GTPacketBroadcastCapes(SELECTED_CAPES), handlerPlayServer.field_147369_b);
        }
    }

    @SubscribeEvent
    public static void onClientDisconnect(FMLNetworkEvent.ServerDisconnectionFromClientEvent event) {
        INetHandler iNetHandler = event.handler;
        if (iNetHandler instanceof NetHandlerPlayServer) {
            NetHandlerPlayServer handlerPlayServer = (NetHandlerPlayServer)iNetHandler;
            SELECTED_CAPES.remove(handlerPlayServer.field_147369_b.func_110124_au());
        }
    }

    public static void setSelectedCape(EntityPlayer player, String cape) {
        SELECTED_CAPES.put(player.func_110124_au(), cape);
    }

    public static void clearSelectedCapes() {
        SELECTED_CAPES.clear();
    }

    public static Collection<String> getAvailableCapes(@Nullable EntityPlayer player) {
        if (player == null) {
            return Collections.emptySet();
        }
        UUID uuid = player.func_110124_au();
        HashSet<String> capes = new HashSet<String>();
        capes.add("cape_mc");
        capes.addAll(AVAILABLE_CAPES_UUID.get((Object)uuid));
        capes.addAll(AVAILABLE_CAPES_NAME.get((Object)player.func_70005_c_().toLowerCase(Locale.ROOT)));
        return capes;
    }

    private static void downloadGTNHUUIDCapes() {
        Pattern pattern = Pattern.compile("^([0-9a-fA-F]{8}-?[0-9a-fA-F]{4}-?[0-9a-fA-F]{4}-?[0-9a-fA-F]{4}-?[0-9a-fA-F]{12})(?:$|\\:(cape\\w+).*$)");
        String url = "https://raw.githubusercontent.com/GTNewHorizons/CustomGTCapeHook-Cape-List/master/capesUUID.txt";
        try (Scanner scanner = new Scanner(new URL(url).openStream());){
            while (scanner.hasNextLine()) {
                Matcher matcher = pattern.matcher(scanner.nextLine());
                if (!matcher.find()) continue;
                if (matcher.groupCount() == 2) {
                    GTCapesLoader.putUUID(matcher.group(1), matcher.group(2));
                    continue;
                }
                GTCapesLoader.putUUID(matcher.group(1));
            }
        }
        catch (Exception e) {
            e.printStackTrace(GTLog.err);
        }
    }

    private static void downloadGregoriusCapes() {
        String url = "https://gregtech.overminddl1.com/com/gregoriust/gregtech/supporterlist.txt";
        try (Scanner scanner = new Scanner(new URL(url).openStream());){
            while (scanner.hasNextLine()) {
                GTCapesLoader.putName(scanner.nextLine());
            }
        }
        catch (Exception e) {
            e.printStackTrace(GTLog.err);
        }
    }

    private static void downloadGalacticraftCapes() {
        String url = "https://raw.github.com/micdoodle8/Galacticraft/master/capes.txt";
        try (Scanner scanner = new Scanner(new URL(url).openStream());){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] parts = line.split(":");
                if (parts.length == 2) {
                    GTCapesLoader.putName(parts[0], parts[1] + "GC");
                    continue;
                }
                GTLog.err.println("Invalid cape mapping: " + line);
            }
        }
        catch (Exception e) {
            e.printStackTrace(GTLog.err);
        }
    }

    private static void downloadGalaxySpaceCapes() {
        String url = "https://demigods.at.ua/capes.txt";
        try (Scanner scanner = new Scanner(new URL(url).openStream());){
            while (scanner.hasNextLine()) {
                String line = scanner.nextLine();
                String[] parts = line.split(":");
                if (parts.length == 2) {
                    GTCapesLoader.putName(parts[0], parts[1] + "GS");
                    continue;
                }
                GTLog.err.println("Invalid cape mapping: " + line);
            }
        }
        catch (Exception e) {
            e.printStackTrace(GTLog.err);
        }
    }

    private static void addHarcodedCapes() {
        GTCapesLoader.putBoth("friedi4321", "15552162561244a9a748c8d71a7d180d", "capefriedi");
        GTCapesLoader.putBoth("mr_brain", "10833ef6956d4dc1a10a46b3d07ec4d8", "capebrain");
        GTCapesLoader.putBoth("gregoriust", "68af6d40a79e4a2998469d4a319ec774", "capegregoriust");
        GTCapesLoader.putBoth("renadi", "fc363256d8bd44cda3167aaf399ea9b8");
        GTCapesLoader.putBoth("hanakocz", "03f9ec5b90e943c0a83cb0ba433e46c4");
        GTCapesLoader.putBoth("MysteryDump", "11c7a3235f5d4203b04425964f5f2e93");
        GTCapesLoader.putName("Flaver4");
        GTCapesLoader.putName("x_Fame");
        GTCapesLoader.putName("Peluche321");
        GTCapesLoader.putBoth("Goshen_Ithilien", "f71dc90f789c44879ab00627c4fbd68e");
        GTCapesLoader.putBoth("manf", "0975b0b9ee7b4e179fb8848c99931987");
        GTCapesLoader.putBoth("Bimgo", "24f84f5106ab40fc8843c649e5d28e35");
        GTCapesLoader.putBoth("leagris", "09752aa38b9c4f8fb04f5421e799547d");
        GTCapesLoader.putName("IAmMinecrafter02");
        GTCapesLoader.putBoth("Cerous", "b2414f04725547549bd424ee15c5b9ee");
        GTCapesLoader.putBoth("Devilin_Pixy", "2a5b9ab7c42440aaa2ebd4405e225a6a");
        GTCapesLoader.putName("Bkarlsson87");
        GTCapesLoader.putBoth("BadAlchemy", "1779b561840d4c30ae2b561dca1bd388");
        GTCapesLoader.putBoth("CaballoCraft", "06479e4cd4c544379b67f665ae44fb67");
        GTCapesLoader.putBoth("melanclock", "3d03bdd274a34d32b8d1609e55634cf1");
        GTCapesLoader.putBoth("Resursator", "c973398685874a1eaad3ed5403043f58");
        GTCapesLoader.putBoth("demanzke", "b076081584f846de8ce89f844d3da330");
        GTCapesLoader.putName("AndrewAmmerlaan");
        GTCapesLoader.putBoth("Deathlycraft", "0699ccfe0dde4c68b481c6a3f418baff");
        GTCapesLoader.putBoth("Jirajha", "910ec6c4b7cd411eb562bad1c164ba0e");
        GTCapesLoader.putBoth("Axlegear", "221812767a2641398a6b526242adf668");
        GTCapesLoader.putBoth("kei_kouma", "9778b73ec456401ebdba38318535140f");
        GTCapesLoader.putBoth("Dracion", "d05d7477c4e44e8ea08254609fdee37e");
        GTCapesLoader.putBoth("dungi", "af117d8ccab940b1a31b9f5b24f5c960");
        GTCapesLoader.putBoth("Dorfschwein", "fe18f13ee5a542f3915b6691461abb8c");
        GTCapesLoader.putBoth("Zero_Tw0", "59639f87621d429795cb3ff27affd999");
        GTCapesLoader.putName("mattiagraz85");
        GTCapesLoader.putBoth("sebastiank30", "fd0f5c1ce3704ec0b79c82632a91e19e");
        GTCapesLoader.putBoth("Plem", "e1e15b6556254ad99fbe262a4ca2c28c");
        GTCapesLoader.putBoth("invultri", "6208249874634eef9c13f949a8e129f5");
        GTCapesLoader.putBoth("grillo126", "08929089bffa4b9088c993804b4a966d");
        GTCapesLoader.putName("malcanteth");
        GTCapesLoader.putBoth("Malevolence_", "794db9e178124537b928c64e589acf24");
        GTCapesLoader.putName("Nicholas_Manuel");
        GTCapesLoader.putName("Sirbab");
        GTCapesLoader.putBoth("kehaan", "2cea0fadf8934ea4ae97a7b98cb104a6");
        GTCapesLoader.putName("bpgames123");
        GTCapesLoader.putBoth("semig0d", "5a84bc8e42464c50920fa9b37504a798");
        GTCapesLoader.putName("9000bowser");
        GTCapesLoader.putBoth("Sovereignty89", "c5cce1d9397e4fed9a88979625097bdb");
        GTCapesLoader.putBoth("Kris1432", "12cad9638dca4540b00207f3039cc5a7");
        GTCapesLoader.putName("xander_cage_");
        GTCapesLoader.putBoth("samuraijp", "e00d0e7f8b534e98922959ad61b71e2b");
        GTCapesLoader.putBoth("bsaa", "05b7fd136bb54a57b6a1ff67eb83ef23");
        GTCapesLoader.putBoth("SpwnX", "e7778d79c85447d8b16169664c0bf444");
        GTCapesLoader.putBoth("tworf", "c440c5aea3984d57b32d561201c34603");
        GTCapesLoader.putBoth("Kadah", "029192bf53fa4bebb91ea2442165b2b2");
        GTCapesLoader.putBoth("kanni", "f1a1318dff0143f1ae81c7cfd0eda099");
        GTCapesLoader.putBoth("Stute", "21b71568d9e94a73bf2d8918bf315edd");
        GTCapesLoader.putBoth("Hegik", "309c38bfc778446387be3c2d63e379cc");
        GTCapesLoader.putBoth("Onlyme", "a2c622fc10974ea9ad2652cd2857acd7");
        GTCapesLoader.putBoth("t3hero", "2016b5650a634a2d800bb786ac256288");
        GTCapesLoader.putBoth("Hotchi", "8064e7a53d67473a9cb4750937929d55");
        GTCapesLoader.putBoth("jagoly", "121519fb74114e05a821bb1d7ca01a48");
        GTCapesLoader.putBoth("Nullav", "3022ddd44e6040ad818d079bb8fe66ed");
        GTCapesLoader.putBoth("BH5432", "2d7d76ed7acb460184ede035405dbcaf");
        GTCapesLoader.putBoth("Sibmer", "8e887e22411942d1926569e688db0ad2");
        GTCapesLoader.putBoth("inceee", "24630ce4ff704dff867bba0e71b48940");
        GTCapesLoader.putBoth("foxxx0", "3043bce6c15f4318a9df679dda391d63");
        GTCapesLoader.putBoth("Hartok", "6b6710a2446747aeba02ae9e80e9d64e");
        GTCapesLoader.putBoth("TMSama", "efda63851ad64121b814dcc6c89a268e");
        GTCapesLoader.putName("Shlnen");
        GTCapesLoader.putBoth("Carsso", "7287350967624aa9949416886064a4c1");
        GTCapesLoader.putBoth("zessirb", "6a161ea2c7f84fd5b47e2de4e960cdbb");
        GTCapesLoader.putBoth("meep310", "014cbd05be5b450daa5197bd9f9f91cc");
        GTCapesLoader.putBoth("Seldron", "dbc325fc3fdd4cd3b6f545aed8b4e51f");
        GTCapesLoader.putBoth("yttr1um", "f17a78f2f78c4987a62d51e49a7ab147");
        GTCapesLoader.putBoth("hohounk", "c5d25043dc334538892c1c70ce03134c");
        GTCapesLoader.putBoth("freebug", "ac70160404f54210ab004e342a99f2a2");
        GTCapesLoader.putBoth("Sylphio", "0f8cdb5cada1481aaf696a62c4093666");
        GTCapesLoader.putBoth("jmarler", "9c4c9812253446dea7da2135e88f0a30");
        GTCapesLoader.putName("Saberawr");
        GTCapesLoader.putBoth("r00teniy", "8d302f192584486b94aa6547a385df26");
        GTCapesLoader.putBoth("Neonbeta", "20829ffa91094154bb3b4cd39c07cd62");
        GTCapesLoader.putBoth("yinscape", "4e5087038fd74224b56c7e2d1194f963");
        GTCapesLoader.putBoth("voooon24", "2c1ca510ab7c45f680ac2a18874084a5");
        GTCapesLoader.putBoth("Quintine", "86fa9a01066f4186907a34e0f8638e29");
        GTCapesLoader.putBoth("peach774", "cd056ffabc124556b9f62bf6166183c2");
        GTCapesLoader.putBoth("lepthymo", "fd64a24674fa4bfdb1e60058939d362b");
        GTCapesLoader.putName("bildeman");
        GTCapesLoader.putBoth("Kremnari", "5d51a232c5864697a1f735f4501f3797");
        GTCapesLoader.putBoth("Aerosalo", "69d489a9fd174de3bb73dc8add7b0c2a");
        GTCapesLoader.putName("mr10movie");
        GTCapesLoader.putName("OndraSter");
        GTCapesLoader.putBoth("oscares91", "2c04fdcdad6f465399947d95f2c8dd5f");
        GTCapesLoader.putName("Daxx367x2");
        GTCapesLoader.putBoth("EGERTRONx", "91171de3db7044f4b8af55b1e3f5fc99");
        GTCapesLoader.putBoth("aka13_404", "f6d247253ea4409ba3fc6fc55767d392");
        GTCapesLoader.putBoth("Abouttabs", "305cbb19345c46f3ad460f908c8a0b12");
        GTCapesLoader.putBoth("Johnstaal", "5473c1654b7a43e8bed82bc71ac2b2f4");
        GTCapesLoader.putName("djshiny99");
        GTCapesLoader.putName("megatronp");
        GTCapesLoader.putBoth("DZCreeper", "8d04e5dfe6a14c4981d047f32c219d1c");
        GTCapesLoader.putBoth("Kane_Hart", "88d1fcdc0b18442ab78f6fa25acabb97");
        GTCapesLoader.putBoth("Truculent", "dae28db1649b4e4cb88efed0cdc32917");
        GTCapesLoader.putBoth("vidplace7", "ce7fb761bfa746789476827587a931cd");
        GTCapesLoader.putBoth("simon6689", "0c0cb210d7fa4b9fb2ccc3a59634a865");
        GTCapesLoader.putBoth("MomoNasty", "f0389907f88443f7a2df3d03bcab6232");
        GTCapesLoader.putBoth("UnknownXLV", "aae7b38be491442497855de04397f45c");
        GTCapesLoader.putBoth("goreacraft", "3172f7495c784005965523dcddec845d");
        GTCapesLoader.putName("Fluttermine");
        GTCapesLoader.putBoth("Daddy_Cecil", "6e91ba4128a14316a5b6348eb51d5dea");
        GTCapesLoader.putBoth("MrMaleficus", "7e76edc9299d4556a4855879015bebc2");
        GTCapesLoader.putBoth("TigersFangs", "639d699489d84282bc0152c6d7a204e8");
        GTCapesLoader.putBoth("cublikefoot", "b03d96563bfc43168bf120342fa75f5b");
        GTCapesLoader.putBoth("chainman564", "b301495d4d27419085047481b1b238bb");
        GTCapesLoader.putBoth("NikitaBuker", "c6716b9a9ffc4ee18dc1d56cf10066df");
        GTCapesLoader.putBoth("Misha999777", "a6f8c815444b4caea0e10eaf3a0fc199");
        GTCapesLoader.putBoth("25FiveDetail", "a41b475064874091a7fefd55c8ee2f5f");
        GTCapesLoader.putName("AntiCivilBoy");
        GTCapesLoader.putBoth("michaelbrady", "573b94e7cd6d42a691c5e3757c434eec");
        GTCapesLoader.putName("xXxIceFirexXx");
        GTCapesLoader.putName("Speedynutty68");
        GTCapesLoader.putBoth("GarretSidzaka", "dd107a4c1cab4b4baaa456438e3c92f7");
        GTCapesLoader.putBoth("HallowCharm977", "4e2a8683aed84d53a6330ff0da2cbe4d");
        GTCapesLoader.putBoth("mastermind1919", "c83e6e8e76974448909137f399ed1f43");
        GTCapesLoader.putBoth("The_Hypersonic", "defa4366812c4c72a4fe4de6afa38852");
        GTCapesLoader.putBoth("diamondguy2798", "03c8ced8cb52486ea2a0ea4929b07ef6");
        GTCapesLoader.putBoth("zF4ll3nPr3d4t0r", "7ed0a7db9d4b4528a78269175839a187");
        GTCapesLoader.putName("CrafterOfMines57");
        GTCapesLoader.putName("XxELIT3xSNIP3RxX");
        GTCapesLoader.putName("SuterusuKusanagi");
        GTCapesLoader.putBoth("xavier0014", "42aa6765a6084d28aca3d6d6027bd4ca");
        GTCapesLoader.putBoth("adamros", "cf299609ac554d9d8803f136b87193e9");
        GTCapesLoader.putBoth("alexbegt", "e45e3c6b131f47718100f501bd3b675d");
    }

    private static UUID uuidFromString(String uuid) {
        if (uuid == null) {
            return null;
        }
        if (uuid.length() == 32) {
            StringBuilder sb = new StringBuilder(uuid);
            sb.insert(20, '-');
            sb.insert(16, '-');
            sb.insert(12, '-');
            sb.insert(8, '-');
            return UUID.fromString(sb.toString());
        }
        if (uuid.length() == 36) {
            return UUID.fromString(uuid);
        }
        return null;
    }

    private static void putBoth(String name, String uuidString, String cape) {
        GTCapesLoader.putUUID(uuidString, cape);
        GTCapesLoader.putName(name, cape);
    }

    private static void putBoth(String name, String uuidString) {
        GTCapesLoader.putUUID(uuidString);
        GTCapesLoader.putName(name);
    }

    private static void putUUID(String uuidString) {
        GTCapesLoader.putUUID(uuidString, "cape_gt");
    }

    private static void putUUID(String uuidString, String cape) {
        UUID uuid = GTCapesLoader.uuidFromString(uuidString);
        if (uuid != null) {
            AVAILABLE_CAPES_UUID.put((Object)uuid, (Object)cape);
        }
    }

    private static void putName(String name) {
        GTCapesLoader.putName(name, "cape_gt");
    }

    private static void putName(String name, String cape) {
        if (!StringUtils.func_151246_b((String)name)) {
            AVAILABLE_CAPES_NAME.put((Object)name.toLowerCase(Locale.ROOT), (Object)cape);
        }
    }
}

