/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.util.tooltip;

import gregtech.api.util.tooltip.TooltipTier;
import java.text.DecimalFormat;
import net.minecraft.util.EnumChatFormatting;

public class TooltipHelper {
    public static final EnumChatFormatting DEFAULT = EnumChatFormatting.DARK_GRAY;
    public static final EnumChatFormatting PARALLEL_COLOR = EnumChatFormatting.GOLD;
    public static final EnumChatFormatting SPEED_COLOR = EnumChatFormatting.GREEN;
    public static final EnumChatFormatting EFF_COLOR = EnumChatFormatting.AQUA;
    public static final EnumChatFormatting TIER_COLOR = EnumChatFormatting.WHITE;
    public static final DecimalFormat percentageFormat = new DecimalFormat("0.##%");

    public static String parallelText(String parallels) {
        return TooltipHelper.coloredText(parallels, PARALLEL_COLOR);
    }

    public static String parallelText(int parallels) {
        return TooltipHelper.coloredText(Integer.toString(parallels), parallels == 1 ? DEFAULT : PARALLEL_COLOR);
    }

    public static String speedText(String speed) {
        return TooltipHelper.coloredText(speed, SPEED_COLOR);
    }

    public static String speedText(float speed) {
        return TooltipHelper.coloredText(percentageFormat.format(speed), speed == 1.0f ? DEFAULT : SPEED_COLOR);
    }

    public static String effText(String eff) {
        return TooltipHelper.coloredText(eff, EFF_COLOR);
    }

    public static String effText(float eff) {
        return TooltipHelper.coloredText(percentageFormat.format(eff), eff == 1.0f ? DEFAULT : EFF_COLOR);
    }

    public static String tierText(String tier) {
        return TooltipHelper.coloredText(tier, TIER_COLOR);
    }

    public static String tierText(TooltipTier tier) {
        return TooltipHelper.coloredText(tier.getValue(), TIER_COLOR);
    }

    public static String coloredText(String text, EnumChatFormatting coloring) {
        if (coloring.func_96302_c() || coloring == EnumChatFormatting.GRAY) {
            return String.format("%s%s%s", coloring, text, EnumChatFormatting.GRAY);
        }
        return text;
    }
}

