/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.net.cape;

import com.google.common.io.ByteArrayDataInput;
import cpw.mods.fml.common.network.ByteBufUtils;
import gregtech.api.net.GTPacket;
import gregtech.api.net.GTPacketTypes;
import gregtech.client.GTCapesClientHandler;
import io.netty.buffer.ByteBuf;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.world.IBlockAccess;

@ParametersAreNonnullByDefault
public class GTPacketBroadcastCapes
extends GTPacket {
    private Map<UUID, String> capes;

    public GTPacketBroadcastCapes() {
    }

    public GTPacketBroadcastCapes(UUID uuid, String cape) {
        this(Collections.singletonMap(uuid, cape));
    }

    public GTPacketBroadcastCapes(Map<UUID, String> capes) {
        this.capes = capes;
    }

    @Override
    public byte getPacketID() {
        return GTPacketTypes.BROADCAST_CAPES.id;
    }

    @Override
    public void encode(ByteBuf buffer) {
        buffer.writeInt(this.capes.size());
        for (Map.Entry<UUID, String> p : this.capes.entrySet()) {
            UUID uuid = p.getKey();
            buffer.writeLong(uuid.getMostSignificantBits());
            buffer.writeLong(uuid.getLeastSignificantBits());
            ByteBufUtils.writeUTF8String((ByteBuf)buffer, (String)p.getValue());
        }
    }

    @Override
    public GTPacket decode(ByteArrayDataInput buffer) {
        int num = buffer.readInt();
        HashMap<UUID, String> capes = new HashMap<UUID, String>();
        for (int i = 0; i < num; ++i) {
            capes.put(new UUID(buffer.readLong(), buffer.readLong()), GTPacketBroadcastCapes.readUTF8String(buffer));
        }
        return new GTPacketBroadcastCapes(capes);
    }

    @Override
    public void process(IBlockAccess world) {
        GTCapesClientHandler.setCapes(this.capes);
    }
}

