/*
 * Decompiled with CFR 0.152.
 */
package gregtech.api.interfaces;

import gregtech.api.enums.SubTag;
import gregtech.api.items.MetaBaseItem;
import java.util.List;
import java.util.Optional;
import net.minecraft.dispenser.IBlockSource;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public interface IItemBehaviour<E extends Item> {
    default public boolean onLeftClick(E aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return false;
    }

    default public boolean onMiddleClick(E aItem, ItemStack aStack, EntityPlayer aPlayer) {
        return false;
    }

    default public boolean shouldInterruptBlockActivation(EntityPlayer player, TileEntity tileEntity, ForgeDirection side) {
        return false;
    }

    public boolean onLeftClickEntity(E var1, ItemStack var2, EntityPlayer var3, Entity var4);

    public boolean onItemUse(E var1, ItemStack var2, EntityPlayer var3, World var4, int var5, int var6, int var7, int var8, float var9, float var10, float var11);

    public boolean onItemUseFirst(E var1, ItemStack var2, EntityPlayer var3, World var4, int var5, int var6, int var7, ForgeDirection var8, float var9, float var10, float var11);

    public ItemStack onItemRightClick(E var1, ItemStack var2, World var3, EntityPlayer var4);

    public List<String> getAdditionalToolTips(E var1, List<String> var2, ItemStack var3);

    default public Optional<List<String>> getAdditionalToolTipsWhileSneaking(E aItem, List<String> aList, ItemStack aStack) {
        return Optional.empty();
    }

    public void onUpdate(E var1, ItemStack var2, World var3, Entity var4, int var5, boolean var6);

    public boolean isItemStackUsable(E var1, ItemStack var2);

    public boolean canDispense(E var1, IBlockSource var2, ItemStack var3);

    public ItemStack onDispense(E var1, IBlockSource var2, ItemStack var3);

    public boolean hasProjectile(MetaBaseItem var1, SubTag var2, ItemStack var3);

    public EntityArrow getProjectile(E var1, SubTag var2, ItemStack var3, World var4, double var5, double var7, double var9);

    public EntityArrow getProjectile(E var1, SubTag var2, ItemStack var3, World var4, EntityLivingBase var5, float var6);
}

