/*
 * Decompiled with CFR 0.152.
 */
package galacticgreg;

import galacticgreg.GalacticGreg;
import galacticgreg.api.Enums;
import galacticgreg.api.ModDimensionDef;
import gregtech.api.GregTechAPI;
import gregtech.api.util.GTLog;
import gregtech.common.blocks.BlockOresAbstract;
import gregtech.common.blocks.TileEntityOres;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntitySpaceOres {
    public static boolean setOuterSpaceOreBlock(ModDimensionDef pDimensionDef, World pWorld, int pX, int pY, int pZ, int pMetaData) {
        return TileEntitySpaceOres.setOuterSpaceOreBlock(pDimensionDef, pWorld, pX, pY, pZ, pMetaData, false, -1);
    }

    public static boolean setOuterSpaceOreBlock(ModDimensionDef pDimensionDef, World pWorld, int pX, int pY, int pZ, int pMetaData, boolean pAir) {
        return TileEntitySpaceOres.setOuterSpaceOreBlock(pDimensionDef, pWorld, pX, pY, pZ, pMetaData, pAir, -1);
    }

    private static Enums.ReplaceState CheckForReplaceableBlock(World pWorld, int pX, int pY, int pZ, ModDimensionDef pDimDef) {
        try {
            Enums.ReplaceState tFlag = Enums.ReplaceState.Unknown;
            Block targetBlock = pWorld.func_147439_a(pX, pY, pZ);
            int targetBlockMeta = pWorld.func_72805_g(pX, pY, pZ);
            tFlag = targetBlock == Blocks.field_150350_a ? Enums.ReplaceState.Airblock : pDimDef.getReplaceStateForBlock(targetBlock, targetBlockMeta);
            return tFlag;
        }
        catch (Exception e) {
            e.printStackTrace(GTLog.err);
            GalacticGreg.Logger.error("Error while processing CheckForReplaceableBlock(), defaulting to UNKNOWN", new Object[0]);
            return Enums.ReplaceState.Unknown;
        }
    }

    public static boolean setOuterSpaceOreBlock(ModDimensionDef pDimensionDef, World pWorld, int pX, int pY, int pZ, int pMetaData, boolean pAir, int pCustomGTOreOffset) {
        block12: {
            if (!pAir) {
                pY = Math.min(pWorld.func_72940_L(), Math.max(pY, 1));
            }
            if (pDimensionDef == null) {
                GalacticGreg.Logger.warn("Unknown DimensionID: %d. Will not set anything here", pWorld.field_73011_w.field_76574_g);
                return false;
            }
            try {
                Block tBlock = pWorld.func_147439_a(pX, pY, pZ);
                if (pMetaData > 0 && (tBlock != Blocks.field_150350_a || pAir)) {
                    if (pMetaData < 1000 || pMetaData >= 16000) {
                        Enums.ReplaceState tRS = TileEntitySpaceOres.CheckForReplaceableBlock(pWorld, pX, pY, pZ, pDimensionDef);
                        if (tRS == Enums.ReplaceState.Unknown) {
                            GalacticGreg.Logger.trace("Not placing ore Meta %d, as target block is unknown", pMetaData);
                            return false;
                        }
                        if (tRS == Enums.ReplaceState.Airblock && !pAir) {
                            GalacticGreg.Logger.trace("Not placing ore Meta %d in midair, as AIR is FALSE", pMetaData);
                            return false;
                        }
                        if (tRS == Enums.ReplaceState.CannotReplace) {
                            GalacticGreg.Logger.trace("Not placing ore Meta %d, as the state is CANNOTREPLACE", pMetaData);
                            return false;
                        }
                        pMetaData = pCustomGTOreOffset == -1 ? (pMetaData += pDimensionDef.getStoneType().getOffset()) : (pMetaData += pCustomGTOreOffset);
                        pWorld.func_147465_d(pX, pY, pZ, GregTechAPI.sBlockOres1, (int)TileEntityOres.getHarvestData((short)pMetaData, ((BlockOresAbstract)GregTechAPI.sBlockOres1).getBaseBlockHarvestLevel(pMetaData % 16000 / 1000)), 0);
                        TileEntity tTileEntity = pWorld.func_147438_o(pX, pY, pZ);
                        if (tTileEntity instanceof TileEntityOres) {
                            ((TileEntityOres)tTileEntity).mMetaData = (short)pMetaData;
                            ((TileEntityOres)tTileEntity).mNatural = true;
                        } else if (GalacticGreg.GalacticConfig.ReportOreGenFailures) {
                            GalacticGreg.Logger.warn("Something went wrong while placing GT OreTileEntity. Meta: %d X [%d] Y [%d] Z [%d]", pMetaData, pX, pY, pZ);
                        }
                        return true;
                    }
                    GalacticGreg.Logger.warn("Not replacing block at pos %d %d %d due unexpected metaData for OreBlock: %d", pX, pY, pZ, pMetaData);
                }
            }
            catch (Exception e) {
                if (!GalacticGreg.GalacticConfig.ReportOreGenFailures) break block12;
                e.printStackTrace();
            }
        }
        return false;
    }
}

