/*
 * Decompiled with CFR 0.152.
 */
package bartworks.util;

import bartworks.API.BioVatLogicAdder;
import bartworks.API.BorosilicateGlass;
import bartworks.MainMod;
import com.gtnewhorizon.structurelib.StructureLibAPI;
import com.gtnewhorizon.structurelib.structure.AutoPlaceEnvironment;
import com.gtnewhorizon.structurelib.structure.IStructureElement;
import gregtech.api.enums.GTValues;
import gregtech.api.enums.Materials;
import gregtech.api.enums.OreDictNames;
import gregtech.api.enums.ToolDictNames;
import gregtech.api.interfaces.IItemContainer;
import gregtech.api.objects.ItemData;
import gregtech.api.objects.MaterialStack;
import gregtech.api.util.CustomGlyphs;
import gregtech.api.util.GTLanguageManager;
import gregtech.api.util.GTLog;
import gregtech.api.util.GTModHandler;
import gregtech.api.util.GTOreDictUnificator;
import gregtech.api.util.GTShapedRecipe;
import gregtech.api.util.GTUtility;
import gregtech.api.util.GlassTier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.init.Items;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BWUtil {
    @Deprecated
    public static final int CLEANROOM = -200;

    public static String translateGTItemStack(ItemStack itemStack) {
        if (!GTUtility.isStackValid(itemStack)) {
            return "Not a Valid ItemStack:" + itemStack;
        }
        String ret = GTLanguageManager.getTranslation(GTLanguageManager.getTranslateableItemStackName(itemStack));
        if (!ret.contains("%material")) {
            return ret;
        }
        String matname = "";
        if (BWUtil.checkStackAndPrefix(itemStack)) {
            matname = GTOreDictUnificator.getAssociation((ItemStack)itemStack).mMaterial.mMaterial.mDefaultLocalName;
        }
        return ret.replace("%material", matname);
    }

    public static void set2DCoordTo1DArray(int indexX, int indexY, int sizeY, Object value, Object[] array) {
        int index = indexX * sizeY + indexY;
        array[index] = value;
    }

    public static Object get2DCoordFrom1DArray(int indexX, int indexY, int sizeY, Object[] array) {
        int index = indexX * sizeY + indexY;
        return array[index];
    }

    public static String subscriptNumbers(String b) {
        char[] chars = b.toCharArray();
        char[] nu = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            int n;
            switch (chars[i]) {
                case '0': {
                    n = CustomGlyphs.SUBSCRIPT0.charAt(0);
                    break;
                }
                case '1': {
                    n = 8321;
                    break;
                }
                case '2': {
                    n = 8322;
                    break;
                }
                case '3': {
                    n = 8323;
                    break;
                }
                case '4': {
                    n = 8324;
                    break;
                }
                case '5': {
                    n = 8325;
                    break;
                }
                case '6': {
                    n = 8326;
                    break;
                }
                case '7': {
                    n = 8327;
                    break;
                }
                case '8': {
                    n = 8328;
                    break;
                }
                case '9': {
                    n = 8329;
                    break;
                }
                case '?': {
                    n = CustomGlyphs.SUBSCRIPT_QUESTION_MARK.charAt(0);
                    break;
                }
                default: {
                    n = chars[i];
                }
            }
            nu[i] = n;
        }
        return new String(nu);
    }

    public static String subscriptNumber(Number b) {
        char[] chars = Long.toString(b.longValue()).toCharArray();
        char[] nu = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            int n;
            switch (chars[i]) {
                case '0': {
                    n = CustomGlyphs.SUBSCRIPT0.charAt(0);
                    break;
                }
                case '1': {
                    n = 8321;
                    break;
                }
                case '2': {
                    n = 8322;
                    break;
                }
                case '3': {
                    n = 8323;
                    break;
                }
                case '4': {
                    n = 8324;
                    break;
                }
                case '5': {
                    n = 8325;
                    break;
                }
                case '6': {
                    n = 8326;
                    break;
                }
                case '7': {
                    n = 8327;
                    break;
                }
                case '8': {
                    n = 8328;
                    break;
                }
                case '9': {
                    n = 8329;
                    break;
                }
                case '?': {
                    n = CustomGlyphs.SUBSCRIPT_QUESTION_MARK.charAt(0);
                    break;
                }
                default: {
                    n = chars[i];
                }
            }
            nu[i] = n;
        }
        return new String(nu);
    }

    public static String superscriptNumbers(String b) {
        char[] chars = b.toCharArray();
        char[] nu = new char[chars.length];
        for (int i = 0; i < chars.length; ++i) {
            char c;
            switch (chars[i]) {
                case '0': {
                    c = CustomGlyphs.SUPERSCRIPT0.charAt(0);
                    break;
                }
                case '1': {
                    c = CustomGlyphs.SUPERSCRIPT1.charAt(0);
                    break;
                }
                case '2': {
                    c = CustomGlyphs.SUPERSCRIPT2.charAt(0);
                    break;
                }
                case '3': {
                    c = CustomGlyphs.SUPERSCRIPT3.charAt(0);
                    break;
                }
                case '4': {
                    c = CustomGlyphs.SUPERSCRIPT4.charAt(0);
                    break;
                }
                case '5': {
                    c = CustomGlyphs.SUPERSCRIPT5.charAt(0);
                    break;
                }
                case '6': {
                    c = CustomGlyphs.SUPERSCRIPT6.charAt(0);
                    break;
                }
                case '7': {
                    c = CustomGlyphs.SUPERSCRIPT7.charAt(0);
                    break;
                }
                case '8': {
                    c = CustomGlyphs.SUPERSCRIPT8.charAt(0);
                    break;
                }
                case '9': {
                    c = CustomGlyphs.SUPERSCRIPT9.charAt(0);
                    break;
                }
                default: {
                    c = chars[i];
                }
            }
            nu[i] = c;
        }
        return new String(nu);
    }

    public static int calculateSv(Materials materials) {
        for (BioVatLogicAdder.MaterialSvPair pair : BioVatLogicAdder.RadioHatch.getMaSv()) {
            if (!pair.getMaterials().equals(materials)) continue;
            return pair.getSievert();
        }
        return (int)(materials.getProtons() == 43L ? (materials.equals(Materials.NaquadahEnriched) ? 140L : (materials.equals(Materials.Naquadria) ? 150L : (materials.equals(Materials.Naquadah) ? 130L : 43L))) : materials.getProtons());
    }

    public static ItemStack setStackSize(ItemStack stack, int size) {
        if (stack != null) {
            stack.field_77994_a = size;
        }
        return stack;
    }

    public static boolean checkStackAndPrefix(ItemStack itemStack) {
        return itemStack != null && GTOreDictUnificator.getAssociation(itemStack) != null && GTOreDictUnificator.getAssociation((ItemStack)itemStack).mPrefix != null && GTOreDictUnificator.getAssociation((ItemStack)itemStack).mMaterial != null && GTOreDictUnificator.getAssociation((ItemStack)itemStack).mMaterial.mMaterial != null;
    }

    @Deprecated
    public static int getMachineVoltageFromTier(int tier) {
        return (int)(30.0 * GTUtility.powInt(4.0, tier - 1));
    }

    public static byte getTier(long voltage) {
        if (voltage <= 0x7FFFFFF8L) {
            return GTUtility.getTier(voltage);
        }
        byte t = 0;
        while (voltage > 8L) {
            voltage >>= 2;
            t = (byte)(t + 1);
        }
        return t;
    }

    public static String getTierName(byte tier) {
        if (GTValues.VN.length - 1 <= tier) {
            return "MAX+";
        }
        return GTValues.VN[tier];
    }

    public static String getTierNameFromVoltage(long voltage) {
        return BWUtil.getTierName(BWUtil.getTier(voltage));
    }

    public static boolean areStacksEqualOrNull(ItemStack aStack1, ItemStack aStack2) {
        return aStack1 == null && aStack2 == null || GTUtility.areStacksEqual(aStack1, aStack2);
    }

    public static boolean areStacksEqualOrEachNull(ItemStack aStack1, ItemStack aStack2) {
        return aStack1 == null || aStack2 == null || GTUtility.areStacksEqual(aStack1, aStack2);
    }

    public static byte getByteFromRarity(EnumRarity rarity) {
        if (EnumRarity.uncommon.equals((Object)rarity)) {
            return 1;
        }
        if (EnumRarity.epic.equals((Object)rarity)) {
            return 2;
        }
        if (EnumRarity.rare.equals((Object)rarity)) {
            return 3;
        }
        return 0;
    }

    public static EnumRarity getRarityFromByte(byte b) {
        EnumRarity enumRarity;
        switch (b) {
            case 1: {
                enumRarity = EnumRarity.uncommon;
                break;
            }
            case 2: {
                enumRarity = EnumRarity.rare;
                break;
            }
            case 3: {
                enumRarity = EnumRarity.epic;
                break;
            }
            default: {
                enumRarity = EnumRarity.common;
            }
        }
        return enumRarity;
    }

    public static byte getCircuitTierFromOreDictName(String name) {
        byte by;
        switch (name) {
            case "circuitPrimitive": {
                by = 0;
                break;
            }
            case "circuitBasic": {
                by = 1;
                break;
            }
            case "circuitGood": {
                by = 2;
                break;
            }
            case "circuitAdvanced": {
                by = 3;
                break;
            }
            case "circuitData": {
                by = 4;
                break;
            }
            case "circuitElite": {
                by = 5;
                break;
            }
            case "circuitMaster": {
                by = 6;
                break;
            }
            case "circuitUltimate": {
                by = 7;
                break;
            }
            case "circuitSuperconductor": {
                by = 8;
                break;
            }
            case "circuitInfinite": {
                by = 9;
                break;
            }
            case "circuitBio": {
                by = 10;
                break;
            }
            case "circuitNano": 
            case "circuitOptical": {
                by = 11;
                break;
            }
            case "circuitPiko": 
            case "circuitExotic": {
                by = 12;
                break;
            }
            case "circuitQuantum": 
            case "circuitCosmic": {
                by = 13;
                break;
            }
            case "circuitTranscendent": {
                by = 14;
                break;
            }
            default: {
                by = -1;
            }
        }
        return by;
    }

    public static byte getCircuitTierFromItemStack(ItemStack stack) {
        for (String oreName : BWUtil.getOreNames(stack)) {
            byte tier = BWUtil.getCircuitTierFromOreDictName(oreName);
            if (tier == -1) continue;
            return tier;
        }
        return -1;
    }

    public static boolean isTieredCircuit(ItemStack stack) {
        return BWUtil.getCircuitTierFromItemStack(stack) != -1;
    }

    public static List<String> getOreNames(ItemStack stack) {
        ArrayList<String> ret = new ArrayList<String>();
        for (int oreID : OreDictionary.getOreIDs((ItemStack)stack)) {
            ret.add(OreDictionary.getOreName((int)oreID));
        }
        return ret;
    }

    @Deprecated
    public static <T> IStructureElement<T> ofGlassTiered(final byte mintier, final byte maxtier, final byte notset, final BiConsumer<T, Byte> setter, final Function<T, Byte> getter, final int aDots) {
        return new IStructureElement<T>(){
            private final IStructureElement<T> placementDelegate;
            {
                this.placementDelegate = BorosilicateGlass.ofBoroGlass(notset, mintier, maxtier, setter, getter);
            }

            public boolean check(T te, World world, int x, int y, int z) {
                int meta;
                if (world.func_147437_c(x, y, z)) {
                    return false;
                }
                Block block = world.func_147439_a(x, y, z);
                int glassTier = GlassTier.getGlassBlockTier(block, meta = world.func_72805_g(x, y, z));
                if (glassTier == 0 || glassTier == notset || glassTier < mintier || glassTier > maxtier) {
                    return false;
                }
                if ((Byte)getter.apply(te) == notset) {
                    setter.accept(te, (byte)glassTier);
                }
                return (Byte)getter.apply(te) == glassTier;
            }

            public boolean couldBeValid(T te, World world, int x, int y, int z, ItemStack trigger) {
                int meta;
                if (world.func_147437_c(x, y, z)) {
                    return false;
                }
                Block block = world.func_147439_a(x, y, z);
                int glassTier = GlassTier.getGlassBlockTier(block, meta = world.func_72805_g(x, y, z));
                return glassTier != 0 && glassTier != notset && glassTier >= mintier && glassTier <= maxtier;
            }

            public boolean spawnHint(T te, World world, int x, int y, int z, ItemStack itemStack) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)(aDots - 1));
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return this.placementDelegate.placeBlock(t, world, x, y, z, trigger);
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return this.placementDelegate.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    @Deprecated
    public static <T> IStructureElement<T> ofGlassTieredMixed(final byte mintier, final byte maxtier, final int aDots) {
        return new IStructureElement<T>(){
            private final IStructureElement<T> placementDelegate;
            {
                this.placementDelegate = BorosilicateGlass.ofBoroGlass((byte)0, mintier, maxtier, (v1, v2) -> {}, v1 -> (byte)0);
            }

            public boolean check(T te, World world, int x, int y, int z) {
                int meta;
                if (world.func_147437_c(x, y, z)) {
                    return false;
                }
                Block block = world.func_147439_a(x, y, z);
                int glassTier = GlassTier.getGlassBlockTier(block, meta = world.func_72805_g(x, y, z));
                if (glassTier == 0) {
                    return false;
                }
                return glassTier >= mintier && glassTier <= maxtier;
            }

            public boolean couldBeValid(T te, World world, int x, int y, int z, ItemStack trigger) {
                return this.check(te, world, x, y, z);
            }

            public boolean spawnHint(T te, World world, int x, int y, int z, ItemStack itemStack) {
                StructureLibAPI.hintParticle((World)world, (int)x, (int)y, (int)z, (Block)StructureLibAPI.getBlockHint(), (int)(aDots - 1));
                return true;
            }

            public boolean placeBlock(T t, World world, int x, int y, int z, ItemStack trigger) {
                return this.placementDelegate.placeBlock(t, world, x, y, z, trigger);
            }

            public IStructureElement.PlaceResult survivalPlaceBlock(T t, World world, int x, int y, int z, ItemStack trigger, AutoPlaceEnvironment env) {
                return this.placementDelegate.survivalPlaceBlock(t, world, x, y, z, trigger, env);
            }
        };
    }

    public static ShapedOreRecipe createGTCraftingRecipe(ItemStack aResult, long aBitMask, Object[] aRecipe) {
        return BWUtil.createGTCraftingRecipe(aResult, null, null, (aBitMask & GTModHandler.RecipeBits.MIRRORED) != 0L, (aBitMask & GTModHandler.RecipeBits.BUFFERED) != 0L, (aBitMask & GTModHandler.RecipeBits.KEEPNBT) != 0L, (aBitMask & GTModHandler.RecipeBits.DISMANTLEABLE) != 0L, (aBitMask & GTModHandler.RecipeBits.NOT_REMOVABLE) == 0L, (aBitMask & GTModHandler.RecipeBits.REVERSIBLE) != 0L, (aBitMask & GTModHandler.RecipeBits.DELETE_ALL_OTHER_RECIPES) != 0L, (aBitMask & GTModHandler.RecipeBits.DELETE_ALL_OTHER_RECIPES_IF_SAME_NBT) != 0L, (aBitMask & GTModHandler.RecipeBits.DELETE_ALL_OTHER_SHAPED_RECIPES) != 0L, (aBitMask & GTModHandler.RecipeBits.DELETE_ALL_OTHER_NATIVE_RECIPES) != 0L, (aBitMask & GTModHandler.RecipeBits.DO_NOT_CHECK_FOR_COLLISIONS) == 0L, (aBitMask & GTModHandler.RecipeBits.ONLY_ADD_IF_THERE_IS_ANOTHER_RECIPE_FOR_IT) != 0L, (aBitMask & GTModHandler.RecipeBits.ONLY_ADD_IF_RESULT_IS_NOT_NULL) != 0L, aRecipe);
    }

    public static ShapedOreRecipe createGTCraftingRecipe(ItemStack aResult, Enchantment[] aEnchantmentsAdded, int[] aEnchantmentLevelsAdded, boolean aMirrored, boolean aBuffered, boolean aKeepNBT, boolean aDismantleable, boolean aRemovable, boolean aReversible, boolean aRemoveAllOthersWithSameOutput, boolean aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, boolean aRemoveAllOtherShapedsWithSameOutput, boolean aRemoveAllOtherNativeRecipes, boolean aCheckForCollisions, boolean aOnlyAddIfThereIsAnyRecipeOutputtingThis, boolean aOnlyAddIfResultIsNotNull, Object[] aRecipe) {
        int n;
        Object object;
        aResult = GTOreDictUnificator.get(true, aResult);
        if (aOnlyAddIfResultIsNotNull && aResult == null) {
            return null;
        }
        if (aResult != null && Items.field_151008_G.getDamage(aResult) == Short.MAX_VALUE) {
            Items.field_151008_G.setDamage(aResult, 0);
        }
        if (aRecipe == null || aRecipe.length == 0) {
            return null;
        }
        boolean tThereWasARecipe = false;
        for (int i = 0; i < aRecipe.length; i = (int)((byte)(i + 1))) {
            Object object2 = aRecipe[i];
            if (object2 instanceof IItemContainer) {
                IItemContainer itemContainer = (IItemContainer)object2;
                aRecipe[i] = itemContainer.get(1L, new Object[0]);
                continue;
            }
            object2 = aRecipe[i];
            if (object2 instanceof Enum) {
                Enum enum_ = (Enum)object2;
                aRecipe[i] = enum_.name();
                continue;
            }
            if (aRecipe[i] == null || aRecipe[i] instanceof ItemStack || aRecipe[i] instanceof ItemData || aRecipe[i] instanceof String || aRecipe[i] instanceof Character) continue;
            aRecipe[i] = aRecipe[i].toString();
        }
        StringBuilder shape = new StringBuilder("");
        int idx = 0;
        if (aRecipe[idx] instanceof Boolean) {
            throw new IllegalArgumentException();
        }
        ArrayList<Object> tRecipeList = new ArrayList<Object>(Arrays.asList(aRecipe));
        while ((object = aRecipe[idx]) instanceof String) {
            String string = (String)object;
            StringBuilder s = new StringBuilder(string);
            ++idx;
            shape.append((CharSequence)s);
            while (s.length() < 3) {
                s.append(" ");
            }
            if (s.length() > 3) {
                throw new IllegalArgumentException();
            }
            block31: for (char c : s.toString().toCharArray()) {
                switch (c) {
                    case 'b': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolBlade.name());
                        continue block31;
                    }
                    case 'c': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolCrowbar.name());
                        continue block31;
                    }
                    case 'd': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolScrewdriver.name());
                        continue block31;
                    }
                    case 'f': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolFile.name());
                        continue block31;
                    }
                    case 'h': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolHardHammer.name());
                        continue block31;
                    }
                    case 'i': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolSolderingIron.name());
                        continue block31;
                    }
                    case 'j': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolSolderingMetal.name());
                        continue block31;
                    }
                    case 'k': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolKnife.name());
                        continue block31;
                    }
                    case 'm': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolMortar.name());
                        continue block31;
                    }
                    case 'p': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolDrawplate.name());
                        continue block31;
                    }
                    case 'r': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolSoftMallet.name());
                        continue block31;
                    }
                    case 's': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolSaw.name());
                        continue block31;
                    }
                    case 'w': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolWrench.name());
                        continue block31;
                    }
                    case 'x': {
                        tRecipeList.add(Character.valueOf(c));
                        tRecipeList.add(ToolDictNames.craftingToolWireCutter.name());
                    }
                }
            }
        }
        aRecipe = tRecipeList.toArray();
        if (aRecipe[idx] instanceof Boolean) {
            ++idx;
        }
        HashMap<Character, ItemStack> tItemStackMap = new HashMap<Character, ItemStack>();
        HashMap<Character, ItemData> tItemDataMap = new HashMap<Character, ItemData>();
        tItemStackMap.put(Character.valueOf(' '), null);
        boolean tRemoveRecipe = true;
        while (idx < aRecipe.length) {
            if (aRecipe[idx] == null || aRecipe[idx + 1] == null) {
                if (GTValues.D1) {
                    GTLog.err.println("WARNING: Missing Item for shaped Recipe: " + (aResult == null ? "null" : aResult.func_82833_r()));
                    for (Object tContent : aRecipe) {
                        GTLog.err.println(tContent);
                    }
                }
                return null;
            }
            Character chr = (Character)aRecipe[idx];
            Object in = aRecipe[idx + 1];
            if (in instanceof ItemStack) {
                tItemStackMap.put(chr, GTUtility.copy(in));
                tItemDataMap.put(chr, GTOreDictUnificator.getItemData((ItemStack)in));
            } else if (in instanceof ItemData) {
                Object tContent;
                String tString = in.toString();
                tContent = tString;
                n = -1;
                switch (((String)tContent).hashCode()) {
                    case 2112754735: {
                        if (!((String)tContent).equals("plankWood")) break;
                        n = 0;
                        break;
                    }
                    case 1563779444: {
                        if (!((String)tContent).equals("stoneNetherrack")) break;
                        n = 1;
                        break;
                    }
                    case -1075426848: {
                        if (!((String)tContent).equals("stoneObsidian")) break;
                        n = 2;
                        break;
                    }
                    case 316729327: {
                        if (!((String)tContent).equals("stoneEndstone")) break;
                        n = 3;
                    }
                }
                switch (n) {
                    case 0: {
                        tItemDataMap.put(chr, new ItemData(Materials.Wood, 3628800L, new MaterialStack[0]));
                        break;
                    }
                    case 1: {
                        tItemDataMap.put(chr, new ItemData(Materials.Netherrack, 3628800L, new MaterialStack[0]));
                        break;
                    }
                    case 2: {
                        tItemDataMap.put(chr, new ItemData(Materials.Obsidian, 3628800L, new MaterialStack[0]));
                        break;
                    }
                    case 3: {
                        tItemDataMap.put(chr, new ItemData(Materials.Endstone, 3628800L, new MaterialStack[0]));
                        break;
                    }
                    default: {
                        tItemDataMap.put(chr, (ItemData)in);
                    }
                }
                ItemStack tStack2 = GTOreDictUnificator.getFirstOre(in, 1L);
                if (tStack2 == null) {
                    tRemoveRecipe = false;
                } else {
                    tItemStackMap.put(chr, tStack2);
                }
                aRecipe[idx + 1] = in.toString();
            } else if (in instanceof String) {
                if (in.equals(OreDictNames.craftingChest.toString())) {
                    tItemDataMap.put(chr, new ItemData(Materials.Wood, 29030400L, new MaterialStack[0]));
                } else if (in.equals(OreDictNames.craftingBook.toString())) {
                    tItemDataMap.put(chr, new ItemData(Materials.Paper, 10886400L, new MaterialStack[0]));
                } else if (in.equals(OreDictNames.craftingPiston.toString())) {
                    tItemDataMap.put(chr, new ItemData(Materials.Stone, 14515200L, Materials.Wood, 10886400L));
                } else if (in.equals(OreDictNames.craftingFurnace.toString())) {
                    tItemDataMap.put(chr, new ItemData(Materials.Stone, 29030400L, new MaterialStack[0]));
                } else if (in.equals(OreDictNames.craftingIndustrialDiamond.toString())) {
                    tItemDataMap.put(chr, new ItemData(Materials.Diamond, 3628800L, new MaterialStack[0]));
                } else if (in.equals(OreDictNames.craftingAnvil.toString())) {
                    tItemDataMap.put(chr, new ItemData(Materials.Iron, 36288000L, new MaterialStack[0]));
                }
                ItemStack tStack = GTOreDictUnificator.getFirstOre(in, 1L);
                if (tStack == null) {
                    tRemoveRecipe = false;
                } else {
                    tItemStackMap.put(chr, tStack);
                }
            } else {
                throw new IllegalArgumentException();
            }
            idx += 2;
        }
        if (aReversible && aResult != null) {
            ItemData[] tData = new ItemData[9];
            int x = -1;
            char[] tStack = shape.toString().toCharArray();
            int tStack2 = tStack.length;
            for (n = 0; n < tStack2; ++n) {
                char chr = tStack[n];
                tData[++x] = (ItemData)tItemDataMap.get(Character.valueOf(chr));
            }
            if (GTUtility.arrayContainsNonNull(tData)) {
                GTOreDictUnificator.addItemData(aResult, new ItemData(tData));
            }
        }
        if (aCheckForCollisions && tRemoveRecipe) {
            ItemStack[] tRecipe = new ItemStack[9];
            int x = -1;
            for (char chr : shape.toString().toCharArray()) {
                tRecipe[++x] = (ItemStack)tItemStackMap.get(Character.valueOf(chr));
                if (tRecipe[x] == null || Items.field_151008_G.getDamage(tRecipe[x]) != Short.MAX_VALUE) continue;
                Items.field_151008_G.setDamage(tRecipe[x], 0);
            }
            boolean bl = tThereWasARecipe = GTModHandler.removeRecipe(tRecipe) != null;
        }
        if (aResult == null || aResult.field_77994_a <= 0) {
            return null;
        }
        if (aRemoveAllOthersWithSameOutput || aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT || aRemoveAllOtherShapedsWithSameOutput || aRemoveAllOtherNativeRecipes) {
            boolean bl = tThereWasARecipe = GTModHandler.removeRecipeByOutput(aResult, !aRemoveAllOthersWithSameOutputIfTheyHaveSameNBT, aRemoveAllOtherShapedsWithSameOutput, aRemoveAllOtherNativeRecipes) || tThereWasARecipe;
        }
        if (aOnlyAddIfThereIsAnyRecipeOutputtingThis && !tThereWasARecipe) {
            ArrayList tList = (ArrayList)CraftingManager.func_77594_a().func_77592_b();
            int tList_sS = tList.size();
            for (int i = 0; i < tList_sS && !tThereWasARecipe; ++i) {
                IRecipe tRecipe = (IRecipe)tList.get(i);
                if (GTModHandler.sSpecialRecipeClasses.contains(tRecipe.getClass().getName()) || !GTUtility.areStacksEqual(GTOreDictUnificator.get(tRecipe.func_77571_b()), aResult, true)) continue;
                tList.remove(i);
                --i;
                tList_sS = tList.size();
                tThereWasARecipe = true;
            }
        }
        if (Items.field_151008_G.getDamage(aResult) == Short.MAX_VALUE || Items.field_151008_G.getDamage(aResult) < 0) {
            Items.field_151008_G.setDamage(aResult, 0);
        }
        GTUtility.updateItemStack(aResult);
        return new GTShapedRecipe(GTUtility.copy(aResult), aRemovable, aKeepNBT, aEnchantmentsAdded, aEnchantmentLevelsAdded, aRecipe).setMirrored(aMirrored);
    }

    public static void shortSleep(long nanos) {
        try {
            long end;
            long start = System.nanoTime();
            while (start + nanos >= (end = System.nanoTime())) {
            }
        }
        catch (Exception e) {
            MainMod.LOGGER.catching((Throwable)e);
        }
    }
}

