/*
 * Decompiled with CFR 0.152.
 */
package com.gitlab.cdagaming.unilib.utils.gui.controls;

import com.gitlab.cdagaming.unilib.utils.gui.RenderUtils;
import com.gitlab.cdagaming.unilib.utils.gui.integrations.ScrollPane;
import io.github.cdagaming.unicore.utils.StringUtils;
import java.util.AbstractList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import xyz.wagyourtail.jvmdg.j11.NestHost;
import xyz.wagyourtail.jvmdg.j11.NestMembers;
import xyz.wagyourtail.jvmdg.version.Stub;

@NestMembers(value={TrackedList.class, Entry.class})
public abstract class EntryListPane<E extends Entry<E>>
extends ScrollPane {
    protected final int itemHeight;
    private final List<E> children = new TrackedList();
    protected int headerHeight;
    private boolean renderHeader;
    @Nullable
    private E selected;
    @Nullable
    private E hovered;

    public EntryListPane(Minecraft client, int width, int height, int y, int itemHeight) {
        super(0, y, width, height);
        this.setGameInstance(client);
        this.setCanModifyControls(false);
        this.itemHeight = itemHeight;
    }

    protected void setRenderHeader(boolean renderHeader, int headerHeight) {
        this.renderHeader = renderHeader;
        this.headerHeight = headerHeight;
        if (!renderHeader) {
            this.headerHeight = 0;
        }
    }

    public int getRowWidth() {
        return 220;
    }

    @Nullable
    public E getSelected() {
        return this.selected;
    }

    public void setSelected(@Nullable E selected) {
        this.selected = selected;
    }

    public E getFirstElement() {
        return this.getEntry(0);
    }

    public final List<E> children() {
        return this.children;
    }

    protected void clearEntries() {
        this.children.clear();
        this.selected = null;
    }

    protected void replaceEntries(Collection<E> collection) {
        this.clearEntries();
        this.children.addAll(collection);
    }

    protected E getEntry(int index) {
        return (E)((Entry)this.children.get(index));
    }

    protected int addEntry(E entry) {
        this.children.add(entry);
        return this.getItemCount() - 1;
    }

    protected void addEntryToTop(E entry) {
        float delta = (float)this.getMaxScroll() - this.getAmountScrolled();
        EntryListPane.jvmdg$inlined$addFirst(this.children, entry);
        this.setAmountScrolled((float)this.getMaxScroll() - delta);
    }

    protected boolean removeEntryFromTop(E entry) {
        float delta = (float)this.getMaxScroll() - this.getAmountScrolled();
        boolean hasRemoved = this.removeEntry(entry);
        this.setAmountScrolled((float)this.getMaxScroll() - delta);
        return hasRemoved;
    }

    protected int getItemCount() {
        return this.children.size();
    }

    protected boolean isSelectedItem(int index) {
        return Objects.equals(this.getSelected(), this.getEntry(index));
    }

    @Nullable
    protected final E getEntryAtPosition(double mouseX, double mouseY) {
        int rowMiddle = this.getRowWidth() / 2;
        int listMiddle = this.getScreenX() + this.getScreenWidth() / 2;
        int left = listMiddle - rowMiddle;
        int right = listMiddle + rowMiddle;
        int yPos = (int)Math.floor(mouseY - (double)this.getScreenY() - (double)this.headerHeight + (double)this.getAmountScrolled() - (double)this.getPadding());
        int index = yPos / this.itemHeight;
        return mouseX >= (double)left && mouseX <= (double)right && index >= 0 && yPos >= 0 && index < this.getItemCount() ? (E)this.getEntry(index) : null;
    }

    public void updateSizeAndPosition(int width, int height, int yPos) {
        this.setScreenWidth(width);
        this.setScreenHeight(height);
        this.setScreenX(0);
        this.setScreenY(yPos);
        this.bindAmountScrolled();
    }

    protected int getMaxPosition() {
        return this.getItemCount() * this.itemHeight + this.headerHeight;
    }

    protected boolean clickedHeader(int posX, int posY) {
        return false;
    }

    protected void renderHeader(Minecraft client, int posX, int posY) {
    }

    protected void renderDecorations(Minecraft client, int posX, int posY) {
    }

    @Override
    public void preRender() {
        super.preRender();
        this.hovered = this.isOverScreen() ? this.getEntryAtPosition(this.getMouseX(), this.getMouseY()) : null;
    }

    @Override
    public void postRender() {
        super.postRender();
        this.renderDecorations(this.getGameInstance(), this.getMouseX(), this.getMouseY());
    }

    @Override
    public void renderExtra() {
        super.renderExtra();
        if (this.renderHeader) {
            int posX = this.getRowLeft();
            int posY = this.getScreenY() + this.getPadding() - (int)this.getAmountScrolled();
            this.renderHeader(this.getGameInstance(), posX, posY);
        }
        this.renderListItems(this.getGameInstance(), this.getMouseX(), this.getMouseY(), this.getPartialTicks());
    }

    @Override
    public void checkScrollbarClick(double mouseX, double mouseY, int button) {
        super.checkScrollbarClick(mouseX, mouseY, button);
        if (this.isLoaded() && this.isOverScreen() && this.isValidMouseClick(button)) {
            E entry = this.getEntryAtPosition(mouseX, mouseY);
            if (entry != null) {
                if (((Entry)entry).mouseClicked(mouseX, mouseY, button)) {
                    this.setSelected(entry);
                    this.setFocused(true);
                }
            } else {
                this.clickedHeader((int)(mouseX - (double)(this.getScreenX() + this.getScreenWidth() / 2 - this.getRowWidth() / 2)), (int)(mouseY - (double)this.getScreenY()) + (int)this.getAmountScrolled() - this.getPadding());
            }
        }
    }

    protected void centerScrollOn(E entry) {
        this.setScroll((float)(this.children().indexOf(entry) * this.itemHeight) + (float)this.itemHeight / 2.0f - (float)this.getScreenHeight() / 2.0f);
    }

    protected void ensureVisible(E entry) {
        int k;
        int rowTop = this.getRowTop(this.children().indexOf(entry));
        int j = rowTop - this.getScreenY() - this.getPadding() - this.itemHeight;
        if (j < 0) {
            this.scrollBy(j);
        }
        if ((k = this.getBottom() - rowTop - this.itemHeight - this.itemHeight) < 0) {
            this.scrollBy(-k);
        }
    }

    @Override
    public int getContentHeight() {
        return this.getMaxPosition();
    }

    @Override
    public int getMaxScroll() {
        return Math.max(0, this.getContentHeight() - (this.getScreenHeight() - this.getPadding()));
    }

    @Override
    public int getScrollBarX() {
        return this.getDefaultScrollbarPosition();
    }

    protected int getDefaultScrollbarPosition() {
        return this.getRealRowRight() + this.getListOutlinePadding();
    }

    private int getListOutlinePadding() {
        return 10;
    }

    @Override
    public int getHeightPerScroll() {
        return this.itemHeight / 2;
    }

    @Override
    protected void func_73869_a(char typedChar, int keyCode) {
        if (keyCode == EntryListPane.getKeyByVersion(208, 264)) {
            this.moveSelection(1);
        } else if (keyCode == EntryListPane.getKeyByVersion(200, 265)) {
            this.moveSelection(-1);
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Nullable
    protected E nextEntry(int direction) {
        return (E)this.nextEntry(direction, entry -> true);
    }

    @Nullable
    protected E nextEntry(int direction, Predicate<E> predicate) {
        return this.nextEntry(direction, predicate, this.getSelected());
    }

    @Nullable
    protected E nextEntry(int direction, Predicate<E> predicate, @Nullable E entry) {
        if (!this.children().isEmpty() && direction != 0) {
            int index = entry == null ? (direction > 0 ? 0 : this.children().size() - 1) : this.children().indexOf(entry) + direction;
            for (int i = index; i >= 0 && i < this.getItemCount(); i += direction) {
                Entry next = (Entry)this.children().get(i);
                if (!predicate.test(next)) continue;
                return (E)next;
            }
        }
        return null;
    }

    protected void moveSelection(int direction) {
        E entry;
        E e = entry = direction != 0 ? this.nextEntry(direction) : this.getSelected();
        if (entry != null) {
            this.setSelected(entry);
            this.ensureVisible(entry);
            this.setFocused(true);
        }
    }

    protected void renderListItems(Minecraft client, int mouseX, int mouseY, float partialTicks) {
        int rowLeft = this.getRowLeft();
        int rowWidth = this.getRowWidth();
        int rowHeight = this.itemHeight - this.getPadding();
        for (int index = 0; index < this.getItemCount(); ++index) {
            int rowTop = this.getRowTop(index);
            int rowBottom = this.getRowBottom(index);
            if (rowBottom < this.getScreenY() || rowTop > this.getBottom()) continue;
            this.renderItem(client, mouseX, mouseY, partialTicks, index, rowLeft, rowTop, rowWidth, rowHeight);
        }
    }

    protected void renderItem(Minecraft client, int mouseX, int mouseY, float partialTicks, int index, int xPos, int yPos, int entryWidth, int entryHeight) {
        E entry = this.getEntry(index);
        ((Entry)entry).renderBack(client, index, yPos, xPos, entryWidth, entryHeight, mouseX, mouseY, Objects.equals(this.getHovered(), entry), partialTicks);
        if (this.isSelectedItem(index)) {
            int outerColor = this.isFocused() ? -1 : -8355712;
            this.renderSelection(client, yPos, entryWidth, entryHeight, outerColor, -16777216);
        }
        ((Entry)entry).render(client, index, yPos, xPos, entryWidth, entryHeight, mouseX, mouseY, Objects.equals(this.getHovered(), entry), partialTicks);
    }

    protected void renderSelection(Minecraft client, int yPos, int width, int height, int outerColor, int innerColor) {
        int left = this.getScreenX() + (this.getScreenWidth() - width) / 2;
        int right = this.getScreenX() + (this.getScreenWidth() + width) / 2;
        RenderUtils.drawGradient(left, right, yPos - 2, yPos + height + 2, 0.0, outerColor, outerColor);
        RenderUtils.drawGradient(left + 1, right - 1, yPos - 1, yPos + height + 1, 0.0, innerColor, innerColor);
    }

    public int getRowLeft() {
        return this.getScreenX() + this.getScreenWidth() / 2 - this.getRowWidth() / 2 + 2;
    }

    private int getRealRowLeft() {
        return this.getScreenX() + this.getScreenWidth() / 2 - this.getRowWidth() / 2;
    }

    public int getRowRight() {
        return this.getRowLeft() + this.getRowWidth();
    }

    private int getRealRowRight() {
        return this.getRealRowLeft() + this.getRowWidth();
    }

    protected int getRowTop(int index) {
        return this.getScreenY() + this.getPadding() - (int)this.getAmountScrolled() + index * this.itemHeight + this.headerHeight;
    }

    protected int getRowBottom(int index) {
        return this.getRowTop(index) + this.itemHeight;
    }

    @Nullable
    protected E remove(int index) {
        E entry = this.getEntry(index);
        return (E)(this.removeEntry(entry) ? entry : null);
    }

    protected boolean removeEntry(E entry) {
        boolean hasRemoved = this.children.remove(entry);
        if (hasRemoved && entry == this.getSelected()) {
            this.setSelected(null);
        }
        return hasRemoved;
    }

    @Nullable
    protected E getHovered() {
        return this.hovered;
    }

    void bindEntryToSelf(Entry<E> entry) {
        entry.list = this;
    }

    @Stub
    private static <E> void jvmdg$inlined$addFirst(List<E> self, E e) {
        self.add(0, e);
    }

    @NestHost(value=EntryListPane.class)
    class TrackedList
    extends AbstractList<E> {
        private final List<E> delegate = StringUtils.newArrayList();

        TrackedList() {
        }

        @Override
        public E get(int index) {
            return (Entry)this.delegate.get(index);
        }

        @Override
        public int size() {
            return this.delegate.size();
        }

        @Override
        public E set(int index, E entry) {
            Entry prevEntry = (Entry)this.delegate.set(index, entry);
            EntryListPane.this.bindEntryToSelf(entry);
            return prevEntry;
        }

        @Override
        public void add(int index, E entry) {
            this.delegate.add(index, entry);
            EntryListPane.this.bindEntryToSelf(entry);
        }

        @Override
        public E remove(int index) {
            return (Entry)this.delegate.remove(index);
        }
    }

    @NestHost(value=EntryListPane.class)
    protected static abstract class Entry<E extends Entry<E>> {
        @Deprecated
        EntryListPane<E> list;

        protected Entry() {
        }

        public abstract void render(Minecraft var1, int var2, int var3, int var4, int var5, int var6, int var7, int var8, boolean var9, float var10);

        public void renderBack(Minecraft client, int index, int yPos, int xPos, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean hovered, float partialTicks) {
        }

        public boolean isMouseOver(double mouseX, double mouseY) {
            return Objects.equals(this.list.getEntryAtPosition(mouseX, mouseY), this);
        }

        public boolean mouseClicked(double mouseX, double mouseY, int button) {
            return true;
        }
    }
}

