/*
 * Decompiled with CFR 0.152.
 */
package serverutils.handlers;

import cpw.mods.fml.common.eventhandler.EventPriority;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.common.network.FMLNetworkEvent;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatList;
import net.minecraft.util.EnumChatFormatting;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.event.entity.player.ItemTooltipEvent;
import serverutils.ServerUtilitiesConfig;
import serverutils.client.ServerUtilitiesClient;
import serverutils.client.ServerUtilitiesClientConfig;
import serverutils.client.gui.GuiClaimedChunks;
import serverutils.client.gui.GuiClientConfig;
import serverutils.client.gui.GuiSidebar;
import serverutils.events.chunks.UpdateClientDataEvent;
import serverutils.events.client.CustomClickEvent;
import serverutils.integration.navigator.NavigatorIntegration;
import serverutils.lib.OtherMods;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.gui.Widget;
import serverutils.lib.icon.IconRenderer;
import serverutils.lib.math.Ticks;
import serverutils.lib.util.InvUtils;
import serverutils.lib.util.NBTUtils;
import serverutils.lib.util.SidedUtils;
import serverutils.lib.util.StringUtils;
import serverutils.net.MessageAdminPanelGui;
import serverutils.net.MessageClaimedChunksUpdate;
import serverutils.net.MessageEditNBTRequest;
import serverutils.net.MessageLeaderboardList;
import serverutils.net.MessageMyTeamGui;

public class ServerUtilitiesClientEventHandler {
    public static final ServerUtilitiesClientEventHandler INST = new ServerUtilitiesClientEventHandler();
    public static boolean shouldRenderIcons = false;
    public static long shutdownTime = 0L;
    private static final List<String> sidebarButtonTooltip = new ArrayList<String>();

    public static void readSyncData(NBTTagCompound nbt) {
        shutdownTime = System.currentTimeMillis() + nbt.func_74763_f("ShutdownTime");
    }

    @SubscribeEvent
    public void onClientDisconnected(FMLNetworkEvent.ClientDisconnectionFromServerEvent event) {
        shutdownTime = 0L;
        SidedUtils.SERVER_MODS.clear();
        if (OtherMods.isNavigatorLoaded()) {
            NavigatorIntegration.CLAIMS.clear();
        }
    }

    @SubscribeEvent
    public void onClientWorldTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (event.phase == TickEvent.Phase.START && mc.field_71441_e != null && mc.field_71441_e.field_73011_w.field_76574_g == ServerUtilitiesConfig.world.spawn_dimension) {
            if (ServerUtilitiesConfig.world.forced_spawn_dimension_time != -1) {
                mc.field_71441_e.func_72877_b((long)ServerUtilitiesConfig.world.forced_spawn_dimension_time);
            }
            if (ServerUtilitiesConfig.world.forced_spawn_dimension_weather != -1) {
                mc.field_71441_e.func_72912_H().func_76084_b(ServerUtilitiesConfig.world.forced_spawn_dimension_weather >= 1);
                mc.field_71441_e.func_72912_H().func_76069_a(ServerUtilitiesConfig.world.forced_spawn_dimension_weather >= 2);
            }
        }
    }

    @SubscribeEvent
    public void onChunkDataUpdate(UpdateClientDataEvent event) {
        MessageClaimedChunksUpdate message = event.getMessage();
        GuiClaimedChunks.onChunkDataUpdate(message);
        if (OtherMods.isNavigatorLoaded()) {
            NavigatorIntegration.onChunkDataUpdate(message);
        }
    }

    @SubscribeEvent
    public void onDebugInfoEvent(RenderGameOverlayEvent.Text event) {
        long timeLeft;
        if (Minecraft.func_71410_x().field_71474_y.field_74330_P) {
            return;
        }
        if (shutdownTime > 0L && ServerUtilitiesClientConfig.show_shutdown_timer && (timeLeft = Math.max(0L, shutdownTime - System.currentTimeMillis())) > 0L && timeLeft <= ServerUtilitiesClientConfig.getShowShutdownTimer()) {
            event.left.add(EnumChatFormatting.DARK_RED + I18n.func_135052_a((String)"serverutilities.lang.timer.shutdown", (Object[])new Object[]{StringUtils.getTimeString(timeLeft)}));
        }
        if (ServerUtilitiesConfig.world.show_playtime) {
            event.left.add(StatList.field_75948_k.func_150951_e().func_150260_c() + ": " + Ticks.get(Minecraft.func_71410_x().field_71439_g.func_146107_m().func_77444_a(StatList.field_75948_k)).toTimeString());
        }
    }

    @SubscribeEvent
    public void onKeyEvent(InputEvent.KeyInputEvent event) {
        if (ServerUtilitiesClient.KEY_NBT.func_151468_f()) {
            MessageEditNBTRequest.editNBT();
        }
        if (ServerUtilitiesClient.KEY_TRASH.func_151468_f()) {
            ClientUtils.execClientCommand("/trash_can");
        }
    }

    @SubscribeEvent
    public void onCustomClick(CustomClickEvent event) {
        if (event.getID().func_110624_b().equals("serverutilities")) {
            switch (event.getID().func_110623_a()) {
                case "client_config_gui": {
                    new GuiClientConfig().openGui();
                    break;
                }
                case "my_team_gui": {
                    new MessageMyTeamGui().sendToServer();
                    break;
                }
                case "admin_panel_gui": {
                    new MessageAdminPanelGui().sendToServer();
                    break;
                }
                case "toggle_gamemode": {
                    ClientUtils.execClientCommand("/gamemode " + (Minecraft.func_71410_x().field_71439_g.field_71075_bZ.field_75098_d ? "survival" : "creative"));
                    break;
                }
                case "daytime": {
                    long addDay = (24000L - Minecraft.func_71410_x().field_71441_e.func_72820_D() % 24000L + (long)ServerUtilitiesClientConfig.button_daytime) % 24000L;
                    if (addDay == 0L) break;
                    ClientUtils.execClientCommand("/time add " + addDay);
                    break;
                }
                case "nighttime": {
                    long addNight = (24000L - Minecraft.func_71410_x().field_71441_e.func_72820_D() % 24000L + (long)ServerUtilitiesClientConfig.button_nighttime) % 24000L;
                    if (addNight == 0L) break;
                    ClientUtils.execClientCommand("/time add " + addNight);
                    break;
                }
                case "claims_gui": {
                    GuiClaimedChunks.instance = new GuiClaimedChunks();
                    GuiClaimedChunks.instance.openGui();
                    break;
                }
                case "leaderboards_gui": {
                    new MessageLeaderboardList().sendToServer();
                }
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public void onTooltip(ItemTooltipEvent event) {
        Set<String> ores;
        if (ServerUtilitiesClientConfig.item_ore_names && !(ores = InvUtils.getOreNames(null, event.itemStack)).isEmpty()) {
            event.toolTip.add(I18n.func_135052_a((String)"serverutilities_client.item_ore_names.item_tooltip", (Object[])new Object[0]));
            for (String or : ores) {
                event.toolTip.add("> " + or);
            }
        }
        if (ServerUtilitiesClientConfig.item_nbt && GuiScreen.func_146272_n()) {
            NBTTagCompound nbt;
            NBTTagCompound nBTTagCompound = nbt = Widget.isAltKeyDown() ? event.itemStack.func_77955_b(new NBTTagCompound()) : event.itemStack.func_77978_p();
            if (nbt != null) {
                event.toolTip.add(NBTUtils.getColoredNBTString((NBTBase)nbt));
            }
        }
    }

    @SubscribeEvent
    public void onGuiInit(GuiScreenEvent.InitGuiEvent.Post event) {
        if (ClientUtils.areButtonsVisible(event.gui)) {
            event.buttonList.add(new GuiSidebar((GuiContainer)event.gui));
        }
    }

    @SubscribeEvent
    public void onClientTick(TickEvent.ClientTickEvent event) {
        if (!ClientUtils.RUN_LATER.isEmpty()) {
            for (Runnable runnable : new ArrayList<Runnable>(ClientUtils.RUN_LATER)) {
                runnable.run();
            }
            ClientUtils.RUN_LATER.clear();
        }
    }

    @SubscribeEvent
    public void onGuiScreenDraw(GuiScreenEvent.DrawScreenEvent.Post event) {
        if (ClientUtils.areButtonsVisible(event.gui)) {
            event.gui.field_146292_n.forEach(button -> {
                if (button instanceof GuiSidebar) {
                    GuiSidebar sidebar = (GuiSidebar)((Object)button);
                    sidebarButtonTooltip.clear();
                    sidebar.addTooltip(sidebarButtonTooltip);
                    event.gui.func_146283_a(sidebarButtonTooltip, event.mouseX, event.mouseY);
                }
            });
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST, receiveCanceled=true)
    public void onRenderTick(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START && shouldRenderIcons) {
            IconRenderer.render();
        }
    }
}

