/*
 * Decompiled with CFR 0.152.
 */
package serverutils.command;

import net.minecraft.block.Block;
import net.minecraft.command.ICommandSender;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.ChunkProviderServer;
import net.minecraftforge.common.DimensionManager;
import serverutils.ServerUtilities;
import serverutils.lib.command.CmdBase;

public class CmdSeekBlock
extends CmdBase {
    private static final int MAX_RESULTS = 100;
    private final String COMMAND_USAGE = "/seek_block <blockID>:<meta | *> [maxResults]";

    public CmdSeekBlock() {
        super("seek_block", CmdBase.Level.OP);
    }

    @Override
    public String func_71518_a(ICommandSender sender) {
        return "/seek_block <blockID>:<meta | *> [maxResults]";
    }

    public void func_71515_b(ICommandSender sender, String[] args) {
        if (args.length == 0 || args.length > 2) {
            String message = "Usage: /seek_block <blockID>:<meta | *> [maxResults]";
            sender.func_145747_a((IChatComponent)new ChatComponentText(message));
            ServerUtilities.LOGGER.info(message);
            return;
        }
        int override_max_results = 100;
        if (args.length == 2) {
            try {
                override_max_results = Math.min(100, Integer.parseInt(args[1]));
            }
            catch (NumberFormatException e) {
                String message = "Invalid max results value. Must be a number.";
                sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + message));
                ServerUtilities.LOGGER.info(message);
                return;
            }
        }
        try {
            String[] parts = args[0].split(":");
            if (parts.length != 2) {
                if (args[0].contains(":")) {
                    String message = "Invalid format. Use /seek_block <blockID>:<meta | *> [maxResults]";
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + message));
                    ServerUtilities.LOGGER.info(message);
                    return;
                }
                parts = new String[]{args[0], "0"};
            }
            int targetBlockID = Integer.parseInt(parts[0]);
            int targetMeta = -1;
            boolean metaWildCard = false;
            if (parts[1].equals("*")) {
                metaWildCard = true;
            } else {
                targetMeta = Integer.parseInt(parts[1]);
            }
            String message = metaWildCard ? "--- Searching for Block ID " + targetBlockID + " with any metadata ---" : "--- Searching for Block ID " + targetBlockID + ":" + targetMeta + " ---";
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + message));
            ServerUtilities.LOGGER.info(message);
            int foundCount = 0;
            Integer[] integerArray = DimensionManager.getIDs();
            int n = integerArray.length;
            for (int i = 0; i < n; ++i) {
                int dimId = integerArray[i];
                WorldServer world = DimensionManager.getWorld((int)dimId);
                if (world == null) continue;
                ChunkProviderServer chunkProvider = (ChunkProviderServer)world.func_72863_F();
                if (!chunkProvider.field_73245_g.isEmpty() || sender instanceof MinecraftServer) {
                    message = "Dimension " + dimId + ":";
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.BLUE + message));
                    ServerUtilities.LOGGER.info(message);
                }
                ScanContext context = new ScanContext((World)world, sender, targetBlockID, targetMeta, dimId, foundCount, override_max_results, metaWildCard);
                for (Chunk chunkObj : chunkProvider.field_73245_g) {
                    if ((foundCount += this.scanChunk(chunkObj, context)) < override_max_results) continue;
                    message = "Search limit reached (" + override_max_results + " results).";
                    sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + message));
                    ServerUtilities.LOGGER.info(message);
                    return;
                }
            }
            message = "Search complete! Found " + foundCount + " matches.";
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + message));
            ServerUtilities.LOGGER.info(message);
        }
        catch (NumberFormatException e) {
            String message = "Invalid number format.";
            sender.func_145747_a((IChatComponent)new ChatComponentText(message));
            ServerUtilities.LOGGER.info(message);
        }
    }

    private int scanChunk(Chunk chunk, ScanContext context) {
        int chunkX = chunk.field_76635_g * 16;
        int chunkZ = chunk.field_76647_h * 16;
        int count = 0;
        for (int x = chunkX; x < chunkX + 16; ++x) {
            for (int z = chunkZ; z < chunkZ + 16; ++z) {
                for (int y = 0; y < context.world.func_72800_K(); ++y) {
                    Block block = chunk.func_150810_a(x & 0xF, y, z & 0xF);
                    int foundBlockID = Block.func_149682_b((Block)block);
                    int foundMeta = context.world.func_72805_g(x, y, z);
                    if (foundBlockID != context.targetBlockID || !context.metaWildCard && foundMeta != context.targetMeta) continue;
                    String message = "Found " + foundBlockID + ":" + foundMeta + " in " + DimensionManager.getProvider((int)context.dimId).func_80007_l() + " (Dim ID: " + context.dimId + ") at (" + x + ", " + y + ", " + z + ")";
                    ServerUtilities.LOGGER.info(message);
                    context.sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.GOLD + message));
                    if (context.foundCount + ++count < context.overrideMaxResults) continue;
                    return count;
                }
            }
        }
        return count;
    }

    private static class ScanContext {
        World world;
        ICommandSender sender;
        int targetBlockID;
        int targetMeta;
        int dimId;
        int foundCount;
        int overrideMaxResults;
        boolean metaWildCard;

        ScanContext(World world, ICommandSender sender, int targetBlockID, int targetMeta, int dimId, int foundCount, int overrideMaxResults, boolean metaWildCard) {
            this.world = world;
            this.sender = sender;
            this.targetBlockID = targetBlockID;
            this.targetMeta = targetMeta;
            this.dimId = dimId;
            this.foundCount = foundCount;
            this.overrideMaxResults = overrideMaxResults;
            this.metaWildCard = metaWildCard;
        }
    }
}

