/*
 * Decompiled with CFR 0.152.
 */
package serverutils.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.world.World;
import serverutils.client.gui.ThreadReloadChunkSelector;
import serverutils.lib.client.ClientUtils;
import serverutils.lib.client.GlStateManager;
import serverutils.lib.gui.GuiBase;
import serverutils.lib.gui.GuiHelper;
import serverutils.lib.gui.misc.ChunkSelectorMap;
import serverutils.lib.icon.Color4I;
import serverutils.lib.icon.Icon;
import serverutils.lib.math.MathUtils;

public class BuiltinChunkMap
extends ChunkSelectorMap {
    public static final Icon TEX_ENTITY = Icon.getIcon("serverutilities:textures/gui/entity.png").withColor(Color4I.WHITE.withAlpha(140));
    public static final double UV = 0.9375;

    @Override
    public void resetMap(int startX, int startZ) {
        ThreadReloadChunkSelector.reloadArea((World)Minecraft.func_71410_x().field_71441_e, startX, startZ);
    }

    @Override
    public void drawMap(GuiBase gui, int ax, int ay, int startX, int startZ) {
        ThreadReloadChunkSelector.updateTexture();
        GlStateManager.enableTexture2D();
        GlStateManager.bindTexture(ThreadReloadChunkSelector.getTextureId());
        GuiHelper.drawTexturedRect(ax, ay, 180, 180, Color4I.WHITE, 0.0, 0.0, 0.9375, 0.9375);
        EntityClientPlayerMP player = Minecraft.func_71410_x().field_71439_g;
        int cx = MathUtils.chunk(player.field_70165_t);
        int cy = MathUtils.chunk(player.field_70161_v);
        if (cx >= startX && cy >= startZ && cx < startX + 15 && cy < startZ + 15) {
            double x = (double)(cx - startX) * 16.0 + MathUtils.mod(player.field_70165_t, 16.0);
            double y = (double)(cy - startZ) * 16.0 + MathUtils.mod(player.field_70161_v, 16.0);
            GlStateManager.pushMatrix();
            GlStateManager.translate((double)ax + x * 12.0 / 16.0, (double)ay + y * 12.0 / 16.0, 0.0);
            GlStateManager.pushMatrix();
            GlStateManager.rotate(player.field_70177_z + 180.0f, 0.0f, 0.0f, 1.0f);
            TEX_ENTITY.draw(-8, -8, 16, 16);
            GlStateManager.popMatrix();
            ClientUtils.localPlayerHead.draw(-2, -2, 4, 4);
            GlStateManager.popMatrix();
        }
    }
}

