/*
 * Decompiled with CFR 0.152.
 */
package openblocks.api;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.event.entity.player.PlayerEvent;

public class InventoryEvent
extends PlayerEvent {
    protected final Map<String, SubInventory> subInventories;

    protected InventoryEvent(EntityPlayer player, Map<String, SubInventory> subInventories) {
        super(player);
        this.subInventories = subInventories;
    }

    public Map<String, SubInventory> getSubInventories() {
        return ImmutableMap.copyOf(this.subInventories);
    }

    public static class Load
    extends InventoryEvent {
        public Load(EntityPlayer player, Map<String, SubInventory> subInventories) {
            super(player, (Map<String, SubInventory>)ImmutableMap.copyOf(subInventories));
        }

        public SubInventory getSubInventory(String id) {
            return (SubInventory)this.subInventories.get(id);
        }
    }

    public static class Store
    extends InventoryEvent {
        public Store(EntityPlayer player) {
            super(player, new HashMap<String, SubInventory>());
        }

        public SubInventory createSubInventory(String id) {
            SubInventory result = new SubInventory();
            SubInventory prev = this.subInventories.put(id, result);
            Preconditions.checkState((prev == null ? 1 : 0) != 0, (String)"Sub inventory with id %s already exists", (Object[])new Object[]{id});
            return result;
        }
    }

    public static class SubInventory {
        private final Map<Integer, ItemStack> slots = Maps.newHashMap();

        public SubInventory addItemStack(int slot, ItemStack stack) {
            this.slots.put(slot, stack);
            return this;
        }

        public ItemStack getItemStack(int slot) {
            return this.slots.get(slot);
        }

        public Map<Integer, ItemStack> asMap() {
            return ImmutableMap.copyOf(this.slots);
        }
    }
}

