/*
 * Decompiled with CFR 0.152.
 */
package journeymap.client.properties;

import com.google.common.io.Files;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import journeymap.client.Constants;
import journeymap.client.io.FileHandler;
import journeymap.client.log.LogFormatter;
import journeymap.client.properties.config.AtomicBooleanSerializer;
import journeymap.client.properties.config.AtomicIntegerSerializer;
import journeymap.client.properties.config.AtomicReferenceSerializer;
import journeymap.client.properties.config.ConfigValidation;
import journeymap.common.Journeymap;
import journeymap.common.version.Version;

public abstract class PropertiesBase {
    protected static final Charset UTF8 = Charset.forName("UTF-8");
    protected static final transient AtomicBoolean configFormatChanged = new AtomicBoolean(false);
    private static final String[] HEADERS = new String[]{"// " + Constants.getString("jm.config.file_header_1"), "// " + Constants.getString("jm.config.file_header_2", Constants.CONFIG_DIR), "// " + Constants.getString("jm.config.file_header_5", "http://journeymap.info/help/wiki/Options_Manager")};
    protected final transient Gson gson = new GsonBuilder().setPrettyPrinting().registerTypeAdapter(AtomicBoolean.class, (Object)new AtomicBooleanSerializer(configFormatChanged)).registerTypeAdapter(AtomicInteger.class, (Object)new AtomicIntegerSerializer(configFormatChanged)).registerTypeAdapter(AtomicReference.class, (Object)new AtomicReferenceSerializer(configFormatChanged)).create();
    protected final AtomicBoolean disabled = new AtomicBoolean(false);
    protected Version configVersion = null;
    protected transient File sourceFile = null;

    protected PropertiesBase() {
    }

    public static <T extends PropertiesBase> T reload(T properties, Class<T> propertiesClass) {
        if (properties != null) {
            properties.save();
        }
        PropertiesBase reloadedProperties = null;
        try {
            boolean sourceChanged;
            reloadedProperties = (PropertiesBase)((PropertiesBase)propertiesClass.newInstance()).load();
            boolean bl = sourceChanged = properties == null || properties.isWorldConfig() != reloadedProperties.isWorldConfig();
            if (sourceChanged) {
                Journeymap.getLogger().info("Loaded " + propertiesClass.getSimpleName() + " from " + reloadedProperties.getFile());
            }
            return (T)reloadedProperties;
        }
        catch (Throwable t) {
            Journeymap.getLogger().error("Failed to reload " + propertiesClass.getName() + ": " + LogFormatter.toString(t));
            return (T)(properties != null ? properties : reloadedProperties);
        }
    }

    public String toJsonString() {
        return this.gson.toJson((Object)this);
    }

    public abstract String getName();

    public File getFile() {
        if (this.sourceFile == null) {
            this.sourceFile = new File(FileHandler.getWorldConfigDir(false), this.getFileName());
            if (!this.sourceFile.canRead()) {
                this.sourceFile = new File(FileHandler.StandardConfigDirectory, this.getFileName());
            }
        }
        return this.sourceFile;
    }

    protected String getFileName() {
        return String.format("journeymap.%s.config", this.getName());
    }

    public boolean isWorldConfig() {
        File worldConfigDir = FileHandler.getWorldConfigDir(false);
        return worldConfigDir != null && worldConfigDir.equals(this.getFile().getParentFile());
    }

    public boolean isDisabled() {
        return this.disabled.get();
    }

    public void setDisabled(boolean disable) {
        if (!this.isWorldConfig()) {
            throw new IllegalStateException("Can't disable standard config.");
        }
        this.disabled.set(disable);
        this.save();
    }

    public boolean copyToWorldConfig(boolean overwrite) {
        if (!this.isWorldConfig()) {
            try {
                File worldConfig = this.getFile();
                if (overwrite || !worldConfig.exists()) {
                    this.save();
                    Files.copy((File)this.sourceFile, (File)worldConfig);
                    return worldConfig.canRead();
                }
            }
            catch (IOException e) {
                Journeymap.getLogger().error("Couldn't copy config to world config: " + LogFormatter.toString(e));
            }
            return false;
        }
        throw new IllegalStateException("Can't create World config from itself.");
    }

    public boolean copyToStandardConfig() {
        if (this.isWorldConfig()) {
            try {
                this.save();
                File standardConfig = new File(FileHandler.StandardConfigDirectory, this.getFileName());
                Files.copy((File)this.sourceFile, (File)standardConfig);
                return standardConfig.canRead();
            }
            catch (IOException e) {
                Journeymap.getLogger().error("Couldn't copy config to world config: " + LogFormatter.toString(e));
                return false;
            }
        }
        throw new IllegalStateException("Can't replace standard config with itself.");
    }

    public boolean isCurrent() {
        return Journeymap.JM_VERSION.equals(this.configVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean save() {
        Gson gson = this.gson;
        synchronized (gson) {
            File propFile = null;
            try {
                propFile = this.getFile();
                if (!propFile.exists()) {
                    Journeymap.getLogger().info(String.format("Creating config file: %s", propFile));
                    if (!propFile.getParentFile().exists()) {
                        propFile.getParentFile().mkdirs();
                    }
                } else if (!this.isCurrent()) {
                    Journeymap.getLogger().info(String.format("Updating config file from version \"%s\" to \"%s\": %s", this.configVersion, Journeymap.JM_VERSION, propFile));
                    this.configVersion = Journeymap.JM_VERSION;
                }
                String lineEnding = System.getProperty("line.separator");
                StringBuilder sb = new StringBuilder();
                for (String line : HEADERS) {
                    sb.append(line).append(lineEnding);
                }
                String header = sb.toString();
                String json = this.gson.toJson((Object)this);
                Files.write((CharSequence)(header + json), (File)propFile, (Charset)UTF8);
                Journeymap.getLogger().debug("Saved " + this.getFileName());
                return true;
            }
            catch (Exception e) {
                Journeymap.getLogger().error(String.format("Can't save config file %s: %s", propFile, LogFormatter.toString(e)));
                return false;
            }
        }
    }

    public boolean toggle(AtomicBoolean ab) {
        ab.set(!ab.get());
        this.save();
        return ab.get();
    }

    public <T extends PropertiesBase> T load() {
        PropertiesBase instance = this;
        File propFile = this.getFile();
        boolean saveNeeded = true;
        try {
            if (propFile.canRead()) {
                instance = (PropertiesBase)this.gson.fromJson(Files.toString((File)propFile, (Charset)UTF8), this.getClass());
                boolean bl = saveNeeded = !instance.isCurrent();
                if (saveNeeded) {
                    Journeymap.getLogger().info(String.format("Config file needs to be updated: %s", propFile.getName()));
                }
            } else {
                instance.newFileInit();
            }
        }
        catch (Exception e) {
            Journeymap.getLogger().error(String.format("Can't load config file %s: %s", propFile, e.getMessage()));
            try {
                File badPropFile = new File(propFile.getParentFile(), propFile.getName() + ".bad");
                propFile.renameTo(badPropFile);
            }
            catch (Exception e3) {
                Journeymap.getLogger().error(String.format("Can't rename config file %s: %s", propFile, e3.getMessage()));
            }
        }
        if (instance == null) {
            try {
                instance = (PropertiesBase)this.getClass().newInstance();
                instance.newFileInit();
                saveNeeded = true;
            }
            catch (Exception e) {
                throw new RuntimeException("Config file corrupted.  Please fix or remove: " + propFile);
            }
        }
        if (instance != null && (instance.validate() || saveNeeded)) {
            instance.save();
        }
        return (T)instance;
    }

    protected void newFileInit() {
    }

    protected boolean validate() {
        boolean saveNeeded = this.validateConfigs();
        if (!this.isWorldConfig() && this.isDisabled()) {
            this.disabled.set(false);
            saveNeeded = true;
        }
        if (configFormatChanged.get()) {
            saveNeeded = true;
            configFormatChanged.set(false);
            Journeymap.getLogger().info("File format will be updated for " + this.getFileName());
        }
        return saveNeeded;
    }

    protected boolean validateConfigs() {
        return ConfigValidation.validateConfigs(this);
    }

    public void ensureValid() {
        this.validate();
        this.save();
    }
}

