/*
 * Decompiled with CFR 0.152.
 */
package com.gtnh.findit.fx;

import com.gtnh.findit.fx.FxHelper;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityClientPlayerMP;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.util.MathHelper;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import org.lwjgl.opengl.GL11;

public class EntityHighlighter {
    private List<Integer> entityIds = new ArrayList<Integer>();
    private long expireHighlight;

    public void highlightEntities(List<Integer> entityIds, long expireHighlight) {
        this.entityIds = entityIds;
        this.expireHighlight = expireHighlight;
    }

    public void renderHighlightedEntities(RenderWorldLastEvent event) {
        if (this.entityIds.isEmpty()) {
            return;
        }
        Minecraft mc = Minecraft.func_71410_x();
        RenderItem renderItem = RenderItem.getInstance();
        long time = System.currentTimeMillis();
        if ((time / 500L & 1L) == 0L) {
            return;
        }
        if (time > this.expireHighlight) {
            this.entityIds.clear();
        }
        EntityClientPlayerMP p = mc.field_71439_g;
        double doubleX = p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)event.partialTicks;
        double doubleY = p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)event.partialTicks;
        double doubleZ = p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)event.partialTicks;
        GL11.glPushMatrix();
        GL11.glPushAttrib((int)1048575);
        GL11.glLineWidth((float)3.0f);
        GL11.glTranslated((double)(-doubleX), (double)(-doubleY), (double)(-doubleZ));
        GL11.glDisable((int)2929);
        GL11.glDisable((int)3553);
        GL11.glColor4f((float)0.75f, (float)0.0f, (float)1.0f, (float)1.0f);
        for (int entityId : this.entityIds) {
            Entity entity = mc.field_71441_e.func_73045_a(entityId);
            if (entity == null) continue;
            float scale = 1.0f;
            if (entity instanceof EntityItem) {
                EntityItem item = (EntityItem)entity;
                GL11.glPushMatrix();
                double itemX = item.field_70142_S + (item.field_70165_t - item.field_70142_S) * (double)event.partialTicks;
                double itemY = item.field_70137_T + (item.field_70163_u - item.field_70137_T) * (double)event.partialTicks;
                double itemZ = item.field_70136_U + (item.field_70161_v - item.field_70136_U) * (double)event.partialTicks;
                float age = (float)item.field_70292_b + event.partialTicks;
                float elevation = renderItem.shouldBob() ? MathHelper.func_76126_a((float)(age / 10.0f + item.field_70290_d)) * 0.1f + 0.1f : 0.0f;
                float angle = (age / 20.0f + item.field_70290_d) * 57.295776f;
                GL11.glTranslated((double)itemX, (double)itemY, (double)itemZ);
                GL11.glRotated((double)angle, (double)0.0, (double)1.0, (double)0.0);
                GL11.glTranslated((double)(-itemX), (double)(-itemY + (double)elevation), (double)(-itemZ));
                scale = 1.2f;
            }
            FxHelper.renderEntityOutline(entity, scale, event.partialTicks);
            if (!(entity instanceof EntityItem)) continue;
            GL11.glPopMatrix();
        }
        GL11.glPopAttrib();
        GL11.glPopMatrix();
    }
}

