/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.armor;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.block.BlockDispenser;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.dispenser.IBehaviorDispenseItem;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemArmor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.ISpecialArmor;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.armor.ArmorPart;
import tconstruct.library.armor.BehaviorDispenseArmorCopy;
import tconstruct.library.modifier.ActiveArmorMod;
import tconstruct.library.modifier.IModifyable;
import tconstruct.library.tools.ToolCore;
import tconstruct.tools.entity.FancyEntityItem;

public abstract class ArmorCore
extends ItemArmor
implements ISpecialArmor,
IModifyable {
    public final ArmorPart armorPart;
    private static final IBehaviorDispenseItem dispenserBehavior = new BehaviorDispenseArmorCopy();
    public final int baseProtection;
    protected final String modifyType;
    protected final String textureFolder;
    protected final String textureName;
    @SideOnly(value=Side.CLIENT)
    protected IIcon[] modifiers;
    private final DecimalFormat df = new DecimalFormat("##.#");

    public ArmorCore(int baseProtection, ArmorPart part, String type, String textureFolder, String textureName) {
        super(ItemArmor.ArmorMaterial.CHAIN, 0, part.getPartId());
        this.field_77777_bU = 1;
        this.func_77656_e(100);
        this.armorPart = part;
        this.baseProtection = baseProtection;
        this.modifyType = type;
        this.textureFolder = textureFolder;
        this.textureName = textureName;
        BlockDispenser.field_149943_a.func_82595_a((Object)this, (Object)dispenserBehavior);
        this.func_77637_a(TConstructRegistry.equipableTab);
    }

    public ArmorCore(int baseProtection, ArmorPart part, String type, String textureName) {
        this(baseProtection, part, type, "armor", textureName);
    }

    public abstract ItemStack getRepairMaterial(ItemStack var1);

    public String getArmorName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public String getBaseTagName() {
        return "TinkerArmor";
    }

    @Override
    public String getModifyType() {
        return this.modifyType;
    }

    @Override
    public String[] getTraits() {
        return new String[]{"armor"};
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        int i = EntityLiving.func_82159_b((ItemStack)stack) - 1;
        ItemStack itemstack1 = player.func_82169_q(i);
        if (itemstack1 == null) {
            player.func_70062_b(i + 1, stack.func_77946_l());
            stack.field_77994_a = 0;
        }
        return stack;
    }

    public void onArmorTick(World world, EntityPlayer player, ItemStack itemStack) {
        for (ActiveArmorMod mod : TConstructRegistry.activeArmorModifiers) {
            mod.onArmorTick(world, player, itemStack, this, this.armorPart);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public String getArmorTexture(ItemStack stack, Entity entity, int slot, String type) {
        if (slot == 2) {
            return "tinker:textures/armor/" + this.textureName + "_" + 2 + ".png";
        }
        return "tinker:textures/armor/" + this.textureName + "_" + 1 + ".png";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a("tinker:" + this.textureFolder + "/" + this.textureName + (this.field_77881_a == 0 ? "helmet" : (this.field_77881_a == 1 ? "chestplate" : (this.field_77881_a == 2 ? "pants" : (this.field_77881_a == 3 ? "boots" : "helmet")))));
        this.registerModifiers(iconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        if (renderPass > 0) {
            if (stack.func_77942_o()) {
                NBTTagCompound tags = stack.func_77978_p().func_74775_l(this.getBaseTagName());
                if (renderPass == 1 && tags.func_74764_b("Effect1")) {
                    return this.modifiers[tags.func_74762_e("Effect1")];
                }
                if (renderPass == 2 && tags.func_74764_b("Effect2")) {
                    return this.modifiers[tags.func_74762_e("Effect2")];
                }
                if (renderPass == 3 && tags.func_74764_b("Effect3")) {
                    return this.modifiers[tags.func_74762_e("Effect3")];
                }
            }
            return ToolCore.blankSprite;
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    protected void registerModifiers(IIconRegister iconRegister) {
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 4;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77636_d(ItemStack par1ItemStack) {
        return false;
    }

    public ISpecialArmor.ArmorProperties getProperties(EntityLivingBase player, ItemStack armor, DamageSource source, double damage, int slot) {
        if (!armor.func_77942_o() || source.func_76363_c()) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        NBTTagCompound tags = armor.func_77978_p().func_74775_l(this.getBaseTagName());
        if (tags.func_74767_n("Broken")) {
            return new ISpecialArmor.ArmorProperties(0, 0.0, 0);
        }
        double current = this.getProtection(tags);
        return new ISpecialArmor.ArmorProperties(0, current / 100.0, 100);
    }

    public double getProtection(ItemStack stack) {
        return this.getProtection(stack.func_77978_p().func_74775_l(this.getBaseTagName()));
    }

    public double getProtection(NBTTagCompound tags) {
        float maxDurability = tags.func_74762_e("TotalDurability");
        float currentDurability = maxDurability - (float)tags.func_74762_e("Damage");
        float ratio = currentDurability / maxDurability;
        double base = tags.func_74769_h("BaseDefense");
        double max = tags.func_74769_h("MaxDefense");
        return (max - base) * (double)ratio + base;
    }

    public int getArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (slot != 1) {
            ItemStack stack = player.func_82169_q(1);
            if (stack != null && stack.func_77973_b() instanceof ArmorCore) {
                return 0;
            }
            return this.disconnectedArmorDisplay(player, armor, slot);
        }
        return this.combinedArmorDisplay(player, armor);
    }

    protected int disconnectedArmorDisplay(EntityPlayer player, ItemStack armor, int slot) {
        if (!armor.func_77942_o()) {
            return 0;
        }
        NBTTagCompound armorTag = armor.func_77978_p().func_74775_l(this.getBaseTagName());
        if (armorTag.func_74767_n("Broken")) {
            return 0;
        }
        float max = armorTag.func_74762_e("TotalDurability");
        float current = max - (float)armorTag.func_74762_e("Damage");
        float amount = current / max * 5.0f + 0.09f;
        if (slot == 2 && amount < 1.0f) {
            amount = 1.0f;
        }
        return (int)amount;
    }

    protected int combinedArmorDisplay(EntityPlayer player, ItemStack legs) {
        boolean minimum;
        ItemStack[] armors = new ItemStack[]{player.func_82169_q(3), player.func_82169_q(2), legs, player.func_82169_q(0)};
        int types = 0;
        int max = 0;
        int damage = 0;
        boolean anyAlive = false;
        for (int i = 0; i < 4; ++i) {
            ItemStack stack = armors[i];
            if (stack == null || !stack.func_77942_o()) continue;
            NBTTagCompound armorTag = stack.func_77978_p().func_74775_l(this.getBaseTagName());
            if (!(stack.func_77973_b() instanceof ArmorCore)) continue;
            ++types;
            max += armorTag.func_74762_e("TotalDurability");
            if (armorTag.func_74767_n("Broken")) {
                damage += armorTag.func_74762_e("TotalDurability");
                continue;
            }
            damage += armorTag.func_74762_e("Damage");
            anyAlive = true;
        }
        float ratio = ((float)max - (float)damage) / (float)max * (float)(types * 5) + 0.1f;
        boolean bl = minimum = anyAlive;
        if (ratio < (float)minimum) {
            ratio = (float)minimum;
        }
        return (int)ratio;
    }

    public void damageArmor(EntityLivingBase entity, ItemStack armor, DamageSource source, int damage, int slot) {
        NBTTagCompound tags;
        if (armor.func_77942_o() && !(tags = armor.func_77978_p().func_74775_l(this.getBaseTagName())).func_74767_n("Broken")) {
            int maxDurability = tags.func_74762_e("TotalDurability");
            int currentDurability = tags.func_74762_e("Damage");
            if (currentDurability + damage > maxDurability) {
                tags.func_74768_a("Damage", maxDurability);
                tags.func_74757_a("Broken", true);
                armor.func_77964_b(0);
                entity.field_70170_p.func_72980_b(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, "random.break", 1.0f, 1.0f, true);
            } else {
                tags.func_74768_a("Damage", currentDurability + damage);
                armor.func_77964_b(currentDurability + damage);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List par3List) {
        par3List.add(this.getDefaultItem());
    }

    public ItemStack getDefaultItem() {
        ItemStack gear = new ItemStack((Item)this, 1, 0);
        NBTTagCompound baseTag = new NBTTagCompound();
        NBTTagCompound tag = new NBTTagCompound();
        tag.func_74768_a("Modifiers", 3);
        double flat = this.getFlatDefense();
        double base = this.getBaseDefense();
        double max = this.getMaxDefense();
        tag.func_74780_a("DamageReduction", flat);
        tag.func_74780_a("BaseDefense", base);
        tag.func_74780_a("MaxDefense", max);
        int baseDurability = this.getDurability();
        tag.func_74768_a("Damage", 0);
        tag.func_74768_a("TotalDurability", baseDurability);
        tag.func_74768_a("BaseDurability", baseDurability);
        tag.func_74768_a("BonusDurability", 0);
        tag.func_74776_a("ModDurability", 0.0f);
        tag.func_74757_a("Broken", false);
        tag.func_74757_a("Built", true);
        baseTag.func_74782_a(this.getBaseTagName(), (NBTBase)tag);
        gear.func_77982_d(baseTag);
        return gear;
    }

    protected double getFlatDefense() {
        return 0.0;
    }

    protected abstract double getBaseDefense();

    protected abstract double getMaxDefense();

    protected abstract int getDurability();

    public boolean func_77616_k(ItemStack par1ItemStack) {
        return false;
    }

    public boolean func_82789_a(ItemStack par1ItemStack, ItemStack par2ItemStack) {
        return false;
    }

    public boolean isRepairable() {
        return false;
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_77662_d() {
        return true;
    }

    public boolean isValidArmor(ItemStack stack, int armorType, Entity entity) {
        return this.armorPart.getPartId() == armorType;
    }

    public int getItemMaxDamageFromStack(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            return 0;
        }
        return tags.func_74775_l(this.getBaseTagName()).func_74762_e("TotalDurability");
    }

    public int getItemMaxDamageFromStackForDisplay(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p();
        if (tags == null) {
            return 0;
        }
        return tags.func_74775_l(this.getBaseTagName()).func_74762_e("Damage");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        if (!stack.func_77942_o()) {
            return;
        }
        NBTTagCompound tags = stack.func_77978_p().func_74775_l(this.getBaseTagName());
        double protection = 0.0;
        if (!tags.func_74767_n("Broken")) {
            protection = this.getProtection(tags);
        }
        if (protection > 0.0) {
            list.add("\u00a77" + StatCollector.func_74838_a((String)"armor.core.protection") + this.df.format(protection) + "%");
        } else {
            list.add("\u00a7o" + StatCollector.func_74838_a((String)"armor.core.broken"));
        }
        boolean displayToolTips = true;
        int tipNum = 0;
        while (displayToolTips) {
            String tooltip = "Tooltip" + ++tipNum;
            if (tags.func_74764_b(tooltip)) {
                String tipName = tags.func_74779_i(tooltip);
                String locString = "modifier.tooltip." + EnumChatFormatting.func_110646_a((String)tipName);
                if (StatCollector.func_94522_b((String)(locString = locString.replace(" ", "")))) {
                    tipName = tipName.replace(EnumChatFormatting.func_110646_a((String)tipName), StatCollector.func_74838_a((String)locString));
                }
                if (tipName.equals("")) continue;
                list.add(tipName);
                continue;
            }
            displayToolTips = false;
        }
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new FancyEntityItem(world, location, itemstack);
    }
}

