/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.modularui.api;

import com.gtnewhorizons.modularui.config.Config;
import java.math.RoundingMode;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class NumberFormatMUI
extends NumberFormat {
    protected DecimalFormat baseFormat;
    protected Locale currentLocale;
    protected static final FieldPosition unusedFieldPosition = new FieldPosition(0);
    public static final char[] SUFFIXES = new char[]{'k', 'M', 'G', 'T', 'P', 'E'};
    private boolean minimumIntegerDigitsChanged = false;
    private boolean maximumIntegerDigitsChanged = false;
    private boolean minimumFractionDigitsChanged = false;
    private boolean maximumFractionDigitsChanged = false;
    private boolean groupingUsedChanged = false;
    private boolean parseIntegerOnlyChanged = false;
    protected RoundingMode roundingMode;
    private boolean roundingModeChanged = false;

    public NumberFormatMUI() {
        this.refreshBaseFormat();
    }

    protected void refreshBaseFormat() {
        this.currentLocale = Config.locale;
        NumberFormat nf = NumberFormat.getNumberInstance(this.currentLocale);
        this.baseFormat = nf instanceof DecimalFormat ? (DecimalFormat)nf : (DecimalFormat)NumberFormat.getNumberInstance(Locale.US);
        DecimalFormatSymbols dfs = this.baseFormat.getDecimalFormatSymbols();
        if (dfs.getGroupingSeparator() == '\u00a0' || dfs.getGroupingSeparator() == '\u202f') {
            dfs.setGroupingSeparator(' ');
            this.baseFormat.setDecimalFormatSymbols(dfs);
        }
        if (this.minimumIntegerDigitsChanged) {
            this.baseFormat.setMinimumIntegerDigits(this.getMinimumIntegerDigits());
        }
        if (this.maximumIntegerDigitsChanged) {
            this.baseFormat.setMaximumIntegerDigits(this.getMaximumIntegerDigits());
        }
        if (this.minimumFractionDigitsChanged) {
            this.baseFormat.setMinimumFractionDigits(this.getMinimumFractionDigits());
        }
        if (this.maximumFractionDigitsChanged) {
            this.baseFormat.setMaximumFractionDigits(this.getMaximumFractionDigits());
        }
        if (this.groupingUsedChanged) {
            this.baseFormat.setGroupingUsed(this.isGroupingUsed());
        }
        if (this.parseIntegerOnlyChanged) {
            this.baseFormat.setParseIntegerOnly(this.isParseIntegerOnly());
        }
        if (this.roundingModeChanged) {
            this.baseFormat.setRoundingMode(this.getRoundingMode());
        }
    }

    public StringBuffer format(double number, StringBuffer toAppendTo) {
        if (this.currentLocale != Config.locale) {
            this.refreshBaseFormat();
        }
        return this.baseFormat.format(number, toAppendTo, unusedFieldPosition);
    }

    @Override
    public StringBuffer format(double number, StringBuffer toAppendTo, FieldPosition pos) {
        if (this.currentLocale != Config.locale) {
            this.refreshBaseFormat();
        }
        return this.baseFormat.format(number, toAppendTo, pos);
    }

    public StringBuffer format(long number, StringBuffer toAppendTo) {
        if (this.currentLocale != Config.locale) {
            this.refreshBaseFormat();
        }
        return this.baseFormat.format(number, toAppendTo, unusedFieldPosition);
    }

    @Override
    public StringBuffer format(long number, StringBuffer toAppendTo, FieldPosition pos) {
        if (this.currentLocale != Config.locale) {
            this.refreshBaseFormat();
        }
        return this.baseFormat.format(number, toAppendTo, pos);
    }

    public StringBuffer format(Object number, StringBuffer toAppendTo) {
        if (this.currentLocale != Config.locale) {
            this.refreshBaseFormat();
        }
        return this.baseFormat.format(number, toAppendTo, unusedFieldPosition);
    }

    @Override
    public StringBuffer format(Object number, StringBuffer toAppendTo, FieldPosition pos) {
        if (this.currentLocale != Config.locale) {
            this.refreshBaseFormat();
        }
        return this.baseFormat.format(number, toAppendTo, pos);
    }

    public String formatWithSuffix(long number) {
        return this.formatWithSuffix(number, new StringBuffer()).toString();
    }

    public StringBuffer formatWithSuffix(long number, StringBuffer toAppendTo) {
        if (-10000L < number && number < 10000L) {
            return this.format(number, toAppendTo, unusedFieldPosition);
        }
        for (int order = 0; order < SUFFIXES.length; ++order) {
            if (-10000L < number && number < 10000L) {
                return this.format((double)(number / 100L) / 10.0, toAppendTo, unusedFieldPosition).append(SUFFIXES[order]);
            }
            if (-1000000L < number && number < 1000000L) {
                return this.format(number / 1000L, toAppendTo, unusedFieldPosition).append(SUFFIXES[order]);
            }
            number /= 1000L;
        }
        return this.format(number / 1000L, toAppendTo, unusedFieldPosition).append(SUFFIXES[SUFFIXES.length - 1]);
    }

    @Override
    public Number parse(String source, ParsePosition parsePosition) {
        if (this.currentLocale != Config.locale) {
            this.refreshBaseFormat();
        }
        return this.baseFormat.parse(source, parsePosition);
    }

    @Override
    public void setMinimumIntegerDigits(int newValue) {
        super.setMinimumIntegerDigits(newValue);
        this.baseFormat.setMinimumIntegerDigits(this.getMinimumIntegerDigits());
        this.minimumIntegerDigitsChanged = true;
    }

    @Override
    public void setMaximumIntegerDigits(int newValue) {
        super.setMaximumIntegerDigits(newValue);
        this.baseFormat.setMaximumIntegerDigits(this.getMaximumIntegerDigits());
        this.maximumIntegerDigitsChanged = true;
    }

    @Override
    public void setMinimumFractionDigits(int newValue) {
        super.setMinimumFractionDigits(newValue);
        this.baseFormat.setMinimumFractionDigits(this.getMinimumFractionDigits());
        this.minimumFractionDigitsChanged = true;
    }

    @Override
    public void setMaximumFractionDigits(int newValue) {
        super.setMaximumFractionDigits(newValue);
        this.baseFormat.setMaximumFractionDigits(this.getMaximumFractionDigits());
        this.maximumFractionDigitsChanged = true;
    }

    @Override
    public void setGroupingUsed(boolean newValue) {
        super.setGroupingUsed(newValue);
        this.baseFormat.setGroupingUsed(this.isGroupingUsed());
        this.groupingUsedChanged = true;
    }

    @Override
    public void setParseIntegerOnly(boolean value) {
        super.setParseIntegerOnly(value);
        this.baseFormat.setParseIntegerOnly(this.isParseIntegerOnly());
        this.parseIntegerOnlyChanged = true;
    }

    @Override
    public void setRoundingMode(RoundingMode roundingMode) {
        this.roundingMode = roundingMode;
        this.baseFormat.setRoundingMode(roundingMode);
        this.roundingModeChanged = true;
    }

    @Override
    public RoundingMode getRoundingMode() {
        return this.roundingMode;
    }

    @Override
    public Object clone() {
        NumberFormatMUI other = (NumberFormatMUI)super.clone();
        other.baseFormat = (DecimalFormat)this.baseFormat.clone();
        return other;
    }
}

