/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.libmc.fx;

import codechicken.lib.vec.Vector3;
import mrtjp.core.math.MathLib;
import mrtjp.projectred.core.libmc.fx.ParticleLogic;
import net.minecraft.entity.Entity;

public class ParticleLogicArcToEntity
extends ParticleLogic {
    private Vector3 start;
    private Entity target;
    private Vector3 firstControl;
    private Vector3 secondControl;
    private float percent;
    private float speed;
    private float offsetFactor;
    private float halfOffsetFactor;

    public ParticleLogicArcToEntity(Vector3 start2, Entity target) {
        this.start = start2.copy();
        this.percent = 0.0f;
        this.speed = 0.03f;
        this.offsetFactor = 10.0f;
        this.halfOffsetFactor = this.offsetFactor / 2.0f;
        this.target = target;
        this.generateControlPoints();
    }

    public ParticleLogicArcToEntity generateControlPoints() {
        this.firstControl = new Vector3(this.start.x + (this.target.field_70165_t - this.start.x) / 3.0, this.start.y + (this.target.field_70163_u - this.start.y) / 3.0, this.start.z + (this.target.field_70161_v - this.start.z) / 3.0);
        this.secondControl = new Vector3(this.start.x + (this.target.field_70165_t - this.start.x) / 3.0 * 2.0, this.start.y + (this.target.field_70163_u - this.start.y) / 3.0 * 2.0, this.start.z + (this.target.field_70161_v - this.start.z) / 3.0 * 2.0);
        double offsetX = this.rand.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        double offsetZ = this.rand.nextFloat() * this.offsetFactor - this.halfOffsetFactor;
        Vector3 offset = new Vector3(offsetX, 0.0, offsetZ);
        this.firstControl = this.firstControl.add(offset);
        this.secondControl = this.secondControl.add(offset);
        return this;
    }

    public ParticleLogicArcToEntity setControlPoints(Vector3 first, Vector3 second) {
        this.firstControl = first;
        this.secondControl = second;
        return this;
    }

    public ParticleLogicArcToEntity setSpeed(float speed) {
        this.speed = speed;
        return this;
    }

    @Override
    public void doUpdate() {
        this.percent += this.speed;
        if (this.percent >= 1.0f) {
            this.finishLogic();
            return;
        }
        Vector3 bez = MathLib.bezier((Vector3)this.start, (Vector3)this.firstControl, (Vector3)this.secondControl, (Vector3)new Vector3(this.target.field_70165_t, this.target.field_70163_u, this.target.field_70161_v).add(new Vector3(0.0, (double)this.target.func_70047_e(), 0.0)), (float)this.percent);
        this.particle.func_70107_b(bez.x, bez.y, bez.z);
    }

    @Override
    public ParticleLogic clone() {
        return new ParticleLogicArcToEntity(this.particle.position(), this.target).setSpeed(this.speed).setControlPoints(this.firstControl, this.secondControl).setFinal(this.finalLogic).setPriority(this.priority);
    }
}

