/*
 * Decompiled with CFR 0.152.
 */
package greymerk.roguelike.worldgen.blocks;

import greymerk.roguelike.worldgen.MetaBlock;
import greymerk.roguelike.worldgen.blocks.Log;
import greymerk.roguelike.worldgen.blocks.WoodBlock;
import net.minecraft.init.Blocks;

public enum Wood {
    OAK,
    SPRUCE,
    BIRCH,
    JUNGLE,
    ACACIA,
    DARKOAK;


    public static MetaBlock get(WoodBlock block) {
        return Wood.get(OAK, block);
    }

    public static MetaBlock get(Wood type, WoodBlock block) {
        switch (block) {
            case LOG: {
                return Log.get(type);
            }
            case PLANK: {
                return Wood.getPlank(type);
            }
            case FENCE: {
                return Wood.getFence(type);
            }
        }
        return Log.get(OAK);
    }

    public static MetaBlock getPlank(Wood type) {
        MetaBlock plank = new MetaBlock(Blocks.field_150344_f);
        switch (type) {
            case OAK: {
                plank.setMeta(0);
                break;
            }
            case SPRUCE: {
                plank.setMeta(1);
                break;
            }
            case BIRCH: {
                plank.setMeta(2);
                break;
            }
            case JUNGLE: {
                plank.setMeta(3);
                break;
            }
            case ACACIA: {
                plank.setMeta(4);
                break;
            }
            case DARKOAK: {
                plank.setMeta(5);
            }
        }
        return plank;
    }

    public static MetaBlock getFence(Wood type) {
        return new MetaBlock(Blocks.field_150422_aJ);
    }

    public static MetaBlock getSapling(Wood type) {
        MetaBlock sapling = new MetaBlock(Blocks.field_150345_g);
        switch (type) {
            case OAK: {
                sapling.setMeta(0);
                break;
            }
            case SPRUCE: {
                sapling.setMeta(1);
                break;
            }
            case BIRCH: {
                sapling.setMeta(2);
                break;
            }
            case JUNGLE: {
                sapling.setMeta(3);
                break;
            }
            case ACACIA: {
                sapling.setMeta(4);
                break;
            }
            case DARKOAK: {
                sapling.setMeta(5);
                break;
            }
        }
        return sapling;
    }

    public static MetaBlock applyType(MetaBlock source, MetaBlock destination) {
        int meta = source.getMeta() + (source.getBlock().equals(Blocks.field_150363_s) ? 5 : 0);
        destination.setMeta(meta);
        return destination;
    }
}

