/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.interfaces.IInventoryUtil;
import logisticspipes.interfaces.ISpecialInsertion;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class InventoryUtil
implements IInventoryUtil,
ISpecialInsertion {
    protected final IInventory _inventory;
    private final boolean _hideOnePerStack;
    private final boolean _hideOne;
    private final int _cropStart;
    private final int _cropEnd;

    public InventoryUtil(IInventory inventory, boolean hideOnePerStack, boolean hideOne, int cropStart, int cropEnd) {
        this._inventory = inventory;
        this._hideOnePerStack = hideOnePerStack;
        this._hideOne = hideOne;
        this._cropStart = cropStart;
        this._cropEnd = cropEnd;
    }

    @Override
    public int itemCount(ItemIdentifier item) {
        int count = 0;
        boolean first = true;
        for (int i = this._cropStart; i < this._inventory.func_70302_i_() - this._cropEnd; ++i) {
            ItemStack stack = this._inventory.func_70301_a(i);
            if (stack == null || !ItemIdentifier.get(stack).equals(item)) continue;
            if (first) {
                count = stack.field_77994_a - (this._hideOne || this._hideOnePerStack ? 1 : 0);
                first = false;
                continue;
            }
            count += stack.field_77994_a - (this._hideOnePerStack ? 1 : 0);
        }
        return count;
    }

    @Override
    public Map<ItemIdentifier, Integer> getItemsAndCount() {
        LinkedHashMap<ItemIdentifier, Integer> items = new LinkedHashMap<ItemIdentifier, Integer>();
        for (int i = this._cropStart; i < this._inventory.func_70302_i_() - this._cropEnd; ++i) {
            ItemStack stack = this._inventory.func_70301_a(i);
            if (stack == null) continue;
            ItemIdentifier itemId = ItemIdentifier.get(stack);
            int stackSize = stack.field_77994_a - (this._hideOnePerStack ? 1 : 0);
            Integer currentSize = (Integer)items.get(itemId);
            if (currentSize == null) {
                items.put(itemId, stackSize - (this._hideOne ? 1 : 0));
                continue;
            }
            items.put(itemId, currentSize + stackSize);
        }
        return items;
    }

    @Override
    public Set<ItemIdentifier> getItems() {
        TreeSet<ItemIdentifier> items = new TreeSet<ItemIdentifier>();
        for (int i = this._cropStart; i < this._inventory.func_70302_i_() - this._cropEnd; ++i) {
            ItemStack stack = this._inventory.func_70301_a(i);
            if (stack == null) continue;
            items.add(ItemIdentifier.get(stack));
        }
        return items;
    }

    @Override
    public ItemStack getSingleItem(ItemIdentifier item) {
        return this.getMultipleItems(item, 1);
    }

    @Override
    public ItemStack getMultipleItems(ItemIdentifier item, int count) {
        if (this.itemCount(item) < count) {
            return null;
        }
        ItemStack outputStack = null;
        boolean first = true;
        for (int i = this._cropStart; i < this._inventory.func_70302_i_() - this._cropEnd && count > 0; ++i) {
            ItemStack removed;
            ItemStack stack = this._inventory.func_70301_a(i);
            if (stack == null || stack.field_77994_a == 1 && this._hideOnePerStack || !ItemIdentifier.get(stack).equals(item)) continue;
            int itemsToSplit = Math.min(count, stack.field_77994_a - (first && this._hideOne || this._hideOnePerStack ? 1 : 0));
            first = false;
            if (itemsToSplit == 0) continue;
            if (stack.field_77994_a > itemsToSplit) {
                removed = stack.func_77979_a(itemsToSplit);
                this._inventory.func_70299_a(i, stack);
            } else {
                removed = stack;
                this._inventory.func_70299_a(i, null);
            }
            if (outputStack == null) {
                outputStack = removed;
            } else {
                outputStack.field_77994_a += removed.field_77994_a;
            }
            count -= removed.field_77994_a;
        }
        this._inventory.func_70296_d();
        return outputStack;
    }

    @Override
    public boolean containsUndamagedItem(ItemIdentifier item) {
        for (int i = 0; i < this._inventory.func_70302_i_(); ++i) {
            ItemStack stack = this._inventory.func_70301_a(i);
            if (stack == null || !ItemIdentifier.get(stack).getUndamaged().equals(item)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int roomForItem(ItemIdentifier item) {
        return this.roomForItem(item, Integer.MAX_VALUE);
    }

    @Override
    public int roomForItem(ItemIdentifier item, int count) {
        int totalRoom = 0;
        int stackLimit = this._inventory.func_70297_j_();
        for (int i = 0; i < this._inventory.func_70302_i_() && count > totalRoom; ++i) {
            ItemStack stack = this._inventory.func_70301_a(i);
            if (stack == null) {
                if (!this._inventory.func_94041_b(i, item.unsafeMakeNormalStack(1))) continue;
                totalRoom += Math.min(stackLimit, item.getMaxStackSize());
                continue;
            }
            if (!ItemIdentifier.get(stack).equals(item)) continue;
            totalRoom += Math.min(stackLimit, item.getMaxStackSize()) - stack.field_77994_a;
        }
        return totalRoom;
    }

    @Override
    public boolean isSpecialInventory() {
        return false;
    }

    @Override
    public int getSizeInventory() {
        return this._inventory.func_70302_i_();
    }

    @Override
    public ItemStack getStackInSlot(int i) {
        return this._inventory.func_70301_a(i);
    }

    @Override
    public ItemStack decrStackSize(int i, int j) {
        ItemStack stack = this._inventory.func_70298_a(i, j);
        this._inventory.func_70296_d();
        return stack;
    }

    @Override
    public int addToSlot(ItemStack stack, int i) {
        if (!this._inventory.func_94041_b(i, stack)) {
            return 0;
        }
        int max = Math.min(stack.func_77976_d(), this._inventory.func_70297_j_());
        ItemStack stackInSlot = this._inventory.func_70301_a(i);
        if (stackInSlot == null) {
            int wanted = Math.min(stack.field_77994_a, max);
            stackInSlot = stack.func_77946_l();
            stackInSlot.field_77994_a = wanted;
            this._inventory.func_70299_a(i, stackInSlot);
            return wanted;
        }
        if (!ItemIdentifier.get(stackInSlot).equals(ItemIdentifier.get(stack))) {
            return 0;
        }
        int toAdd = max - stackInSlot.field_77994_a;
        if (toAdd < 0) {
            return 0;
        }
        if (toAdd > stack.field_77994_a) {
            toAdd = stack.field_77994_a;
        }
        stackInSlot.field_77994_a += toAdd;
        this._inventory.func_70299_a(i, stackInSlot);
        this._inventory.func_70296_d();
        return toAdd;
    }
}

