/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets;

import java.io.IOException;
import java.util.EnumSet;
import logisticspipes.network.LPDataInputStream;
import logisticspipes.network.LPDataOutputStream;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.recipes.CraftingDependency;
import net.minecraft.entity.player.EntityPlayer;

public class CraftingPermissionPacket
extends ModernPacket {
    EnumSet<CraftingDependency> enumSet;

    public CraftingPermissionPacket(int id) {
        super(id);
    }

    @Override
    public void readData(LPDataInputStream data) throws IOException {
        this.enumSet = EnumSet.noneOf(CraftingDependency.class);
        for (CraftingDependency type : CraftingDependency.values()) {
            if (!data.readBoolean()) continue;
            this.enumSet.add(type);
        }
    }

    @Override
    public void processPacket(EntityPlayer player) {
        SimpleServiceLocator.craftingPermissionManager.clientSidePermission = this.enumSet;
    }

    @Override
    public void writeData(LPDataOutputStream data) throws IOException {
        for (CraftingDependency type : CraftingDependency.values()) {
            data.writeBoolean(this.enumSet.contains((Object)type));
        }
    }

    @Override
    public ModernPacket template() {
        return new CraftingPermissionPacket(this.getId());
    }

    @Override
    public boolean isCompressable() {
        return true;
    }

    public EnumSet<CraftingDependency> getEnumSet() {
        return this.enumSet;
    }

    public CraftingPermissionPacket setEnumSet(EnumSet<CraftingDependency> enumSet) {
        this.enumSet = enumSet;
        return this;
    }
}

