/*
 * Decompiled with CFR 0.152.
 */
package com.gtnewhorizons.neid.mixins.early.minecraft;

import it.unimi.dsi.fastutil.ints.Int2IntOpenHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;

@Mixin(value={Block.class})
public class MixinBlock {
    @Unique
    private String neid$defaultHarvestTool = null;
    @Unique
    private int neid$defaultHarvestLevel = -1;
    @Unique
    private Int2ObjectOpenHashMap<String> harvestToolMap = new Int2ObjectOpenHashMap();
    @Unique
    private Int2IntOpenHashMap harvestLevelMap = new Int2IntOpenHashMap();
    @Shadow(remap=false)
    private String[] harvestTool = null;
    @Shadow(remap=false)
    private int[] harvestLevel = null;

    @Overwrite(remap=false)
    public void setHarvestLevel(String toolClass, int level) {
        this.neid$defaultHarvestTool = toolClass;
        this.neid$defaultHarvestLevel = level;
    }

    @Overwrite(remap=false)
    public void setHarvestLevel(String toolClass, int level, int metadata) {
        this.harvestToolMap.put(metadata, (Object)toolClass);
        this.harvestLevelMap.put(metadata, level);
    }

    @Overwrite(remap=false)
    public String getHarvestTool(int metadata) {
        return (String)this.harvestToolMap.getOrDefault(metadata, (Object)this.neid$defaultHarvestTool);
    }

    @Overwrite(remap=false)
    public int getHarvestLevel(int metadata) {
        return this.harvestLevelMap.getOrDefault(metadata, this.neid$defaultHarvestLevel);
    }

    @Overwrite(remap=false)
    public boolean isToolEffective(String type, int metadata) {
        Block self = (Block)this;
        if ("pickaxe".equals(type) && (self == Blocks.field_150450_ax || self == Blocks.field_150439_ay || self == Blocks.field_150343_Z)) {
            return false;
        }
        String harvestTool = this.getHarvestTool(metadata);
        if (harvestTool == null) {
            return false;
        }
        return harvestTool.equals(type);
    }
}

