/*
 * Decompiled with CFR 0.152.
 */
package micdoodle8.mods.galacticraft.core.nei;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.NEIServerUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import micdoodle8.mods.galacticraft.core.GalacticraftCore;
import micdoodle8.mods.galacticraft.core.nei.NEIGalacticraftConfig;
import micdoodle8.mods.galacticraft.core.util.EnumColor;
import micdoodle8.mods.galacticraft.core.util.GCCoreUtil;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import org.lwjgl.opengl.GL11;

public class BuggyRecipeHandler
extends TemplateRecipeHandler {
    private static final ResourceLocation buggyGuiTexture = new ResourceLocation(GalacticraftCore.ASSET_PREFIX, "textures/gui/schematic_rocket_GS1_Buggy.png");
    public static final int x = -1;
    public static final int y = -12;
    public static final int tX = 3;
    public static final int tY = 4;
    public static final int w = 168;
    public static final int h = 130;

    public String getRecipeId() {
        return "galacticraft.buggy";
    }

    public int recipiesPerPage() {
        return 1;
    }

    public Set<Map.Entry<ArrayList<PositionedStack>, PositionedStack>> getRecipes() {
        HashMap recipes = new HashMap();
        for (Map.Entry<HashMap<Integer, PositionedStack>, PositionedStack> stack : NEIGalacticraftConfig.getBuggyBenchRecipes()) {
            ArrayList<PositionedStack> inputStacks = new ArrayList<PositionedStack>();
            for (Map.Entry<Integer, PositionedStack> input : stack.getKey().entrySet()) {
                inputStacks.add(input.getValue());
            }
            recipes.put(inputStacks, stack.getValue());
        }
        return recipes.entrySet();
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((ResourceLocation)buggyGuiTexture);
        GuiDraw.drawTexturedModalRect((int)-1, (int)-12, (int)3, (int)4, (int)168, (int)130);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(250, 126, 32, 32), this.getRecipeId(), new Object[0]));
    }

    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals(this.getRecipeId())) {
            for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
                this.arecipes.add(new CachedBuggyRecipe(irecipe));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)irecipe.getValue().item, (ItemStack)result)) continue;
            this.arecipes.add(new CachedBuggyRecipe(irecipe));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        block0: for (Map.Entry<ArrayList<PositionedStack>, PositionedStack> irecipe : this.getRecipes()) {
            for (PositionedStack pstack : irecipe.getKey()) {
                if (!NEIServerUtils.areStacksSameTypeCrafting((ItemStack)ingredient, (ItemStack)pstack.item)) continue;
                this.arecipes.add(new CachedBuggyRecipe(irecipe));
                continue block0;
            }
        }
    }

    public String getRecipeName() {
        return (Object)((Object)EnumColor.INDIGO) + GCCoreUtil.translate("tile.rocketWorkbench.name");
    }

    public String getGuiTexture() {
        return GalacticraftCore.TEXTURE_PREFIX + "textures/gui/schematic_rocket_GS1_Buggy.png";
    }

    public void drawForeground(int recipe) {
    }

    public class CachedBuggyRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        public ArrayList<PositionedStack> input;
        public PositionedStack output;

        public ArrayList<PositionedStack> getIngredients() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public CachedBuggyRecipe(ArrayList<PositionedStack> pstack1, PositionedStack pstack2) {
            super((TemplateRecipeHandler)BuggyRecipeHandler.this);
            this.input = pstack1;
            this.output = pstack2;
        }

        public CachedBuggyRecipe(Map.Entry<ArrayList<PositionedStack>, PositionedStack> recipe) {
            this(recipe.getKey(), recipe.getValue());
        }
    }
}

